/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.EncodeJsonRpcException;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import org.jspecify.annotations.Nullable;

public interface IncomingRpcMethod<Params, Result> {
    public MethodInfo<Params, Result> info();

    public Attributes attributes();

    public JsonElement apply(MinecraftApi var1, @Nullable JsonElement var2, ClientInfo var3);

    public static <Result> IncomingRpcMethodBuilder<Void, Result> method(ParameterlessRpcMethodFunction<Result> parameterlessFunction) {
        return new IncomingRpcMethodBuilder(parameterlessFunction);
    }

    public static <Params, Result> IncomingRpcMethodBuilder<Params, Result> method(RpcMethodFunction<Params, Result> parameterFunction) {
        return new IncomingRpcMethodBuilder<Params, Result>(parameterFunction);
    }

    public static <Result> IncomingRpcMethodBuilder<Void, Result> method(Function<MinecraftApi, Result> parameterlessFunction) {
        return new IncomingRpcMethodBuilder(parameterlessFunction);
    }

    public static class IncomingRpcMethodBuilder<Params, Result> {
        private String description = "";
        private @Nullable ParamInfo<Params> paramInfo;
        private @Nullable ResultInfo<Result> resultInfo;
        private boolean discoverable = true;
        private boolean runOnMainThread = true;
        private @Nullable ParameterlessRpcMethodFunction<Result> parameterlessFunction;
        private @Nullable RpcMethodFunction<Params, Result> parameterFunction;

        public IncomingRpcMethodBuilder(ParameterlessRpcMethodFunction<Result> parameterlessFunction) {
            this.parameterlessFunction = parameterlessFunction;
        }

        public IncomingRpcMethodBuilder(RpcMethodFunction<Params, Result> parameterFunction) {
            this.parameterFunction = parameterFunction;
        }

        public IncomingRpcMethodBuilder(Function<MinecraftApi, Result> parameterlessFunction) {
            this.parameterlessFunction = (api, client) -> parameterlessFunction.apply(api);
        }

        public IncomingRpcMethodBuilder<Params, Result> description(String description) {
            this.description = description;
            return this;
        }

        public IncomingRpcMethodBuilder<Params, Result> response(String name, Schema<Result> schema) {
            this.resultInfo = new ResultInfo<Result>(name, schema.info());
            return this;
        }

        public IncomingRpcMethodBuilder<Params, Result> param(String name, Schema<Params> schema) {
            this.paramInfo = new ParamInfo<Params>(name, schema.info());
            return this;
        }

        public IncomingRpcMethodBuilder<Params, Result> undiscoverable() {
            this.discoverable = false;
            return this;
        }

        public IncomingRpcMethodBuilder<Params, Result> notOnMainThread() {
            this.runOnMainThread = false;
            return this;
        }

        public IncomingRpcMethod<Params, Result> build() {
            if (this.resultInfo == null) {
                throw new IllegalStateException("No response defined");
            }
            Attributes attributes = new Attributes(this.runOnMainThread, this.discoverable);
            MethodInfo<Params, Result> methodInfo = new MethodInfo<Params, Result>(this.description, this.paramInfo, this.resultInfo);
            if (this.parameterlessFunction != null) {
                return new ParameterlessMethod<Params, Result>(methodInfo, attributes, this.parameterlessFunction);
            }
            if (this.parameterFunction != null) {
                if (this.paramInfo == null) {
                    throw new IllegalStateException("No param schema defined");
                }
                return new Method<Params, Result>(methodInfo, attributes, this.parameterFunction);
            }
            throw new IllegalStateException("No method defined");
        }

        public IncomingRpcMethod<?, ?> register(Registry<IncomingRpcMethod<?, ?>> registry, String namespace) {
            return this.register(registry, Identifier.withDefaultNamespace(namespace));
        }

        private IncomingRpcMethod<?, ?> register(Registry<IncomingRpcMethod<?, ?>> registry, Identifier id) {
            return Registry.register(registry, id, this.build());
        }
    }

    @FunctionalInterface
    public static interface ParameterlessRpcMethodFunction<Result> {
        public Result apply(MinecraftApi var1, ClientInfo var2);
    }

    @FunctionalInterface
    public static interface RpcMethodFunction<Params, Result> {
        public Result apply(MinecraftApi var1, Params var2, ClientInfo var3);
    }

    public record ParameterlessMethod<Params, Result>(MethodInfo<Params, Result> info, Attributes attributes, ParameterlessRpcMethodFunction<Result> supplier) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement apply(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params == null || params.isJsonArray() && params.getAsJsonArray().isEmpty()) {
                if (this.info.params().isPresent()) {
                    throw new IllegalArgumentException("Parameterless method unexpectedly has parameter description");
                }
                Result object = this.supplier.apply(api, client);
                if (this.info.result().isEmpty()) {
                    throw new IllegalStateException("No result codec defined");
                }
                return (JsonElement)this.info.result().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(InvalidParameterJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected no params, or an empty array");
        }
    }

    public record Method<Params, Result>(MethodInfo<Params, Result> info, Attributes attributes, RpcMethodFunction<Params, Result> function) implements IncomingRpcMethod<Params, Result>
    {
        @Override
        public JsonElement apply(MinecraftApi api, @Nullable JsonElement params, ClientInfo client) {
            if (params != null && (params.isJsonArray() || params.isJsonObject())) {
                JsonElement jsonElement1;
                if (this.info.params().isEmpty()) {
                    throw new IllegalArgumentException("Method defined as having parameters without describing them");
                }
                if (params.isJsonObject()) {
                    String string = this.info.params().get().name();
                    JsonElement jsonElement = params.getAsJsonObject().get(string);
                    if (jsonElement == null) {
                        throw new InvalidParameterJsonRpcException(String.format(Locale.ROOT, "Params passed by-name, but expected param [%s] does not exist", string));
                    }
                    jsonElement1 = jsonElement;
                } else {
                    JsonArray asJsonArray = params.getAsJsonArray();
                    if (asJsonArray.isEmpty() || asJsonArray.size() > 1) {
                        throw new InvalidParameterJsonRpcException("Expected exactly one element in the params array");
                    }
                    jsonElement1 = asJsonArray.get(0);
                }
                Object orThrow = this.info.params().get().schema().codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement1).getOrThrow(InvalidParameterJsonRpcException::new);
                Result object = this.function.apply(api, orThrow, client);
                if (this.info.result().isEmpty()) {
                    throw new IllegalStateException("No result codec defined");
                }
                return (JsonElement)this.info.result().get().schema().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(EncodeJsonRpcException::new);
            }
            throw new InvalidParameterJsonRpcException("Expected params as array or named");
        }
    }

    public record Attributes(boolean runOnMainThread, boolean discoverable) {
    }
}

