/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.Message;
import net.minecraft.server.level.ServerPlayer;
import org.jspecify.annotations.Nullable;

public class PlayerService {
    private static final Component DEFAULT_KICK_MESSAGE = Component.translatable("multiplayer.disconnect.kicked");

    public static List<PlayerDto> get(MinecraftApi api) {
        return api.playerListService().getPlayers().stream().map(PlayerDto::from).toList();
    }

    public static List<PlayerDto> kick(MinecraftApi api, List<KickDto> kicks, ClientInfo client) {
        ArrayList<PlayerDto> list = new ArrayList<PlayerDto>();
        for (KickDto kickDto : kicks) {
            ServerPlayer serverPlayer = PlayerService.getServerPlayer(api, kickDto.player());
            if (serverPlayer == null) continue;
            api.playerListService().remove(serverPlayer, client);
            serverPlayer.connection.disconnect(kickDto.message.flatMap(Message::asComponent).orElse(DEFAULT_KICK_MESSAGE));
            list.add(kickDto.player());
        }
        return list;
    }

    private static @Nullable ServerPlayer getServerPlayer(MinecraftApi api, PlayerDto player) {
        if (player.id().isPresent()) {
            return api.playerListService().getPlayer(player.id().get());
        }
        return player.name().isPresent() ? api.playerListService().getPlayerByName(player.name().get()) : null;
    }

    public record KickDto(PlayerDto player, Optional<Message> message) {
        public static final MapCodec<KickDto> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(KickDto::player), (App)Message.CODEC.optionalFieldOf("message").forGetter(KickDto::message)).apply((Applicative)instance, KickDto::new));
    }
}

