/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level.progress;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public interface LevelLoadListener {
    public static LevelLoadListener compose(final LevelLoadListener levelLoadListener1, final LevelLoadListener levelLoadListener2) {
        return new LevelLoadListener(){

            @Override
            public void start(Stage stage, int totalChunks) {
                levelLoadListener1.start(stage, totalChunks);
                levelLoadListener2.start(stage, totalChunks);
            }

            @Override
            public void update(Stage stage, int readyChunks, int totalChunks) {
                levelLoadListener1.update(stage, readyChunks, totalChunks);
                levelLoadListener2.update(stage, readyChunks, totalChunks);
            }

            @Override
            public void finish(Stage stage) {
                levelLoadListener1.finish(stage);
                levelLoadListener2.finish(stage);
            }

            @Override
            public void updateFocus(ResourceKey<Level> dimension, ChunkPos chunkPos) {
                levelLoadListener1.updateFocus(dimension, chunkPos);
                levelLoadListener2.updateFocus(dimension, chunkPos);
            }
        };
    }

    public void start(Stage var1, int var2);

    public void update(Stage var1, int var2, int var3);

    public void finish(Stage var1);

    public void updateFocus(ResourceKey<Level> var1, ChunkPos var2);

    public static LevelLoadListener noop() {
        return new LevelLoadListener(){

            @Override
            public void start(Stage stage, int totalChunks) {
            }

            @Override
            public void update(Stage stage, int readyChunks, int totalChunks) {
            }

            @Override
            public void finish(Stage stage) {
            }

            @Override
            public void updateFocus(ResourceKey<Level> dimension, ChunkPos chunkPos) {
            }
        };
    }

    public static enum Stage {
        START_SERVER,
        PREPARE_GLOBAL_SPAWN,
        LOAD_INITIAL_CHUNKS,
        LOAD_PLAYER_CHUNKS;

    }
}

