/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.DisconnectionReason;
import io.papermc.paper.connection.PaperCommonConnection;
import io.papermc.paper.connection.PaperPlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PluginMessageBridgeImpl;
import io.papermc.paper.event.player.PaperPlayerCustomClickEvent;
import io.papermc.paper.util.KeepAlive;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Vec3i;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomClickActionPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.Util;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LATENCY_CHECK_INTERVAL = 15000;
    private static final int CLOSED_LISTENER_TIMEOUT = 15000;
    private static final net.minecraft.network.chat.Component TIMEOUT_DISCONNECTION_MESSAGE = net.minecraft.network.chat.Component.translatable("disconnect.timeout");
    static final net.minecraft.network.chat.Component DISCONNECT_UNEXPECTED_QUERY = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer server;
    public final Connection connection;
    private final boolean transferred;
    private long closedListenerTime;
    private boolean closed = false;
    private volatile int latency;
    private final KeepAlive keepAlive;
    private volatile boolean suspendFlushingOnServerThread = false;
    public final CraftServer cserver;
    public boolean processedDisconnect;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final Identifier MINECRAFT_BRAND = Identifier.withDefaultNamespace("brand");
    public @Nullable String playerBrand;
    public final Set<String> pluginMessagerChannels;
    public static final Identifier CUSTOM_REGISTER = Identifier.withDefaultNamespace("register");
    private static final Identifier CUSTOM_UNREGISTER = Identifier.withDefaultNamespace("unregister");

    public ServerCommonPacketListenerImpl(MinecraftServer server, Connection connection, CommonListenerCookie cookie) {
        this.server = server;
        this.connection = connection;
        this.latency = cookie.latency();
        this.transferred = cookie.transferred();
        this.playerBrand = cookie.brandName();
        this.cserver = server.server;
        this.pluginMessagerChannels = cookie.channels();
        this.keepAlive = cookie.keepAlive();
    }

    public abstract PlayerCommonConnection getApiConnection();

    public abstract Audience getAudience();

    private void close() {
        if (!this.closed) {
            this.closedListenerTime = Util.getMillis();
            this.closed = true;
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails details) {
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    @Override
    public void onPacketError(Packet packet, Exception exception) throws ReportedException {
        ServerCommonPacketListener.super.onPacketError(packet, exception);
        this.server.reportPacketHandlingException(exception, packet.type());
    }

    @Override
    public void handleKeepAlive(ServerboundKeepAlivePacket packet) {
        long now = System.nanoTime();
        KeepAlive.PendingKeepAlive pending = (KeepAlive.PendingKeepAlive)this.keepAlive.pendingKeepAlives.peek();
        if (pending != null && pending.challengeId() == packet.getId()) {
            this.keepAlive.pendingKeepAlives.remove((Object)pending);
            KeepAlive.KeepAliveResponse response = new KeepAlive.KeepAliveResponse(pending.txTimeNS(), now);
            this.keepAlive.pingCalculator1m.update(response);
            this.keepAlive.pingCalculator5s.update(response);
            this.latency = this.keepAlive.pingCalculator5s.getAvgLatencyMS();
            return;
        }
        Iterator itr = this.keepAlive.pendingKeepAlives.iterator();
        while (itr.hasNext()) {
            KeepAlive.PendingKeepAlive ka = (KeepAlive.PendingKeepAlive)itr.next();
            if (ka.challengeId() != packet.getId()) continue;
            itr.remove();
            if (this.processedDisconnect) break;
            LOGGER.info("Disconnecting {} for sending keepalive response ({}) out-of-order!", (Object)this.playerProfile().name(), (Object)packet.getId());
            this.disconnectAsync(TIMEOUT_DISCONNECTION_MESSAGE, DisconnectionReason.TIMEOUT);
            return;
        }
        if (!this.processedDisconnect) {
            LOGGER.info("Disconnecting {} for sending keepalive response ({}) without matching challenge!", (Object)this.playerProfile().name(), (Object)packet.getId());
            this.disconnectAsync(TIMEOUT_DISCONNECTION_MESSAGE, DisconnectionReason.TIMEOUT);
            return;
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket packet) {
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket packet) {
        CustomPacketPayload customPacketPayload = packet.payload();
        if (!(customPacketPayload instanceof DiscardedPayload)) {
            return;
        }
        DiscardedPayload discardedPayload = (DiscardedPayload)customPacketPayload;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server.packetProcessor());
        Identifier identifier = packet.payload().type().id();
        byte[] data = discardedPayload.data();
        try {
            boolean registerChannel = CUSTOM_REGISTER.equals(identifier);
            if (registerChannel || CUSTOM_UNREGISTER.equals(identifier)) {
                int startIndex = 0;
                for (int i = 0; i < data.length; ++i) {
                    byte b = data[i];
                    if (b != 0) continue;
                    this.readChannelIdentifier(data, startIndex, i, registerChannel);
                    startIndex = i + 1;
                }
                this.readChannelIdentifier(data, startIndex, data.length, registerChannel);
                return;
            }
            if (identifier.equals(MINECRAFT_BRAND)) {
                this.playerBrand = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data)).readUtf(256);
            }
            this.cserver.getMessenger().dispatchIncomingMessage(this.paperConnection(), identifier.toString(), data);
        }
        catch (Exception e) {
            ServerGamePacketListenerImpl.LOGGER.error("Couldn't handle custom payload on channel {}", (Object)identifier, (Object)e);
            this.disconnect(net.minecraft.network.chat.Component.literal("Invalid custom payload payload!"), DisconnectionReason.INVALID_PAYLOAD);
        }
    }

    private void readChannelIdentifier(byte[] data, int from, int to, boolean register) {
        PaperPlayerConfigurationConnection bridge;
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
        Objects.requireNonNull(serverCommonPacketListenerImpl);
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl2 = serverCommonPacketListenerImpl;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerGamePacketListenerImpl.class, ServerConfigurationPacketListenerImpl.class}, (Object)serverCommonPacketListenerImpl2, n)) {
            case 0: {
                ServerGamePacketListenerImpl gamePacketListener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImpl2;
                PluginMessageBridgeImpl pluginMessageBridgeImpl = gamePacketListener.player.getBukkitEntity();
                break;
            }
            case 1: {
                ServerConfigurationPacketListenerImpl commonPacketListener = (ServerConfigurationPacketListenerImpl)serverCommonPacketListenerImpl2;
                PluginMessageBridgeImpl pluginMessageBridgeImpl = commonPacketListener.paperConnection;
                break;
            }
            default: {
                PluginMessageBridgeImpl pluginMessageBridgeImpl = bridge = null;
            }
        }
        if (bridge == null) {
            return;
        }
        int length = to - from;
        if (length == 0) {
            return;
        }
        String channel = new String(data, from, length, StandardCharsets.US_ASCII);
        if (register) {
            bridge.addChannel(channel);
        } else {
            bridge.removeChannel(channel);
        }
    }

    @Override
    public void handleCustomClickAction(ServerboundCustomClickActionPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server.packetProcessor());
        this.server.handleCustomClickAction(packet.id(), packet.payload());
        PaperPlayerCustomClickEvent event = new PaperPlayerCustomClickEvent(PaperAdventure.asAdventure(packet.id()), this.getApiConnection(), packet.payload().orElse(null));
        event.callEvent();
        ClickCallbackProviderImpl.DIALOG_CLICK_MANAGER.tryRunCallback(this.getAudience(), packet.id(), packet.payload());
        ClickCallbackProviderImpl.ADVENTURE_CLICK_MANAGER.tryRunCallback(this.getAudience(), packet.id(), packet.payload());
    }

    @Override
    public void handleResourcePackResponse(ServerboundResourcePackPacket packet) {
        ResourcePackCallback callback;
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server.packetProcessor());
        if (packet.action() == ServerboundResourcePackPacket.Action.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack {} rejection", (Object)this.playerProfile().name(), (Object)packet.id());
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.requiredTexturePrompt.disconnect"), DisconnectionReason.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.action().isTerminal() ? this.packCallbacks.remove(packet.id()) : this.packCallbacks.get(packet.id())) != null) {
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
            Objects.requireNonNull(serverCommonPacketListenerImpl);
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl2 = serverCommonPacketListenerImpl;
            int n = 0;
            CraftPlayer audience = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerGamePacketListenerImpl.class, ServerConfigurationPacketListenerImpl.class}, (Object)serverCommonPacketListenerImpl2, n)) {
                case 0 -> {
                    ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImpl2;
                    yield serverGamePacketListener.getCraftPlayer();
                }
                case 1 -> {
                    ServerConfigurationPacketListenerImpl configurationPacketListener = (ServerConfigurationPacketListenerImpl)serverCommonPacketListenerImpl2;
                    yield configurationPacketListener.paperConnection.getAudience();
                }
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this));
            };
            callback.packEventReceived(packet.id(), ResourcePackStatus.valueOf((String)packet.action().name()), (Audience)audience);
        }
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket packet) {
        if (this.paperConnection().handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(DISCONNECT_UNEXPECTED_QUERY, DisconnectionReason.INVALID_COOKIE);
    }

    protected void keepConnectionAlive() {
        Profiler.get().push("keepAlive");
        long millis = Util.getMillis();
        if (this.checkIfClosed(millis) && !this.processedDisconnect) {
            KeepAlive.PendingKeepAlive oldest;
            long currTime = System.nanoTime();
            if (currTime - this.keepAlive.lastKeepAliveTx >= TimeUnit.SECONDS.toNanos(1L)) {
                this.keepAlive.lastKeepAliveTx = currTime;
                KeepAlive.PendingKeepAlive pka = new KeepAlive.PendingKeepAlive(currTime, millis);
                this.keepAlive.pendingKeepAlives.add((Object)pka);
                this.send(new ClientboundKeepAlivePacket(pka.challengeId()));
            }
            if ((oldest = (KeepAlive.PendingKeepAlive)this.keepAlive.pendingKeepAlives.peek()) != null && currTime - oldest.txTimeNS() > TimeUnit.MILLISECONDS.toNanos(KEEPALIVE_LIMIT)) {
                LOGGER.info("{} was kicked due to keepalive timeout!", (Object)this.playerProfile().name());
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, DisconnectionReason.TIMEOUT);
            }
        }
        Profiler.get().pop();
    }

    private boolean checkIfClosed(long time) {
        if (this.closed) {
            if (time - this.closedListenerTime >= 15000L) {
                this.disconnect(TIMEOUT_DISCONNECTION_MESSAGE, DisconnectionReason.TIMEOUT);
            }
            return false;
        }
        return true;
    }

    public void suspendFlushing() {
        this.suspendFlushingOnServerThread = true;
    }

    public void resumeFlushing() {
        this.suspendFlushingOnServerThread = false;
        this.connection.flushChannel();
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable ChannelFutureListener sendListener) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof ClientboundSetDefaultSpawnPositionPacket) {
            ClientboundSetDefaultSpawnPositionPacket defaultSpawnPositionPacket = (ClientboundSetDefaultSpawnPositionPacket)packet;
            ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
            if (serverCommonPacketListenerImpl instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImpl;
                serverGamePacketListener.player.compassTarget = CraftLocation.toBukkit((Vec3i)defaultSpawnPositionPacket.respawnData().pos(), (Level)serverGamePacketListener.getPlayer().level());
            }
        }
        if (packet.isTerminal()) {
            this.close();
        }
        boolean flag = !this.suspendFlushingOnServerThread || !this.server.isSameThread();
        try {
            this.connection.send(packet, sendListener, flag);
        }
        catch (Throwable var7) {
            CrashReport crashReport = CrashReport.forThrowable(var7, "Sending packet");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Packet being sent");
            crashReportCategory.setDetail("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashReport);
        }
    }

    @Deprecated
    @DoNotUse
    public void disconnect(net.minecraft.network.chat.Component reason) {
        this.disconnect(reason, DisconnectionReason.UNKNOWN);
    }

    public void disconnect(net.minecraft.network.chat.Component reason, DisconnectionReason cause) {
        this.disconnect(new DisconnectionDetails(reason, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(cause)));
    }

    public void disconnect(final DisconnectionDetails disconnectionDetails) {
        net.minecraft.network.chat.Component leaveMessage;
        net.minecraft.network.chat.Component reason;
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.disconnect(disconnectionDetails);
                    return null;
                }
            };
            this.server.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        ServerCommonPacketListenerImpl serverCommonPacketListenerImpl = this;
        if (serverCommonPacketListenerImpl instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)serverCommonPacketListenerImpl;
            TranslatableComponent rawLeaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? serverGamePacketListener.player.getBukkitEntity().displayName() : Component.text((String)serverGamePacketListener.player.getScoreboardName())});
            ServerPlayer player = serverGamePacketListener.player;
            PlayerKickEvent.Cause cause = disconnectionDetails.disconnectionReason().orElseThrow().game().orElse(PlayerKickEvent.Cause.UNKNOWN);
            PlayerKickEvent event = new PlayerKickEvent((Player)player.getBukkitEntity(), PaperAdventure.asAdventure(disconnectionDetails.reason()), (Component)rawLeaveMessage, cause);
            if (this.cserver.getServer().isRunning()) {
                this.cserver.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return;
            }
            reason = PaperAdventure.asVanilla(event.reason());
            leaveMessage = PaperAdventure.asVanilla(event.leaveMessage());
            serverGamePacketListener.player.quitReason = PlayerQuitEvent.QuitReason.KICKED;
            switch (cause) {
                case FLYING_PLAYER: {
                    LOGGER.warn("{} was kicked for floating too long!", (Object)player.getPlainTextName());
                    break;
                }
                case FLYING_VEHICLE: {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)player.getPlainTextName());
                }
            }
        } else {
            reason = disconnectionDetails.reason();
            leaveMessage = null;
        }
        this.disconnect0(new DisconnectionDetails(reason, disconnectionDetails.report(), disconnectionDetails.bugReportLink(), Optional.ofNullable(leaveMessage), disconnectionDetails.disconnectionReason()));
    }

    private void disconnect0(DisconnectionDetails disconnectionDetails) {
        this.connection.send(new ClientboundDisconnectPacket(disconnectionDetails.reason()), PacketSendListener.thenRun(() -> this.connection.disconnect(disconnectionDetails)));
        this.onDisconnect(disconnectionDetails);
        this.connection.setReadOnly();
        this.server.scheduleOnMain(this.connection::handleDisconnection);
    }

    public final void disconnectAsync(net.minecraft.network.chat.Component component, DisconnectionReason reason) {
        this.disconnectAsync(new DisconnectionDetails(component, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(reason)));
    }

    @Deprecated
    @DoNotUse
    public final void disconnectAsync(net.minecraft.network.chat.Component component) {
        this.disconnectAsync(component, DisconnectionReason.UNKNOWN);
    }

    public abstract void disconnectAsync(DisconnectionDetails var1);

    public boolean isTransferred() {
        return this.transferred;
    }

    public abstract PaperCommonConnection<?> paperConnection();

    protected boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(new NameAndId(this.playerProfile()));
    }

    protected abstract GameProfile playerProfile();

    @VisibleForDebug
    public GameProfile getOwner() {
        return this.playerProfile();
    }

    public int latency() {
        return this.latency;
    }

    protected CommonListenerCookie createCookie(ClientInformation clientInformation) {
        return new CommonListenerCookie(this.playerProfile(), this.latency, clientInformation, this.transferred, this.playerBrand, this.pluginMessagerChannels, this.keepAlive);
    }
}

