/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.permissions;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionSet;

public class PermissionSetUnion
implements PermissionSet {
    private final ReferenceSet<PermissionSet> permissions = new ReferenceArraySet();

    PermissionSetUnion(PermissionSet first, PermissionSet second) {
        this.permissions.add((Object)first);
        this.permissions.add((Object)second);
        this.ensureNoUnionsWithinUnions();
    }

    private PermissionSetUnion(ReferenceSet<PermissionSet> oldPermissions, PermissionSet other) {
        this.permissions.addAll(oldPermissions);
        this.permissions.add((Object)other);
        this.ensureNoUnionsWithinUnions();
    }

    private PermissionSetUnion(ReferenceSet<PermissionSet> oldPermissions, ReferenceSet<PermissionSet> other) {
        this.permissions.addAll(oldPermissions);
        this.permissions.addAll(other);
        this.ensureNoUnionsWithinUnions();
    }

    @Override
    public boolean hasPermission(Permission permission) {
        for (PermissionSet permissionSet : this.permissions) {
            if (!permissionSet.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PermissionSet union(PermissionSet permissions) {
        PermissionSetUnion permissionSetUnion;
        if (permissions instanceof PermissionSetUnion) {
            PermissionSetUnion permissionSetUnion2 = (PermissionSetUnion)permissions;
            permissionSetUnion = new PermissionSetUnion(this.permissions, permissionSetUnion2.permissions);
        } else {
            permissionSetUnion = new PermissionSetUnion(this.permissions, permissions);
        }
        return permissionSetUnion;
    }

    @VisibleForTesting
    public ReferenceSet<PermissionSet> getPermissions() {
        return new ReferenceArraySet(this.permissions);
    }

    private void ensureNoUnionsWithinUnions() {
        for (PermissionSet permissionSet : this.permissions) {
            if (!(permissionSet instanceof PermissionSetUnion)) continue;
            throw new IllegalArgumentException("Cannot have PermissionSetUnion within another PermissionSetUnion");
        }
    }
}

