/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CachedUserNameToIdResolver
implements UserNameToIdResolver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private boolean resolveOfflineUsers = true;
    private final Map<String, GameProfileInfo> profilesByName = new ConcurrentHashMap<String, GameProfileInfo>();
    private final Map<UUID, GameProfileInfo> profilesByUUID = new ConcurrentHashMap<UUID, GameProfileInfo>();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();
    protected final ReentrantLock stateLock = new ReentrantLock();
    protected final ReentrantLock lookupLock = new ReentrantLock();

    public CachedUserNameToIdResolver(GameProfileRepository profileRepository, File file) {
        this.profileRepository = profileRepository;
        this.file = file;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(GameProfileInfo profileInfo) {
        try {
            this.stateLock.lock();
            NameAndId nameAndId = profileInfo.nameAndId();
            profileInfo.setLastAccess(this.getNextOperation());
            this.profilesByName.put(nameAndId.name().toLowerCase(Locale.ROOT), profileInfo);
            this.profilesByUUID.put(nameAndId.id(), profileInfo);
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private Optional<NameAndId> lookupGameProfile(GameProfileRepository profileRepository, String name) {
        if (!StringUtil.isValidPlayerName(name)) {
            return this.createUnknownProfile(name);
        }
        boolean shouldLookup = !StringUtils.isBlank((CharSequence)name) && GlobalConfiguration.get().proxies.isProxyOnlineMode();
        Optional<NameAndId> optional = shouldLookup ? profileRepository.findProfileByName(name).map(NameAndId::new) : Optional.empty();
        return optional.isEmpty() ? this.createUnknownProfile(name) : optional;
    }

    private Optional<NameAndId> createUnknownProfile(String name) {
        return !GlobalConfiguration.get().proxies.isProxyOnlineMode() ? Optional.of(NameAndId.createOffline(name)) : Optional.empty();
    }

    @Override
    public void resolveOfflineUsers(boolean resolveOfflineUsers) {
        this.resolveOfflineUsers = resolveOfflineUsers;
    }

    @Override
    public void add(NameAndId nameAndId) {
        this.addInternal(nameAndId);
    }

    private GameProfileInfo addInternal(NameAndId nameAndId) {
        Calendar instance = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        instance.setTime(new Date());
        instance.add(2, 1);
        Date time = instance.getTime();
        GameProfileInfo gameProfileInfo = new GameProfileInfo(nameAndId, time);
        this.safeAdd(gameProfileInfo);
        if (!SpigotConfig.saveUserCacheOnStopOnly) {
            this.save(true);
        }
        return gameProfileInfo;
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public NameAndId getIfCached(String name) {
        try {
            this.stateLock.lock();
            GameProfileInfo entry = this.profilesByName.get(name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                NameAndId nameAndId = null;
                return nameAndId;
            }
            entry.setLastAccess(this.getNextOperation());
            NameAndId nameAndId = entry.nameAndId();
            return nameAndId;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<NameAndId> get(String name) {
        String string = name.toLowerCase(Locale.ROOT);
        boolean stateLocked = true;
        try {
            Optional<NameAndId> optional;
            this.stateLock.lock();
            GameProfileInfo gameProfileInfo = this.profilesByName.get(string);
            boolean flag = false;
            if (gameProfileInfo != null && new Date().getTime() >= gameProfileInfo.expirationDate.getTime()) {
                this.profilesByUUID.remove(gameProfileInfo.nameAndId().id());
                this.profilesByName.remove(gameProfileInfo.nameAndId().name().toLowerCase(Locale.ROOT));
                flag = true;
                gameProfileInfo = null;
            }
            if (gameProfileInfo != null) {
                gameProfileInfo.setLastAccess(this.getNextOperation());
                optional = Optional.of(gameProfileInfo.nameAndId());
                stateLocked = false;
                this.stateLock.unlock();
            } else {
                Optional<NameAndId> optional1;
                stateLocked = false;
                this.stateLock.unlock();
                try {
                    this.lookupLock.lock();
                    optional1 = this.lookupGameProfile(this.profileRepository, name);
                }
                finally {
                    this.lookupLock.unlock();
                }
                if (optional1.isPresent()) {
                    optional = Optional.of(this.addInternal(optional1.get()).nameAndId());
                    flag = false;
                } else {
                    optional = Optional.empty();
                }
            }
            if (flag && !SpigotConfig.saveUserCacheOnStopOnly) {
                this.save(true);
            }
            Optional<NameAndId> optional2 = optional;
            return optional2;
        }
        finally {
            if (stateLocked) {
                this.stateLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<NameAndId> get(UUID uuid) {
        try {
            this.stateLock.lock();
            GameProfileInfo gameProfileInfo = this.profilesByUUID.get(uuid);
            if (gameProfileInfo == null) {
                Optional<NameAndId> optional = Optional.empty();
                return optional;
            }
            gameProfileInfo.setLastAccess(this.getNextOperation());
            Optional<NameAndId> optional = Optional.of(gameProfileInfo.nameAndId());
            return optional;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<GameProfileInfo> load() {
        ArrayList list = Lists.newArrayList();
        try (BufferedReader reader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.gson.fromJson((Reader)reader, JsonArray.class);
            if (jsonArray != null) {
                DateFormat dateFormat = CachedUserNameToIdResolver.createDateFormat();
                jsonArray.forEach(jsonElement -> CachedUserNameToIdResolver.readGameProfile(jsonElement, dateFormat).ifPresent(list::add));
                ArrayList arrayList = list;
                return arrayList;
            }
            ArrayList var9 = list;
            return var9;
        }
        catch (FileNotFoundException var9) {
            return list;
        }
        catch (JsonSyntaxException | NullPointerException ex) {
            LOGGER.warn("Usercache.json is corrupted or has bad formatting. Deleting it to prevent further issues.");
            this.file.delete();
            return list;
        }
        catch (JsonParseException | IOException var8) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)var8);
        }
        return list;
    }

    @Override
    public void save() {
        this.save(false);
    }

    @Override
    public void save(boolean asyncSave) {
        JsonArray jsonArray = new JsonArray();
        DateFormat dateFormat = CachedUserNameToIdResolver.createDateFormat();
        this.listTopMRUProfiles(SpigotConfig.userCacheCap).forEach(gameProfileInfo -> jsonArray.add(CachedUserNameToIdResolver.writeGameProfile(gameProfileInfo, dateFormat)));
        String string = this.gson.toJson((JsonElement)jsonArray);
        Runnable save = () -> {
            try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
                writer.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
        if (asyncSave) {
            MCUtil.scheduleAsyncTask(save);
        } else {
            save.run();
        }
    }

    private Stream<GameProfileInfo> getTopMRUProfiles(int limit) {
        return this.listTopMRUProfiles(limit).stream();
    }

    private List<GameProfileInfo> listTopMRUProfiles(int limit) {
        try {
            this.stateLock.lock();
            List<GameProfileInfo> list = this.profilesByUUID.values().stream().sorted(Comparator.comparing(GameProfileInfo::lastAccess).reversed()).limit(limit).toList();
            return list;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private static JsonElement writeGameProfile(GameProfileInfo profileInfo, DateFormat format) {
        JsonObject jsonObject = new JsonObject();
        profileInfo.nameAndId().appendTo(jsonObject);
        jsonObject.addProperty("expiresOn", format.format(profileInfo.expirationDate()));
        return jsonObject;
    }

    private static Optional<GameProfileInfo> readGameProfile(JsonElement element, DateFormat format) {
        JsonElement jsonElement;
        JsonObject asJsonObject;
        NameAndId nameAndId;
        if (element.isJsonObject() && (nameAndId = NameAndId.fromJson(asJsonObject = element.getAsJsonObject())) != null && (jsonElement = asJsonObject.get("expiresOn")) != null) {
            String asString = jsonElement.getAsString();
            try {
                Date date = format.parse(asString);
                return Optional.of(new GameProfileInfo(nameAndId, date));
            }
            catch (ParseException var7) {
                LOGGER.warn("Failed to parse date {}", (Object)asString, (Object)var7);
            }
        }
        return Optional.empty();
    }

    static class GameProfileInfo {
        private final NameAndId nameAndId;
        final Date expirationDate;
        private volatile long lastAccess;

        GameProfileInfo(NameAndId nameAndId, Date expirationDate) {
            this.nameAndId = nameAndId;
            this.expirationDate = expirationDate;
        }

        public NameAndId nameAndId() {
            return this.nameAndId;
        }

        public Date expirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long lastAccess) {
            this.lastAccess = lastAccess;
        }

        public long lastAccess() {
            return this.lastAccess;
        }
    }
}

