/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.util.Date;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.NameAndId;
import org.jspecify.annotations.Nullable;

public class UserBanListEntry
extends BanListEntry<NameAndId> {
    private static final Component MESSAGE_UNKNOWN_USER = Component.translatable("commands.banlist.entry.unknown");

    public UserBanListEntry(@Nullable NameAndId user) {
        this(user, (Date)null, (String)null, (Date)null, (String)null);
    }

    public UserBanListEntry(@Nullable NameAndId user, @Nullable Date created, @Nullable String source, @Nullable Date expires, @Nullable String reason) {
        super(user, created, source, expires, reason);
    }

    public UserBanListEntry(JsonObject entryData) {
        super(UserBanListEntry.parseNameAndId(entryData), entryData);
    }

    @Override
    protected void serialize(JsonObject data) {
        if (this.getUser() != null) {
            ((NameAndId)this.getUser()).appendTo(data);
            super.serialize(data);
        }
    }

    @Override
    public Component getDisplayName() {
        NameAndId nameAndId = (NameAndId)this.getUser();
        return nameAndId != null ? Component.literal(nameAndId.name()) : MESSAGE_UNKNOWN_USER;
    }

    private static @Nullable NameAndId parseNameAndId(JsonObject json) {
        UUID uuid = null;
        String name = null;
        if (json.has("uuid")) {
            String asString = json.get("uuid").getAsString();
            try {
                uuid = UUID.fromString(asString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (json.has("name")) {
            name = json.get("name").getAsString();
        }
        if (uuid != null || name != null) {
            return new NameAndId(uuid, name);
        }
        return null;
    }
}

