/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.slf4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DisplayResolver displayResolver;
    @VisibleForTesting
    public final Set<ResourceKey<Recipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> highlight = Sets.newIdentityHashSet();

    public ServerRecipeBook(DisplayResolver displayResolver) {
        this.displayResolver = displayResolver;
    }

    public void add(ResourceKey<Recipe<?>> recipe) {
        this.known.add(recipe);
    }

    public boolean contains(ResourceKey<Recipe<?>> recipe) {
        return this.known.contains(recipe);
    }

    public void remove(ResourceKey<Recipe<?>> recipe) {
        this.known.remove(recipe);
        this.highlight.remove(recipe);
    }

    public void removeHighlight(ResourceKey<Recipe<?>> recipe) {
        this.highlight.remove(recipe);
    }

    private void addHighlight(ResourceKey<Recipe<?>> recipe) {
        this.highlight.add(recipe);
    }

    public int addRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer player) {
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>();
        for (RecipeHolder<?> recipeHolder : recipes) {
            PlayerRecipeDiscoverEvent event;
            ResourceKey<Recipe<?>> resourceKey = recipeHolder.id();
            if (this.known.contains(resourceKey) || recipeHolder.value().isSpecial() || (event = CraftEventFactory.callPlayerRecipeListUpdateEvent(player, recipeHolder)).isCancelled()) continue;
            this.add(resourceKey);
            this.addHighlight(resourceKey);
            this.displayResolver.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)entry, event.shouldShowNotification(), true)));
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(player, recipeHolder);
        }
        if (!list.isEmpty() && player.connection != null) {
            player.connection.send(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeHolder : recipes) {
            ResourceKey<Recipe<?>> resourceKey = recipeHolder.id();
            if (!this.known.contains(resourceKey)) continue;
            this.remove(resourceKey);
            this.displayResolver.displaysForRecipe(resourceKey, entry -> list.add(entry.id()));
        }
        if (!list.isEmpty() && player.connection != null) {
            player.connection.send(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    private void loadRecipes(List<ResourceKey<Recipe<?>>> recipes, Consumer<ResourceKey<Recipe<?>>> output, Predicate<ResourceKey<Recipe<?>>> isRecognized) {
        for (ResourceKey<Recipe<?>> resourceKey : recipes) {
            if (!isRecognized.test(resourceKey)) {
                LOGGER.error("Tried to load unrecognized recipe: {} removed now.", resourceKey);
                continue;
            }
            output.accept(resourceKey);
        }
    }

    public void sendInitialRecipeBook(ServerPlayer player) {
        player.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings().copy()));
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>(this.known.size());
        for (ResourceKey<Recipe<?>> resourceKey : this.known) {
            this.displayResolver.displaysForRecipe(resourceKey, entry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)entry, false, this.highlight.contains(resourceKey))));
        }
        player.connection.send(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void copyOverData(ServerRecipeBook other) {
        this.apply(other.pack());
    }

    public Packed pack() {
        return new Packed(this.bookSettings.copy(), List.copyOf(this.known), List.copyOf(this.highlight));
    }

    private void apply(Packed recipeBook) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(recipeBook.settings);
        this.known.addAll(recipeBook.known);
        this.highlight.addAll(recipeBook.highlight);
    }

    public void loadUntrusted(Packed recipeBook, Predicate<ResourceKey<Recipe<?>>> predicate) {
        this.bookSettings.replaceFrom(recipeBook.settings);
        this.loadRecipes(recipeBook.known, this.known::add, predicate);
        this.loadRecipes(recipeBook.highlight, this.highlight::add, predicate);
    }

    @FunctionalInterface
    public static interface DisplayResolver {
        public void displaysForRecipe(ResourceKey<Recipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public record Packed(RecipeBookSettings settings, List<ResourceKey<Recipe<?>>> known, List<ResourceKey<Recipe<?>>> highlight) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecipeBookSettings.MAP_CODEC.forGetter(Packed::settings), (App)Recipe.KEY_CODEC.listOf().fieldOf("recipes").forGetter(Packed::known), (App)Recipe.KEY_CODEC.listOf().fieldOf("toBeDisplayed").forGetter(Packed::highlight)).apply((Applicative)instance, Packed::new));
    }
}

