/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.FileUtil;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatsCounter
extends StatsCounter {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Stat<?>, Integer>> STATS_CODEC = Codec.dispatchedMap(BuiltInRegistries.STAT_TYPE.byNameCodec(), Util.memoize(ServerStatsCounter::createTypedStatsCodec)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statType, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Stat)entry.getKey()).getType(), Util.toMap())));
    private final Path file;
    private final Set<Stat<?>> dirty = Sets.newHashSet();

    private static <T> Codec<Map<Stat<?>, Integer>> createTypedStatsCodec(StatType<T> type) {
        Codec<T> codec = type.getRegistry().byNameCodec();
        Codec codec1 = codec.flatComapMap(type::get, stat -> stat.getType() == type ? DataResult.success(stat.getValue()) : DataResult.error(() -> "Expected type " + String.valueOf(type) + ", but got " + String.valueOf(stat.getType())));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatsCounter(MinecraftServer server, Path file) {
        this.file = file;
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                JsonElement jsonElement = StrictJsonParser.parse(bufferedReader);
                this.parse(server.getFixerUpper(), jsonElement);
            }
            catch (IOException var8) {
                LOGGER.error("Couldn't read statistics file {}", (Object)file, (Object)var8);
            }
            catch (JsonParseException var9) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)file, (Object)var9);
            }
        }
        for (Map.Entry<Identifier, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<Identifier> wrapper = Stats.CUSTOM.get(Objects.requireNonNull(BuiltInRegistries.CUSTOM_STAT.getValue(entry.getKey())));
            this.stats.put(wrapper, entry.getValue().intValue());
        }
    }

    public void save() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtil.createDirectoriesSafe(this.file.getParent());
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(this.toJson(), GSON.newJsonWriter((Writer)bufferedWriter));
            }
        }
        catch (JsonIOException | IOException var6) {
            LOGGER.error("Couldn't save stats to {}", (Object)this.file, (Object)var6);
        }
    }

    @Override
    public void setValue(Player player, Stat<?> stat, int value) {
        Identifier key;
        Object obj;
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        if (stat.getType() == Stats.CUSTOM && (obj = stat.getValue()) instanceof Identifier && SpigotConfig.forcedStats.get(key = (Identifier)obj) != null) {
            return;
        }
        super.setValue(player, stat, value);
        this.dirty.add(stat);
    }

    private Set<Stat<?>> getDirty() {
        HashSet set = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return set;
    }

    public void parse(DataFixer fixerUpper, JsonElement json) {
        Dynamic<JsonElement> dynamic = new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, json);
        dynamic = DataFixTypes.STATS.updateToCurrentVersion(fixerUpper, dynamic, NbtUtils.getDataVersion(dynamic, 1343));
        this.stats.putAll(STATS_CODEC.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(string -> LOGGER.error("Failed to parse statistics for {}: {}", (Object)this.file, string)).orElse(Map.of()));
    }

    protected JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("stats", (JsonElement)STATS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.stats).getOrThrow());
        jsonObject.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().dataVersion().version());
        return jsonObject;
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Stat<?>>)this.stats.keySet());
    }

    public void sendStats(ServerPlayer player) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.getDirty()) {
            map.put(stat, this.getValue(stat));
        }
        player.connection.send(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)map));
    }
}

