/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ARGB {
    private static final int LINEAR_CHANNEL_DEPTH = 1024;
    private static final short[] SRGB_TO_LINEAR = Util.make(new short[256], shorts -> {
        for (int i = 0; i < ((short[])shorts).length; ++i) {
            float f = (float)i / 255.0f;
            shorts[i] = (short)Math.round(ARGB.computeSrgbToLinear(f) * 1023.0f);
        }
    });
    private static final byte[] LINEAR_TO_SRGB = Util.make(new byte[1024], bytes -> {
        for (int i = 0; i < ((byte[])bytes).length; ++i) {
            float f = (float)i / 1023.0f;
            bytes[i] = (byte)Math.round(ARGB.computeLinearToSrgb(f) * 255.0f);
        }
    });

    private static float computeSrgbToLinear(float value) {
        return value >= 0.04045f ? (float)Math.pow(((double)value + 0.055) / 1.055, 2.4) : value / 12.92f;
    }

    private static float computeLinearToSrgb(float value) {
        return value >= 0.0031308f ? (float)(1.055 * Math.pow(value, 0.4166666666666667) - 0.055) : 12.92f * value;
    }

    public static float srgbToLinearChannel(int srgb) {
        return (float)SRGB_TO_LINEAR[srgb] / 1023.0f;
    }

    public static int linearToSrgbChannel(float linear) {
        return LINEAR_TO_SRGB[Mth.floor(linear * 1023.0f)] & 0xFF;
    }

    public static int meanLinear(int srgb1, int srgb2, int srgb3, int srgb4) {
        return ARGB.color((ARGB.alpha(srgb1) + ARGB.alpha(srgb2) + ARGB.alpha(srgb3) + ARGB.alpha(srgb4)) / 4, ARGB.linearChannelMean(ARGB.red(srgb1), ARGB.red(srgb2), ARGB.red(srgb3), ARGB.red(srgb4)), ARGB.linearChannelMean(ARGB.green(srgb1), ARGB.green(srgb2), ARGB.green(srgb3), ARGB.green(srgb4)), ARGB.linearChannelMean(ARGB.blue(srgb1), ARGB.blue(srgb2), ARGB.blue(srgb3), ARGB.blue(srgb4)));
    }

    private static int linearChannelMean(int c1, int c2, int c3, int c4) {
        int i = (SRGB_TO_LINEAR[c1] + SRGB_TO_LINEAR[c2] + SRGB_TO_LINEAR[c3] + SRGB_TO_LINEAR[c4]) / 4;
        return LINEAR_TO_SRGB[i] & 0xFF;
    }

    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static int color(int alpha, int red, int green, int blue) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int color(int red, int green, int blue) {
        return ARGB.color(255, red, green, blue);
    }

    public static int color(Vec3 color) {
        return ARGB.color(ARGB.as8BitChannel((float)color.x()), ARGB.as8BitChannel((float)color.y()), ARGB.as8BitChannel((float)color.z()));
    }

    public static int multiply(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        return color2 == -1 ? color1 : ARGB.color(ARGB.alpha(color1) * ARGB.alpha(color2) / 255, ARGB.red(color1) * ARGB.red(color2) / 255, ARGB.green(color1) * ARGB.green(color2) / 255, ARGB.blue(color1) * ARGB.blue(color2) / 255);
    }

    public static int addRgb(int color1, int color2) {
        return ARGB.color(ARGB.alpha(color1), Math.min(ARGB.red(color1) + ARGB.red(color2), 255), Math.min(ARGB.green(color1) + ARGB.green(color2), 255), Math.min(ARGB.blue(color1) + ARGB.blue(color2), 255));
    }

    public static int subtractRgb(int color1, int color2) {
        return ARGB.color(ARGB.alpha(color1), Math.max(ARGB.red(color1) - ARGB.red(color2), 0), Math.max(ARGB.green(color1) - ARGB.green(color2), 0), Math.max(ARGB.blue(color1) - ARGB.blue(color2), 0));
    }

    public static int multiplyAlpha(int color, float alphaMultiplier) {
        if (color == 0 || alphaMultiplier <= 0.0f) {
            return 0;
        }
        return alphaMultiplier >= 1.0f ? color : ARGB.color(ARGB.alphaFloat(color) * alphaMultiplier, color);
    }

    public static int scaleRGB(int color, float scale) {
        return ARGB.scaleRGB(color, scale, scale, scale);
    }

    public static int scaleRGB(int color, float redScale, float greenScale, float blueScale) {
        return ARGB.color(ARGB.alpha(color), Math.clamp((long)((int)((float)ARGB.red(color) * redScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.green(color) * greenScale)), 0, 255), Math.clamp((long)((int)((float)ARGB.blue(color) * blueScale)), 0, 255));
    }

    public static int scaleRGB(int color, int scale) {
        return ARGB.color(ARGB.alpha(color), Math.clamp((long)ARGB.red(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.green(color) * (long)scale / 255L, 0, 255), Math.clamp((long)ARGB.blue(color) * (long)scale / 255L, 0, 255));
    }

    public static int greyscale(int color) {
        int i = (int)((float)ARGB.red(color) * 0.3f + (float)ARGB.green(color) * 0.59f + (float)ARGB.blue(color) * 0.11f);
        return ARGB.color(ARGB.alpha(color), i, i, i);
    }

    public static int alphaBlend(int destination, int source) {
        int i = ARGB.alpha(destination);
        int i1 = ARGB.alpha(source);
        if (i1 == 255) {
            return source;
        }
        if (i1 == 0) {
            return destination;
        }
        int i2 = i1 + i * (255 - i1) / 255;
        return ARGB.color(i2, ARGB.alphaBlendChannel(i2, i1, ARGB.red(destination), ARGB.red(source)), ARGB.alphaBlendChannel(i2, i1, ARGB.green(destination), ARGB.green(source)), ARGB.alphaBlendChannel(i2, i1, ARGB.blue(destination), ARGB.blue(source)));
    }

    private static int alphaBlendChannel(int resultAlpha, int sourceAlpha, int destination, int source) {
        return (source * sourceAlpha + destination * (resultAlpha - sourceAlpha)) / resultAlpha;
    }

    public static int srgbLerp(float delta, int color1, int color2) {
        int i = Mth.lerpInt(delta, ARGB.alpha(color1), ARGB.alpha(color2));
        int i1 = Mth.lerpInt(delta, ARGB.red(color1), ARGB.red(color2));
        int i2 = Mth.lerpInt(delta, ARGB.green(color1), ARGB.green(color2));
        int i3 = Mth.lerpInt(delta, ARGB.blue(color1), ARGB.blue(color2));
        return ARGB.color(i, i1, i2, i3);
    }

    public static int linearLerp(float delta, int color1, int color2) {
        return ARGB.color(Mth.lerpInt(delta, ARGB.alpha(color1), ARGB.alpha(color2)), LINEAR_TO_SRGB[Mth.lerpInt(delta, SRGB_TO_LINEAR[ARGB.red(color1)], SRGB_TO_LINEAR[ARGB.red(color2)])] & 0xFF, LINEAR_TO_SRGB[Mth.lerpInt(delta, SRGB_TO_LINEAR[ARGB.green(color1)], SRGB_TO_LINEAR[ARGB.green(color2)])] & 0xFF, LINEAR_TO_SRGB[Mth.lerpInt(delta, SRGB_TO_LINEAR[ARGB.blue(color1)], SRGB_TO_LINEAR[ARGB.blue(color2)])] & 0xFF);
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    public static int transparent(int color) {
        return color & 0xFFFFFF;
    }

    public static int color(int alpha, int color) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int color(float alpha, int color) {
        return ARGB.as8BitChannel(alpha) << 24 | color & 0xFFFFFF;
    }

    public static int white(float alpha) {
        return ARGB.as8BitChannel(alpha) << 24 | 0xFFFFFF;
    }

    public static int white(int alpha) {
        return alpha << 24 | 0xFFFFFF;
    }

    public static int black(float alpha) {
        return ARGB.as8BitChannel(alpha) << 24;
    }

    public static int black(int alpha) {
        return alpha << 24;
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return ARGB.color(ARGB.as8BitChannel(alpha), ARGB.as8BitChannel(red), ARGB.as8BitChannel(green), ARGB.as8BitChannel(blue));
    }

    public static Vector3f vector3fFromRGB24(int color) {
        return new Vector3f(ARGB.redFloat(color), ARGB.greenFloat(color), ARGB.blueFloat(color));
    }

    public static Vector4f vector4fFromARGB32(int color) {
        return new Vector4f(ARGB.redFloat(color), ARGB.greenFloat(color), ARGB.blueFloat(color), ARGB.alphaFloat(color));
    }

    public static int average(int color1, int color2) {
        return ARGB.color((ARGB.alpha(color1) + ARGB.alpha(color2)) / 2, (ARGB.red(color1) + ARGB.red(color2)) / 2, (ARGB.green(color1) + ARGB.green(color2)) / 2, (ARGB.blue(color1) + ARGB.blue(color2)) / 2);
    }

    public static int as8BitChannel(float value) {
        return Mth.floor(value * 255.0f);
    }

    public static float alphaFloat(int color) {
        return ARGB.from8BitChannel(ARGB.alpha(color));
    }

    public static float redFloat(int color) {
        return ARGB.from8BitChannel(ARGB.red(color));
    }

    public static float greenFloat(int color) {
        return ARGB.from8BitChannel(ARGB.green(color));
    }

    public static float blueFloat(int color) {
        return ARGB.from8BitChannel(ARGB.blue(color));
    }

    private static float from8BitChannel(int value) {
        return (float)value / 255.0f;
    }

    public static int toABGR(int color) {
        return color & 0xFF00FF00 | (color & 0xFF0000) >> 16 | (color & 0xFF) << 16;
    }

    public static int fromABGR(int color) {
        return ARGB.toABGR(color);
    }

    public static int setBrightness(int color, float brightness) {
        float f2;
        int i = ARGB.red(color);
        int i1 = ARGB.green(color);
        int i2 = ARGB.blue(color);
        int i3 = ARGB.alpha(color);
        int max = Math.max(Math.max(i, i1), i2);
        int min = Math.min(Math.min(i, i1), i2);
        float f = max - min;
        float f1 = max != 0 ? f / (float)max : 0.0f;
        if (f1 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f3 = (float)(max - i) / f;
            float f4 = (float)(max - i1) / f;
            float f5 = (float)(max - i2) / f;
            f2 = i == max ? f5 - f4 : (i1 == max ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (f1 == 0.0f) {
            i1 = i2 = Math.round(brightness * 255.0f);
            i = i2;
            return ARGB.color(i3, i, i1, i2);
        }
        float f3x = (f2 - (float)Math.floor(f2)) * 6.0f;
        float f4x = f3x - (float)Math.floor(f3x);
        float f5x = brightness * (1.0f - f1);
        float f6 = brightness * (1.0f - f1 * f4x);
        float f7 = brightness * (1.0f - f1 * (1.0f - f4x));
        switch ((int)f3x) {
            case 0: {
                i = Math.round(brightness * 255.0f);
                i1 = Math.round(f7 * 255.0f);
                i2 = Math.round(f5x * 255.0f);
                break;
            }
            case 1: {
                i = Math.round(f6 * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i2 = Math.round(f5x * 255.0f);
                break;
            }
            case 2: {
                i = Math.round(f5x * 255.0f);
                i1 = Math.round(brightness * 255.0f);
                i2 = Math.round(f7 * 255.0f);
                break;
            }
            case 3: {
                i = Math.round(f5x * 255.0f);
                i1 = Math.round(f6 * 255.0f);
                i2 = Math.round(brightness * 255.0f);
                break;
            }
            case 4: {
                i = Math.round(f7 * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i2 = Math.round(brightness * 255.0f);
                break;
            }
            case 5: {
                i = Math.round(brightness * 255.0f);
                i1 = Math.round(f5x * 255.0f);
                i2 = Math.round(f6 * 255.0f);
            }
        }
        return ARGB.color(i3, i, i1, i2);
    }
}

