/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.util.Util;

public class ClassTreeIdRegistry {
    public static final int NO_ID_VALUE = -1;
    private final Object2IntMap<Class<?>> classToLastIdCache = (Object2IntMap)Util.make(new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));

    public int getLastIdFor(Class<?> clazz) {
        int _int = this.classToLastIdCache.getInt(clazz);
        if (_int != -1) {
            return _int;
        }
        Class<?> clazz1 = clazz;
        while ((clazz1 = clazz1.getSuperclass()) != Object.class) {
            int _int1 = this.classToLastIdCache.getInt(clazz1);
            if (_int1 == -1) continue;
            return _int1;
        }
        return -1;
    }

    public int getCount(Class<?> clazz) {
        return this.getLastIdFor(clazz) + 1;
    }

    public int define(Class<?> clazz) {
        int lastIdFor = this.getLastIdFor(clazz);
        int i = lastIdFor == -1 ? 0 : lastIdFor + 1;
        this.classToLastIdCache.put(clazz, i);
        return i;
    }
}

