/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C, I extends BoundedFloatFunction<C>>
extends BoundedFloatFunction<C> {
    @VisibleForDebug
    public String parityString();

    public CubicSpline<C, I> mapAll(CoordinateVisitor<I> var1);

    public static <C, I extends BoundedFloatFunction<C>> Codec<CubicSpline<C, I>> codec(Codec<I> valueCodec) {
        record Point<C, I extends BoundedFloatFunction<C>>(float location, CubicSpline<C, I> value, float derivative) {
        }
        MutableObject mutableObject = new MutableObject();
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("location").forGetter(Point::location), (App)Codec.lazyInitialized((Supplier)mutableObject).fieldOf("value").forGetter(Point::value), (App)Codec.FLOAT.fieldOf("derivative").forGetter(Point::derivative)).apply((Applicative)instance, (location, value, derivative) -> new Point(location.floatValue(), value, derivative.floatValue())));
        Codec codec1 = RecordCodecBuilder.create(locations -> locations.group((App)valueCodec.fieldOf("coordinate").forGetter(Multipoint::coordinate), (App)ExtraCodecs.nonEmptyList(codec.listOf()).fieldOf("points").forGetter(multipoint -> IntStream.range(0, multipoint.locations.length).mapToObj(i -> new Point(multipoint.locations()[i], multipoint.values().get(i), multipoint.derivatives()[i])).toList())).apply((Applicative)locations, (coordinate, list) -> {
            float[] floats = new float[list.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] floats1 = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Point point = (Point)list.get(i);
                floats[i] = point.location();
                builder.add(point.value());
                floats1[i] = point.derivative();
            }
            return Multipoint.create(coordinate, floats, builder.build(), floats1);
        }));
        mutableObject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec1).xmap(either -> (CubicSpline)((Object)either.map(Constant::new, multipoint -> multipoint)), cubicSpline -> {
            Either either;
            if (cubicSpline instanceof Constant) {
                Constant constant = (Constant)cubicSpline;
                either = Either.left(Float.valueOf(constant.value()));
            } else {
                either = Either.right((Multipoint)cubicSpline);
            }
            return either;
        }));
        return (Codec)mutableObject.get();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> constant(float value) {
        return new Constant(value);
    }

    public static <C, I extends BoundedFloatFunction<C>> Builder<C, I> builder(I coordinate) {
        return new Builder(coordinate);
    }

    public static <C, I extends BoundedFloatFunction<C>> Builder<C, I> builder(I coordinate, BoundedFloatFunction<Float> valueTransformer) {
        return new Builder(coordinate, valueTransformer);
    }

    @VisibleForDebug
    public record Constant<C, I extends BoundedFloatFunction<C>>(float value) implements CubicSpline<C, I>
    {
        @Override
        public float apply(C value) {
            return this.value;
        }

        @Override
        public String parityString() {
            return String.format(Locale.ROOT, "k=%.3f", Float.valueOf(this.value));
        }

        @Override
        public float minValue() {
            return this.value;
        }

        @Override
        public float maxValue() {
            return this.value;
        }

        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> visitor) {
            return this;
        }
    }

    public static final class Builder<C, I extends BoundedFloatFunction<C>> {
        private final I coordinate;
        private final BoundedFloatFunction<Float> valueTransformer;
        private final FloatList locations = new FloatArrayList();
        private final List<CubicSpline<C, I>> values = Lists.newArrayList();
        private final FloatList derivatives = new FloatArrayList();

        protected Builder(I coordinate) {
            this(coordinate, BoundedFloatFunction.IDENTITY);
        }

        protected Builder(I coordinate, BoundedFloatFunction<Float> valueTransformer) {
            this.coordinate = coordinate;
            this.valueTransformer = valueTransformer;
        }

        public Builder<C, I> addPoint(float location, float value) {
            return this.addPoint(location, new Constant(this.valueTransformer.apply(Float.valueOf(value))), 0.0f);
        }

        public Builder<C, I> addPoint(float location, float value, float derivative) {
            return this.addPoint(location, new Constant(this.valueTransformer.apply(Float.valueOf(value))), derivative);
        }

        public Builder<C, I> addPoint(float location, CubicSpline<C, I> value) {
            return this.addPoint(location, value, 0.0f);
        }

        private Builder<C, I> addPoint(float location, CubicSpline<C, I> value, float derivative) {
            if (!this.locations.isEmpty() && location <= this.locations.getFloat(this.locations.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.locations.add(location);
            this.values.add(value);
            this.derivatives.add(derivative);
            return this;
        }

        public CubicSpline<C, I> build() {
            if (this.locations.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return Multipoint.create(this.coordinate, this.locations.toFloatArray(), ImmutableList.copyOf(this.values), this.derivatives.toFloatArray());
        }
    }

    @VisibleForDebug
    public record Multipoint<C, I extends BoundedFloatFunction<C>>(I coordinate, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives, float minValue, float maxValue) implements CubicSpline<C, I>
    {
        public Multipoint {
            Multipoint.validateSizes(locations, values, derivatives);
        }

        static <C, I extends BoundedFloatFunction<C>> Multipoint<C, I> create(I coordinate, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            float f5;
            float f4;
            Multipoint.validateSizes(locations, values, derivatives);
            int i = locations.length - 1;
            float f = Float.POSITIVE_INFINITY;
            float f1 = Float.NEGATIVE_INFINITY;
            float f2 = coordinate.minValue();
            float f3 = coordinate.maxValue();
            if (f2 < locations[0]) {
                f4 = Multipoint.linearExtend(f2, locations, values.get(0).minValue(), derivatives, 0);
                f5 = Multipoint.linearExtend(f2, locations, values.get(0).maxValue(), derivatives, 0);
                f = Math.min(f, Math.min(f4, f5));
                f1 = Math.max(f1, Math.max(f4, f5));
            }
            if (f3 > locations[i]) {
                f4 = Multipoint.linearExtend(f3, locations, values.get(i).minValue(), derivatives, i);
                f5 = Multipoint.linearExtend(f3, locations, values.get(i).maxValue(), derivatives, i);
                f = Math.min(f, Math.min(f4, f5));
                f1 = Math.max(f1, Math.max(f4, f5));
            }
            for (CubicSpline<C, I> cubicSpline : values) {
                f = Math.min(f, cubicSpline.minValue());
                f1 = Math.max(f1, cubicSpline.maxValue());
            }
            for (int i1 = 0; i1 < i; ++i1) {
                f5 = locations[i1];
                float f6 = locations[i1 + 1];
                float f7 = f6 - f5;
                CubicSpline<C, I> cubicSpline1 = values.get(i1);
                CubicSpline<C, I> cubicSpline2 = values.get(i1 + 1);
                float f8 = cubicSpline1.minValue();
                float f9 = cubicSpline1.maxValue();
                float f10 = cubicSpline2.minValue();
                float f11 = cubicSpline2.maxValue();
                float f12 = derivatives[i1];
                float f13 = derivatives[i1 + 1];
                if (f12 == 0.0f && f13 == 0.0f) continue;
                float f14 = f12 * f7;
                float f15 = f13 * f7;
                float min = Math.min(f8, f10);
                float max = Math.max(f9, f11);
                float f16 = f14 - f11 + f8;
                float f17 = f14 - f10 + f9;
                float f18 = -f15 + f10 - f9;
                float f19 = -f15 + f11 - f8;
                float min1 = Math.min(f16, f18);
                float max1 = Math.max(f17, f19);
                f = Math.min(f, min + 0.25f * min1);
                f1 = Math.max(f1, max + 0.25f * max1);
            }
            return new Multipoint<C, I>(coordinate, locations, values, derivatives, f, f1);
        }

        private static float linearExtend(float coordinate, float[] locations, float value, float[] derivatives, int index) {
            float f = derivatives[index];
            return f == 0.0f ? value : value + f * (coordinate - locations[index]);
        }

        private static <C, I extends BoundedFloatFunction<C>> void validateSizes(float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            if (locations.length != values.size() || locations.length != derivatives.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + locations.length + " " + values.size() + " " + derivatives.length);
            }
            if (locations.length == 0) {
                throw new IllegalArgumentException("Cannot create a multipoint spline with no points");
            }
        }

        @Override
        public float apply(C value) {
            float f = this.coordinate.apply(value);
            int i = Multipoint.findIntervalStart(this.locations, f);
            int i1 = this.locations.length - 1;
            if (i < 0) {
                return Multipoint.linearExtend(f, this.locations, this.values.get(0).apply(value), this.derivatives, 0);
            }
            if (i == i1) {
                return Multipoint.linearExtend(f, this.locations, this.values.get(i1).apply(value), this.derivatives, i1);
            }
            float f1 = this.locations[i];
            float f2 = this.locations[i + 1];
            float f3 = (f - f1) / (f2 - f1);
            BoundedFloatFunction boundedFloatFunction = this.values.get(i);
            BoundedFloatFunction boundedFloatFunction1 = this.values.get(i + 1);
            float f4 = this.derivatives[i];
            float f5 = this.derivatives[i + 1];
            float f6 = boundedFloatFunction.apply(value);
            float f7 = boundedFloatFunction1.apply(value);
            float f8 = f4 * (f2 - f1) - (f7 - f6);
            float f9 = -f5 * (f2 - f1) + (f7 - f6);
            return Mth.lerp(f3, f6, f7) + f3 * (1.0f - f3) * Mth.lerp(f3, f8, f9);
        }

        private static int findIntervalStart(float[] locations, float start) {
            return Mth.binarySearch(0, locations.length, i -> start < locations[i]) - 1;
        }

        @Override
        @VisibleForTesting
        public String parityString() {
            return "Spline{coordinate=" + String.valueOf(this.coordinate) + ", locations=" + this.toString(this.locations) + ", derivatives=" + this.toString(this.derivatives) + ", values=" + this.values.stream().map(CubicSpline::parityString).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String toString(float[] locations) {
            return "[" + IntStream.range(0, locations.length).mapToDouble(i -> locations[i]).mapToObj(d -> String.format(Locale.ROOT, "%.3f", d)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> visitor) {
            return Multipoint.create((BoundedFloatFunction)visitor.visit(this.coordinate), this.locations, this.values().stream().map(cubicSpline -> cubicSpline.mapAll(visitor)).toList(), this.derivatives);
        }
    }

    public static interface CoordinateVisitor<I> {
        public I visit(I var1);
    }
}

