/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class GsonHelper {
    private static final Gson GSON = new GsonBuilder().create();

    public static boolean isStringValue(JsonObject json, String memberName) {
        return GsonHelper.isValidPrimitive(json, memberName) && json.getAsJsonPrimitive(memberName).isString();
    }

    public static boolean isStringValue(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isString();
    }

    public static boolean isNumberValue(JsonObject json, String memberName) {
        return GsonHelper.isValidPrimitive(json, memberName) && json.getAsJsonPrimitive(memberName).isNumber();
    }

    public static boolean isNumberValue(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber();
    }

    public static boolean isBooleanValue(JsonObject json, String memberName) {
        return GsonHelper.isValidPrimitive(json, memberName) && json.getAsJsonPrimitive(memberName).isBoolean();
    }

    public static boolean isBooleanValue(JsonElement json) {
        return json.isJsonPrimitive() && json.getAsJsonPrimitive().isBoolean();
    }

    public static boolean isArrayNode(JsonObject json, String memberName) {
        return GsonHelper.isValidNode(json, memberName) && json.get(memberName).isJsonArray();
    }

    public static boolean isObjectNode(JsonObject json, String memberName) {
        return GsonHelper.isValidNode(json, memberName) && json.get(memberName).isJsonObject();
    }

    public static boolean isValidPrimitive(JsonObject json, String memberName) {
        return GsonHelper.isValidNode(json, memberName) && json.get(memberName).isJsonPrimitive();
    }

    public static boolean isValidNode(@Nullable JsonObject json, String memberName) {
        return json != null && json.get(memberName) != null;
    }

    public static JsonElement getNonNull(JsonObject json, String memberName) {
        JsonElement jsonElement = json.get(memberName);
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            return jsonElement;
        }
        throw new JsonSyntaxException("Missing field " + memberName);
    }

    public static String convertToString(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsString();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a string, was " + GsonHelper.getType(json));
    }

    public static String getAsString(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToString(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a string");
    }

    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static @Nullable String getAsString(JsonObject json, String memberName, @Nullable String fallback) {
        return json.has(memberName) ? GsonHelper.convertToString(json.get(memberName), memberName) : fallback;
    }

    public static Holder<Item> convertToItem(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String asString = json.getAsString();
            return BuiltInRegistries.ITEM.get(Identifier.parse(asString)).orElseThrow(() -> new JsonSyntaxException("Expected " + memberName + " to be an item, was unknown string '" + asString + "'"));
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + GsonHelper.getType(json));
    }

    public static Holder<Item> getAsItem(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToItem(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static @Nullable Holder<Item> getAsItem(JsonObject json, String memberName, @Nullable Holder<Item> fallback) {
        return json.has(memberName) ? GsonHelper.convertToItem(json.get(memberName), memberName) : fallback;
    }

    public static boolean convertToBoolean(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Boolean, was " + GsonHelper.getType(json));
    }

    public static boolean getAsBoolean(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToBoolean(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Boolean");
    }

    public static boolean getAsBoolean(JsonObject json, String memberName, boolean fallback) {
        return json.has(memberName) ? GsonHelper.convertToBoolean(json.get(memberName), memberName) : fallback;
    }

    public static double convertToDouble(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Double, was " + GsonHelper.getType(json));
    }

    public static double getAsDouble(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToDouble(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Double");
    }

    public static double getAsDouble(JsonObject json, String memberName, double fallback) {
        return json.has(memberName) ? GsonHelper.convertToDouble(json.get(memberName), memberName) : fallback;
    }

    public static float convertToFloat(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Float, was " + GsonHelper.getType(json));
    }

    public static float getAsFloat(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToFloat(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Float");
    }

    public static float getAsFloat(JsonObject json, String memberName, float fallback) {
        return json.has(memberName) ? GsonHelper.convertToFloat(json.get(memberName), memberName) : fallback;
    }

    public static long convertToLong(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Long, was " + GsonHelper.getType(json));
    }

    public static long getAsLong(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToLong(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Long");
    }

    public static long getAsLong(JsonObject json, String memberName, long fallback) {
        return json.has(memberName) ? GsonHelper.convertToLong(json.get(memberName), memberName) : fallback;
    }

    public static int convertToInt(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Int, was " + GsonHelper.getType(json));
    }

    public static int getAsInt(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToInt(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Int");
    }

    public static int getAsInt(JsonObject json, String memberName, int fallback) {
        return json.has(memberName) ? GsonHelper.convertToInt(json.get(memberName), memberName) : fallback;
    }

    public static byte convertToByte(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Byte, was " + GsonHelper.getType(json));
    }

    public static byte getAsByte(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToByte(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Byte");
    }

    public static byte getAsByte(JsonObject json, String memberName, byte fallback) {
        return json.has(memberName) ? GsonHelper.convertToByte(json.get(memberName), memberName) : fallback;
    }

    public static char convertToCharacter(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Character, was " + GsonHelper.getType(json));
    }

    public static char getAsCharacter(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToCharacter(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Character");
    }

    public static char getAsCharacter(JsonObject json, String memberName, char fallback) {
        return json.has(memberName) ? GsonHelper.convertToCharacter(json.get(memberName), memberName) : fallback;
    }

    public static BigDecimal convertToBigDecimal(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a BigDecimal, was " + GsonHelper.getType(json));
    }

    public static BigDecimal getAsBigDecimal(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToBigDecimal(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a BigDecimal");
    }

    public static BigDecimal getAsBigDecimal(JsonObject json, String memberName, BigDecimal fallback) {
        return json.has(memberName) ? GsonHelper.convertToBigDecimal(json.get(memberName), memberName) : fallback;
    }

    public static BigInteger convertToBigInteger(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a BigInteger, was " + GsonHelper.getType(json));
    }

    public static BigInteger getAsBigInteger(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToBigInteger(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a BigInteger");
    }

    public static BigInteger getAsBigInteger(JsonObject json, String memberName, BigInteger fallback) {
        return json.has(memberName) ? GsonHelper.convertToBigInteger(json.get(memberName), memberName) : fallback;
    }

    public static short convertToShort(JsonElement json, String memberName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
            return json.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a Short, was " + GsonHelper.getType(json));
    }

    public static short getAsShort(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToShort(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Short");
    }

    public static short getAsShort(JsonObject json, String memberName, short fallback) {
        return json.has(memberName) ? GsonHelper.convertToShort(json.get(memberName), memberName) : fallback;
    }

    public static JsonObject convertToJsonObject(JsonElement json, String memberName) {
        if (json.isJsonObject()) {
            return json.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonObject, was " + GsonHelper.getType(json));
    }

    public static JsonObject getAsJsonObject(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToJsonObject(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonObject");
    }

    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static @Nullable JsonObject getAsJsonObject(JsonObject json, String memberName, @Nullable JsonObject fallback) {
        return json.has(memberName) ? GsonHelper.convertToJsonObject(json.get(memberName), memberName) : fallback;
    }

    public static JsonArray convertToJsonArray(JsonElement json, String memberName) {
        if (json.isJsonArray()) {
            return json.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a JsonArray, was " + GsonHelper.getType(json));
    }

    public static JsonArray getAsJsonArray(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonHelper.convertToJsonArray(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a JsonArray");
    }

    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static @Nullable JsonArray getAsJsonArray(JsonObject json, String memberName, @Nullable JsonArray fallback) {
        return json.has(memberName) ? GsonHelper.convertToJsonArray(json.get(memberName), memberName) : fallback;
    }

    public static <T> T convertToObject(@Nullable JsonElement json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json != null) {
            return (T)context.deserialize(json, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> T getAsObject(JsonObject json, String memberName, JsonDeserializationContext context, Class<? extends T> adapter) {
        if (json.has(memberName)) {
            return GsonHelper.convertToObject(json.get(memberName), memberName, context, adapter);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    @Contract(value="_,_,!null,_,_->!null;_,_,null,_,_->_")
    public static <T> @Nullable T getAsObject(JsonObject json, String memberName, @Nullable T fallback, JsonDeserializationContext context, Class<? extends T> adapter) {
        return json.has(memberName) ? GsonHelper.convertToObject(json.get(memberName), memberName, context, adapter) : fallback;
    }

    public static String getType(@Nullable JsonElement json) {
        String string = StringUtils.abbreviateMiddle((String)String.valueOf(json), (String)"...", (int)10);
        if (json == null) {
            return "null (missing)";
        }
        if (json.isJsonNull()) {
            return "null (json)";
        }
        if (json.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (json.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive asJsonPrimitive = json.getAsJsonPrimitive();
            if (asJsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (asJsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    public static <T> T fromJson(Gson gson, Reader reader, Class<T> adapter) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setStrictness(Strictness.STRICT);
            Object object = gson.getAdapter(adapter).read(jsonReader);
            if (object == null) {
                throw new JsonParseException("JSON data was null or empty");
            }
            return (T)object;
        }
        catch (IOException var5) {
            throw new JsonParseException((Throwable)var5);
        }
    }

    public static <T> @Nullable T fromNullableJson(Gson gson, Reader reader, TypeToken<T> token) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setStrictness(Strictness.STRICT);
            return (T)gson.getAdapter(token).read(jsonReader);
        }
        catch (IOException var4) {
            throw new JsonParseException((Throwable)var4);
        }
    }

    public static <T> T fromJson(Gson gson, Reader reader, TypeToken<T> type) {
        T object = GsonHelper.fromNullableJson(gson, reader, type);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    public static <T> @Nullable T fromNullableJson(Gson gson, String json, TypeToken<T> type) {
        return GsonHelper.fromNullableJson(gson, new StringReader(json), type);
    }

    public static <T> T fromJson(Gson gson, String json, Class<T> adapter) {
        return GsonHelper.fromJson(gson, (Reader)new StringReader(json), adapter);
    }

    public static JsonObject parse(String json) {
        return GsonHelper.parse(new StringReader(json));
    }

    public static JsonObject parse(Reader reader) {
        return GsonHelper.fromJson(GSON, reader, JsonObject.class);
    }

    public static JsonArray parseArray(String string) {
        return GsonHelper.parseArray(new StringReader(string));
    }

    public static JsonArray parseArray(Reader reader) {
        return GsonHelper.fromJson(GSON, reader, JsonArray.class);
    }

    public static String toStableString(JsonElement json) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            GsonHelper.writeValue(jsonWriter, json, Comparator.naturalOrder());
        }
        catch (IOException var4) {
            throw new AssertionError((Object)var4);
        }
        return stringWriter.toString();
    }

    public static void writeValue(JsonWriter writer, @Nullable JsonElement jsonElement, @Nullable Comparator<String> sorter) throws IOException {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            writer.nullValue();
        } else if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive asJsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (asJsonPrimitive.isNumber()) {
                writer.value(asJsonPrimitive.getAsNumber());
            } else if (asJsonPrimitive.isBoolean()) {
                writer.value(asJsonPrimitive.getAsBoolean());
            } else {
                writer.value(asJsonPrimitive.getAsString());
            }
        } else if (jsonElement.isJsonArray()) {
            writer.beginArray();
            for (JsonElement jsonElement1 : jsonElement.getAsJsonArray()) {
                GsonHelper.writeValue(writer, jsonElement1, sorter);
            }
            writer.endArray();
        } else {
            if (!jsonElement.isJsonObject()) {
                throw new IllegalArgumentException("Couldn't write " + String.valueOf(jsonElement.getClass()));
            }
            writer.beginObject();
            for (Map.Entry<String, JsonElement> entry : GsonHelper.sortByKeyIfNeeded(jsonElement.getAsJsonObject().entrySet(), sorter)) {
                writer.name(entry.getKey());
                GsonHelper.writeValue(writer, entry.getValue(), sorter);
            }
            writer.endObject();
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sortByKeyIfNeeded(Collection<Map.Entry<String, JsonElement>> entries, @Nullable Comparator<String> sorter) {
        if (sorter == null) {
            return entries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(sorter));
        return list;
    }

    public static boolean encodesLongerThan(JsonElement element, int maxLength) {
        try {
            Streams.write((JsonElement)element, (JsonWriter)new JsonWriter(Streams.writerForAppendable((Appendable)new CountedAppendable(maxLength))));
            return false;
        }
        catch (IllegalStateException var3) {
            return true;
        }
        catch (IOException var4) {
            throw new UncheckedIOException(var4);
        }
    }

    static class CountedAppendable
    implements Appendable {
        private int totalCount;
        private final int limit;

        public CountedAppendable(int limit) {
            this.limit = limit;
        }

        private Appendable accountChars(int count) {
            this.totalCount += count;
            if (this.totalCount > this.limit) {
                throw new IllegalStateException("Character count over limit: " + this.totalCount + " > " + this.limit);
            }
            return this;
        }

        @Override
        public Appendable append(CharSequence sequence) {
            return this.accountChars(sequence.length());
        }

        @Override
        public Appendable append(CharSequence sequence, int start, int end) {
            return this.accountChars(end - start);
        }

        @Override
        public Appendable append(char character) {
            return this.accountChars(1);
        }
    }
}

