/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public interface ProblemReporter {
    public static final ProblemReporter DISCARDING = new ProblemReporter(){

        @Override
        public ProblemReporter forChild(PathElement child) {
            return this;
        }

        @Override
        public void report(Problem problem) {
        }
    };

    public ProblemReporter forChild(PathElement var1);

    public void report(Problem var1);

    public static class ScopedCollector
    extends Collector
    implements AutoCloseable {
        private final Logger logger;

        public ScopedCollector(Logger logger) {
            this.logger = logger;
        }

        public ScopedCollector(PathElement element, Logger logger) {
            super(element);
            this.logger = logger;
        }

        @Override
        public void close() {
            if (!this.isEmpty()) {
                this.logger.warn("[{}] Serialization errors:\n{}", (Object)this.logger.getName(), (Object)this.getTreeReport());
            }
        }
    }

    public record RootFieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    public record RootElementPathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "{" + String.valueOf(this.id.identifier()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public static interface Problem {
        public String description();
    }

    @FunctionalInterface
    public static interface PathElement {
        public String get();
    }

    public record IndexedPathElement(int index) implements PathElement
    {
        @Override
        public String get() {
            return "[" + this.index + "]";
        }
    }

    public record IndexedFieldPathElement(String name, int index) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name + "[" + this.index + "]";
        }
    }

    public record FieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name;
        }
    }

    public record ElementReferencePathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "->{" + String.valueOf(this.id.identifier()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public static class Collector
    implements ProblemReporter {
        public static final PathElement EMPTY_ROOT = () -> "";
        private final @Nullable Collector parent;
        private final PathElement element;
        private final Set<Entry> problems;

        public Collector() {
            this(EMPTY_ROOT);
        }

        public Collector(PathElement element) {
            this.parent = null;
            this.problems = new LinkedHashSet<Entry>();
            this.element = element;
        }

        private Collector(Collector parent, PathElement element) {
            this.problems = parent.problems;
            this.parent = parent;
            this.element = element;
        }

        @Override
        public ProblemReporter forChild(PathElement child) {
            return new Collector(this, child);
        }

        @Override
        public void report(Problem problem) {
            this.problems.add(new Entry(this, problem));
        }

        public boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public void forEach(BiConsumer<String, Problem> action) {
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            StringBuilder stringBuilder = new StringBuilder();
            for (Entry entry : this.problems) {
                Collector collector = entry.source;
                while (collector != null) {
                    list.add(collector.element);
                    collector = collector.parent;
                }
                for (int i = list.size() - 1; i >= 0; --i) {
                    stringBuilder.append(((PathElement)list.get(i)).get());
                }
                action.accept(stringBuilder.toString(), entry.problem());
                stringBuilder.setLength(0);
                list.clear();
            }
        }

        public String getReport() {
            HashMultimap multimap = HashMultimap.create();
            this.forEach((arg_0, arg_1) -> ((Multimap)multimap).put(arg_0, arg_1));
            return multimap.asMap().entrySet().stream().map(entry -> " at " + (String)entry.getKey() + ": " + ((Collection)entry.getValue()).stream().map(Problem::description).collect(Collectors.joining("; "))).collect(Collectors.joining("\n"));
        }

        public String getTreeReport() {
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            ProblemTreeNode problemTreeNode = new ProblemTreeNode(this.element);
            for (Entry entry : this.problems) {
                Collector collector = entry.source;
                while (collector != this) {
                    list.add(collector.element);
                    collector = collector.parent;
                }
                ProblemTreeNode problemTreeNode1 = problemTreeNode;
                for (int i = list.size() - 1; i >= 0; --i) {
                    problemTreeNode1 = problemTreeNode1.child((PathElement)list.get(i));
                }
                list.clear();
                problemTreeNode1.problems.add(entry.problem);
            }
            return String.join((CharSequence)"\n", problemTreeNode.getLines());
        }

        record Entry(Collector source, Problem problem) {
        }

        record ProblemTreeNode(PathElement element, List<Problem> problems, Map<PathElement, ProblemTreeNode> children) {
            public ProblemTreeNode(PathElement element) {
                this(element, new ArrayList<Problem>(), new LinkedHashMap<PathElement, ProblemTreeNode>());
            }

            public ProblemTreeNode child(PathElement element) {
                return this.children.computeIfAbsent(element, ProblemTreeNode::new);
            }

            public List<String> getLines() {
                int size = this.problems.size();
                int size1 = this.children.size();
                if (size == 0 && size1 == 0) {
                    return List.of();
                }
                if (size == 0 && size1 == 1) {
                    ArrayList<String> list = new ArrayList<String>();
                    this.children.forEach((pathElement, problemTreeNode) -> list.addAll(problemTreeNode.getLines()));
                    list.set(0, this.element.get() + (String)list.get(0));
                    return list;
                }
                if (size == 1 && size1 == 0) {
                    return List.of(this.element.get() + ": " + this.problems.getFirst().description());
                }
                ArrayList<String> list = new ArrayList<String>();
                this.children.forEach((pathElement, problemTreeNode) -> list.addAll(problemTreeNode.getLines()));
                list.replaceAll(string -> "  " + string);
                for (Problem problem : this.problems) {
                    list.add("  " + problem.description());
                }
                list.addFirst(this.element.get() + ":");
                return list;
            }
        }
    }
}

