/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import ca.spottedleaf.concurrentutil.util.IntegerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.function.IntConsumer;
import net.minecraft.util.BitStorage;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public class SimpleBitStorage
implements BitStorage {
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final long divideMulUnsigned;
    private final int divideAdd;
    private final long divideAddUnsigned;
    private final int divideShift;
    private static final int[] BETTER_MAGIC = new int[33];
    private final int magic;
    private final int mulBits;

    public SimpleBitStorage(int bits, int size, int[] data) {
        this(bits, size);
        int i1;
        int i = 0;
        for (i1 = 0; i1 <= size - this.valuesPerLong; i1 += this.valuesPerLong) {
            long l = 0L;
            for (int i2 = this.valuesPerLong - 1; i2 >= 0; --i2) {
                l <<= bits;
                l |= (long)data[i1 + i2] & this.mask;
            }
            this.data[i++] = l;
        }
        int i3 = size - i1;
        if (i3 > 0) {
            long l1 = 0L;
            for (int i4 = i3 - 1; i4 >= 0; --i4) {
                l1 <<= bits;
                l1 |= (long)data[i1 + i4] & this.mask;
            }
            this.data[i] = l1;
        }
    }

    public SimpleBitStorage(int bits, int size) {
        this(bits, size, (long[])null);
    }

    public SimpleBitStorage(int bits, int size, long @Nullable [] data) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)bits);
        this.size = size;
        this.bits = bits;
        this.mask = (1L << bits) - 1L;
        this.valuesPerLong = (char)(64 / bits);
        int i = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[i + 0];
        this.divideMulUnsigned = Integer.toUnsignedLong(this.divideMul);
        this.divideAdd = MAGIC[i + 1];
        this.divideAddUnsigned = Integer.toUnsignedLong(this.divideAdd);
        this.divideShift = MAGIC[i + 2];
        int i1 = (size + this.valuesPerLong - 1) / this.valuesPerLong;
        if (data != null) {
            if (data.length != i1) {
                throw new InitializationException("Invalid length given for storage, got: " + data.length + " but expected: " + i1);
            }
            this.data = data;
        } else {
            this.data = new long[i1];
        }
        this.magic = BETTER_MAGIC[this.bits];
        this.mulBits = 64 / this.bits * this.bits;
        if (this.size > 4096) {
            throw new IllegalStateException("Size > 4096 not supported");
        }
    }

    private int cellIndex(int index) {
        return (int)((long)index * this.divideMulUnsigned + this.divideAddUnsigned >> 32 >> this.divideShift);
    }

    @Override
    public final int getAndSet(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.data;
        long data = dataArray[divQ];
        long mask = this.mask;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
        return (int)(data >>> divR & mask);
    }

    @Override
    public final void set(int index, int value) {
        long write;
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        long[] dataArray = this.data;
        long data = dataArray[divQ];
        long mask = this.mask;
        dataArray[divQ] = write = data & (mask << divR ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & mask) << divR;
    }

    @Override
    public final int get(int index) {
        int full = this.magic * index;
        int divQ = full >>> 20;
        int divR = (full & 0xFFFFF) * this.mulBits >>> 20;
        return (int)(this.data[divQ] >>> divR & this.mask);
    }

    @Override
    public long[] getRaw() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void getAll(IntConsumer consumer) {
        int i = 0;
        for (long l : this.data) {
            for (int i1 = 0; i1 < this.valuesPerLong; ++i1) {
                consumer.accept((int)(l & this.mask));
                l >>= this.bits;
                if (++i < this.size) continue;
                return;
            }
        }
    }

    @Override
    public void unpack(int[] array) {
        int i3;
        long l;
        int i2;
        int i = this.data.length;
        int i1 = 0;
        for (i2 = 0; i2 < i - 1; ++i2) {
            l = this.data[i2];
            for (i3 = 0; i3 < this.valuesPerLong; ++i3) {
                array[i1 + i3] = (int)(l & this.mask);
                l >>= this.bits;
            }
            i1 += this.valuesPerLong;
        }
        i2 = this.size - i1;
        if (i2 > 0) {
            l = this.data[i - 1];
            for (i3 = 0; i3 < i2; ++i3) {
                array[i1 + i3] = (int)(l & this.mask);
                l >>= this.bits;
            }
        }
    }

    @Override
    public BitStorage copy() {
        return new SimpleBitStorage(this.bits, this.size, (long[])this.data.clone());
    }

    @Override
    public final Int2ObjectOpenHashMap<ShortArrayList> moonrise$countEntries() {
        int valuesPerLong = this.valuesPerLong;
        int bits = this.bits;
        long mask = (1L << bits) - 1L;
        int size = this.size;
        if (bits <= 6) {
            ShortArrayList[] byId = new ShortArrayList[1 << bits];
            Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(1 << bits);
            int index = 0;
            for (long value : this.data) {
                int li = 0;
                do {
                    ShortArrayList newCoords;
                    int paletteIdx = (int)(value & mask);
                    value >>= bits;
                    ++li;
                    ShortArrayList coords = byId[paletteIdx];
                    if (coords != null) {
                        coords.add((short)index++);
                        continue;
                    }
                    byId[paletteIdx] = newCoords = new ShortArrayList(64);
                    newCoords.add((short)index++);
                    ret.put(paletteIdx, (Object)newCoords);
                } while (li < valuesPerLong && index < size);
            }
            return ret;
        }
        Int2ObjectOpenHashMap ret = new Int2ObjectOpenHashMap(64);
        int index = 0;
        for (long value : this.data) {
            int li = 0;
            do {
                int paletteIdx = (int)(value & mask);
                value >>= bits;
                ((ShortArrayList)ret.computeIfAbsent(paletteIdx, key -> new ShortArrayList(64))).add((short)index++);
            } while (++li < valuesPerLong && index < size);
        }
        return ret;
    }

    static {
        for (int bits = 1; bits < BETTER_MAGIC.length; ++bits) {
            SimpleBitStorage.BETTER_MAGIC[bits] = (int)IntegerUtil.getUnsignedDivisorMagic((long)(64L / (long)bits), (int)20);
        }
    }

    public static class InitializationException
    extends RuntimeException {
        InitializationException(String message) {
            super(message);
        }
    }
}

