/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;

@FunctionalInterface
public interface TaskChainer {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static TaskChainer immediate(final Executor executor) {
        return new TaskChainer(){

            @Override
            public <T> void append(CompletableFuture<T> future, Consumer<T> consumer) {
                ((CompletableFuture)future.thenAcceptAsync((Consumer)consumer, executor)).exceptionally(throwable -> {
                    LOGGER.error("Task failed", throwable);
                    return null;
                });
            }
        };
    }

    default public void append(Runnable task) {
        this.append(CompletableFuture.completedFuture(null), object -> task.run());
    }

    public <T> void append(CompletableFuture<T> var1, Consumer<T> var2);
}

