/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.TracingExecutor;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Util {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final int DEFAULT_SAFE_FILE_OPERATION_RETRIES = 10;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final TracingExecutor BACKGROUND_EXECUTOR = Util.makeExecutor("Main", -1);
    private static final TracingExecutor IO_POOL = Util.makeIoExecutor("IO-Worker-", false);
    public static final TracingExecutor DIMENSION_DATA_IO_POOL = Util.makeExtraIoExecutor("Dimension-Data-IO-Worker-");
    private static final TracingExecutor DOWNLOAD_POOL = new TracingExecutor(Executors.newFixedThreadPool(4, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable run) {
            Thread ret = new Thread(run);
            ret.setDaemon(true);
            ret.setName("Download-" + this.count.getAndIncrement());
            ret.setUncaughtExceptionHandler((thread, throwable) -> LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable));
            return ret;
        }
    }));
    private static final DateTimeFormatter FILENAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int LINEAR_LOOKUP_THRESHOLD = 8;
    private static final Set<String> ALLOWED_UNTRUSTED_LINK_PROTOCOLS = Set.of("http", "https");
    public static final long NANOS_PER_MILLI = 1000000L;
    public static TimeSource.NanoTimeSource timeSource = System::nanoTime;
    public static final Ticker TICKER = new Ticker(){

        public long read() {
            return timeSource.getAsLong();
        }
    };
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(provider -> provider.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> thePauser = string -> {};
    public static final double COLLISION_EPSILON = 1.0E-7;

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> toMutableList() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String getPropertyName(Property<T> property, Object value) {
        return property.getName((Comparable)value);
    }

    public static String makeDescriptionId(String type, @Nullable Identifier id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.getNamespace() + "." + id.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return Util.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return System.nanoTime();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    public static String getFilenameFormattedDateTime() {
        return FILENAME_DATE_TIME_FORMATTER.format(ZonedDateTime.now());
    }

    private static TracingExecutor makeExecutor(final String name, int priorityModifier) {
        Object directExecutorService;
        int i = Util.maxAllowedExecutorThreads();
        if (i <= 0) {
            directExecutorService = MoreExecutors.newDirectExecutorService();
        } else {
            AtomicInteger atomicInteger = new AtomicInteger(1);
            directExecutorService = new ForkJoinPool(i, forkJoinPool -> {
                final String string = "Worker-" + name + "-" + atomicInteger.getAndIncrement();
                ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                    @Override
                    protected void onStart() {
                        TracyClient.setThreadName((String)string, (int)name.hashCode());
                        super.onStart();
                    }

                    @Override
                    protected void onTermination(@Nullable Throwable throwOnTermination) {
                        if (throwOnTermination != null) {
                            LOGGER.warn("{} died", (Object)this.getName(), (Object)throwOnTermination);
                        } else {
                            LOGGER.debug("{} shutdown", (Object)this.getName());
                        }
                        super.onTermination(throwOnTermination);
                    }
                };
                forkJoinWorkerThread.setPriority(5 + priorityModifier);
                forkJoinWorkerThread.setName(string);
                return forkJoinWorkerThread;
            }, Util::onThreadException, true, 0, Integer.MAX_VALUE, 1, null, 365L, TimeUnit.DAYS);
        }
        return new TracingExecutor((ExecutorService)directExecutorService);
    }

    public static int maxAllowedExecutorThreads() {
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        int maxExecutorThreads = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : (cpus <= 8 ? Math.max(3, cpus - 2) : cpus * 2 / 3);
        maxExecutorThreads = Math.min(8, maxExecutorThreads);
        return Integer.getInteger("Paper.WorkerThreadCount", maxExecutorThreads);
    }

    private static int getMaxThreads() {
        String property = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if (property != null) {
            try {
                int i = Integer.parseInt(property);
                if (i >= 1 && i <= 255) {
                    return i;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, property, 255});
            }
            catch (NumberFormatException var2) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{MAX_THREADS_SYSTEM_PROPERTY, property, 255});
            }
        }
        return 255;
    }

    public static TracingExecutor backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static TracingExecutor ioPool() {
        return IO_POOL;
    }

    public static TracingExecutor nonCriticalIoPool() {
        return DOWNLOAD_POOL;
    }

    public static void shutdownExecutors() {
        BACKGROUND_EXECUTOR.shutdownAndAwait(3L, TimeUnit.SECONDS);
        IO_POOL.shutdownAndAwait(3L, TimeUnit.SECONDS);
    }

    private static TracingExecutor makeIoExecutor(String name, boolean daemon) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newCachedThreadPool(task -> {
            Thread thread = new Thread(task);
            String string = name + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string, (int)name.hashCode());
            thread.setName(string);
            thread.setDaemon(daemon);
            thread.setUncaughtExceptionHandler(Util::onThreadException);
            return thread;
        }));
    }

    private static TracingExecutor makeExtraIoExecutor(String namePrefix) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(false);
            thread.setUncaughtExceptionHandler(Util::onThreadException);
            return thread;
        }));
    }

    public static void throwAsRuntime(Throwable throwable) {
        throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    public static void onThreadException(Thread thread, Throwable throwable) {
        Util.pauseInIde(throwable);
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)throwable;
            Bootstrap.realStdoutPrintln(reportedException.getReport().getFriendlyReport(ReportType.CRASH));
            System.exit(-1);
        }
        LOGGER.error("Caught exception in thread {}", (Object)thread, (Object)throwable);
    }

    public static @Nullable Type<?> fetchChoiceType(DSL.TypeReference type, String choiceName) {
        return !SharedConstants.CHECK_DATA_FIXER_SCHEMA ? null : Util.doFetchChoiceType(type, choiceName);
    }

    private static @Nullable Type<?> doFetchChoiceType(DSL.TypeReference type, String choiceName) {
        Type type1;
        block2: {
            type1 = null;
            try {
                type1 = DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().dataVersion().version())).getChoiceType(type, choiceName);
            }
            catch (IllegalArgumentException var4) {
                LOGGER.error("No data fixer registered for {}", (Object)choiceName);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw var4;
            }
        }
        return type1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runNamed(Runnable task, String name) {
        block16: {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                Thread thread = Thread.currentThread();
                String name1 = thread.getName();
                thread.setName(name);
                try (Zone zone = TracyClient.beginZone((String)name, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                    task.run();
                    break block16;
                }
                finally {
                    thread.setName(name1);
                }
            }
            try (Zone zone1 = TracyClient.beginZone((String)name, (boolean)SharedConstants.IS_RUNNING_IN_IDE);){
                task.run();
            }
        }
    }

    public static <T> String getRegisteredName(Registry<T> registry, T value) {
        Identifier key = registry.getKey(value);
        return key == null ? "[unregistered]" : key.toString();
    }

    public static <T> Predicate<T> allOf() {
        return input -> true;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return input -> predicate1.test(input) && predicate2.test(input);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input) && predicate4.test(input);
    }

    public static <T> Predicate<T> allOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4, Predicate<? super T> predicate5) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input) && predicate4.test(input) && predicate5.test(input);
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<? super T> ... predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(input)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> allOf(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> Util.allOf();
            case 1 -> Util.allOf(predicates.get(0));
            case 2 -> Util.allOf(predicates.get(0), predicates.get(1));
            case 3 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> Util.allOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates1 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield Util.allOf(predicates1);
            }
        };
    }

    public static <T> Predicate<T> anyOf() {
        return input -> false;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return input -> predicate1.test(input) || predicate2.test(input);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input) || predicate4.test(input);
    }

    public static <T> Predicate<T> anyOf(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4, Predicate<? super T> predicate5) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input) || predicate4.test(input) || predicate5.test(input);
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<? super T> ... predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(input)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> anyOf(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> Util.anyOf();
            case 1 -> Util.anyOf(predicates.get(0));
            case 2 -> Util.anyOf(predicates.get(0), predicates.get(1));
            case 3 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> Util.anyOf(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates1 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield Util.anyOf(predicates1);
            }
        };
    }

    public static <T> boolean isSymmetrical(int width, int height, List<T> list) {
        if (width == 1) {
            return true;
        }
        int i = width / 2;
        for (int i1 = 0; i1 < height; ++i1) {
            for (int i2 = 0; i2 < i; ++i2) {
                T object1;
                int i3 = width - 1 - i2;
                T object = list.get(i2 + i1 * width);
                if (object.equals(object1 = list.get(i3 + i1 * width))) continue;
                return false;
            }
        }
        return true;
    }

    public static int growByHalf(int value, int minValue) {
        return (int)Math.max(Math.min((long)value + (long)(value >> 1), 0x7FFFFFF7L), (long)minValue);
    }

    @SuppressForbidden(reason="Intentional use of default locale for user-visible date")
    public static DateTimeFormatter localizedDateFormatter(FormatStyle dateTimeStyle) {
        return DateTimeFormatter.ofLocalizedDateTime(dateTimeStyle);
    }

    public static OS getPlatform() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.WINDOWS;
        }
        if (string.contains("mac")) {
            return OS.OSX;
        }
        if (string.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (string.contains("linux")) {
            return OS.LINUX;
        }
        return string.contains("unix") ? OS.LINUX : OS.UNKNOWN;
    }

    public static boolean isAarch64() {
        String string = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        return string.equals("aarch64");
    }

    public static URI parseAndValidateUntrustedUri(String uri) throws URISyntaxException {
        URI uri1 = new URI(uri);
        String scheme = uri1.getScheme();
        if (scheme == null) {
            throw new URISyntaxException(uri, "Missing protocol in URI: " + uri);
        }
        String string = scheme.toLowerCase(Locale.ROOT);
        if (!ALLOWED_UNTRUSTED_LINK_PROTOCOLS.contains(string)) {
            throw new URISyntaxException(uri, "Unsupported protocol in URI: " + uri);
        }
        return uri1;
    }

    public static <T> T findNextInIterable(Iterable<T> iterable, @Nullable T element) {
        Iterator<T> iterator = iterable.iterator();
        T object = iterator.next();
        if (element != null) {
            T object1 = object;
            while (object1 != element) {
                if (!iterator.hasNext()) continue;
                object1 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return object;
    }

    public static <T> T findPreviousInIterable(Iterable<T> iterable, @Nullable T current) {
        Iterator<T> iterator = iterable.iterator();
        T object = null;
        while (iterator.hasNext()) {
            T object1 = iterator.next();
            if (object1 == current) {
                if (object != null) break;
                object = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : current);
                break;
            }
            object = object1;
        }
        return object;
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<? super T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static <K extends Enum<K>, V> Map<K, V> makeEnumMap(Class<K> enumClass, java.util.function.Function<K, V> valueGetter) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(enumClass);
        for (Enum _enum : (Enum[])enumClass.getEnumConstants()) {
            map.put(_enum, valueGetter.apply(_enum));
        }
        return map;
    }

    public static <K, V1, V2> Map<K, V2> mapValues(Map<K, V1> map, java.util.function.Function<? super V1, V2> mapper) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mapper.apply((Object)entry.getValue())));
    }

    public static <K, V1, V2> Map<K, V2> mapValuesLazy(Map<K, V1> map, Function<V1, V2> mapper) {
        return Maps.transformValues(map, mapper);
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.getFirst().thenApply(ObjectLists::singleton);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(_void -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> completableFutures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return Util.fallibleSequence(completableFutures, completableFuture::completeExceptionally).applyToEither((CompletionStage)completableFuture, java.util.function.Function.identity());
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFastAndCancel(List<? extends CompletableFuture<? extends V>> completableFutures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return Util.fallibleSequence(completableFutures, throwable -> {
            if (completableFuture.completeExceptionally((Throwable)throwable)) {
                for (CompletableFuture completableFuture1 : completableFutures) {
                    completableFuture1.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)completableFuture, java.util.function.Function.identity());
    }

    private static <V> CompletableFuture<List<V>> fallibleSequence(List<? extends CompletableFuture<? extends V>> completableFutures, Consumer<Throwable> throwableConsumer) {
        ObjectArrayList list = new ObjectArrayList();
        list.size(completableFutures.size());
        CompletableFuture[] completableFutures1 = new CompletableFuture[completableFutures.size()];
        for (int i = 0; i < completableFutures.size(); ++i) {
            int i1 = i;
            completableFutures1[i] = completableFutures.get(i).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    throwableConsumer.accept((Throwable)throwable);
                } else {
                    list.set(i1, result);
                }
            });
        }
        return CompletableFuture.allOf(completableFutures1).thenApply(future -> list);
    }

    public static <T> Optional<T> ifElse(Optional<T> optional, Consumer<T> ifPresent, Runnable ifEmpty) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            ifEmpty.run();
        }
        return optional;
    }

    public static <T> Supplier<T> name(final Supplier<T> item, Supplier<String> nameSupplier) {
        if (SharedConstants.DEBUG_NAMED_RUNNABLES) {
            final String string = nameSupplier.get();
            return new Supplier<T>(){

                @Override
                public T get() {
                    return item.get();
                }

                public String toString() {
                    return string;
                }
            };
        }
        return item;
    }

    public static Runnable name(final Runnable item, Supplier<String> nameSupplier) {
        if (SharedConstants.DEBUG_NAMED_RUNNABLES) {
            final String string = nameSupplier.get();
            return new Runnable(){

                @Override
                public void run() {
                    item.run();
                }

                public String toString() {
                    return string;
                }
            };
        }
        return item;
    }

    public static void logAndPauseIfInIde(String message) {
        LOGGER.error(message);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(message);
        }
    }

    public static void logAndPauseIfInIde(String message, Throwable error) {
        LOGGER.error(message, error);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Util.doPause(message);
        }
    }

    public static <T extends Throwable> T pauseInIde(T throwable) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", throwable);
            Util.doPause(throwable.getMessage());
        }
        return throwable;
    }

    public static void setPause(Consumer<String> thePauser) {
        Util.thePauser = thePauser;
    }

    private static void doPause(String message) {
        boolean flag;
        Instant instant = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl = flag = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!flag) {
            thePauser.accept(message);
        }
    }

    public static String describeError(Throwable throwable) {
        if (throwable.getCause() != null) {
            return Util.describeError(throwable.getCause());
        }
        return throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
    }

    public static <T> T getRandom(T[] selections, RandomSource random) {
        return selections[random.nextInt(selections.length)];
    }

    public static int getRandom(int[] selections, RandomSource random) {
        return selections[random.nextInt(selections.length)];
    }

    public static <T> T getRandom(List<T> selections, RandomSource random) {
        return selections.get(random.nextInt(selections.size()));
    }

    public static <T> Optional<T> getRandomSafe(List<T> selections, RandomSource random) {
        return selections.isEmpty() ? Optional.empty() : Optional.of(Util.getRandom(selections, random));
    }

    private static BooleanSupplier createRenamer(final Path filePath, final Path newName) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(filePath, newName, new CopyOption[0]);
                    return true;
                }
                catch (IOException var2) {
                    LOGGER.error("Failed to rename", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "rename " + String.valueOf(filePath) + " to " + String.valueOf(newName);
            }
        };
    }

    private static BooleanSupplier createDeleter(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(filePath);
                    return true;
                }
                catch (IOException var2) {
                    LOGGER.warn("Failed to delete", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + String.valueOf(filePath);
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(filePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(filePath) + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(filePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(filePath) + " is present";
            }
        };
    }

    private static boolean executeInSequence(BooleanSupplier ... suppliers) {
        for (BooleanSupplier booleanSupplier : suppliers) {
            if (booleanSupplier.getAsBoolean()) continue;
            LOGGER.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean runWithRetries(int maxTries, String actionName, BooleanSupplier ... suppliers) {
        for (int i = 0; i < maxTries; ++i) {
            if (Util.executeInSequence(suppliers)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", new Object[]{actionName, i, maxTries});
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)actionName);
        return false;
    }

    public static void safeReplaceFile(Path current, Path latest, Path oldBackup) {
        Util.safeReplaceOrMoveFile(current, latest, oldBackup, false);
    }

    public static boolean safeReplaceOrMoveFile(Path current, Path latest, Path oldBackup, boolean restore) {
        if (Files.exists(current, new LinkOption[0]) && !Util.runWithRetries(10, "create backup " + String.valueOf(oldBackup), Util.createDeleter(oldBackup), Util.createRenamer(current, oldBackup), Util.createFileCreatedCheck(oldBackup))) {
            return false;
        }
        if (!Util.runWithRetries(10, "remove old " + String.valueOf(current), Util.createDeleter(current), Util.createFileDeletedCheck(current))) {
            return false;
        }
        if (!Util.runWithRetries(10, "replace " + String.valueOf(current) + " with " + String.valueOf(latest), Util.createRenamer(latest, current), Util.createFileCreatedCheck(current)) && !restore) {
            Util.runWithRetries(10, "restore " + String.valueOf(current) + " from " + String.valueOf(oldBackup), Util.createRenamer(oldBackup, current), Util.createFileCreatedCheck(current));
            return false;
        }
        return true;
    }

    public static int offsetByCodepoints(String text, int cursorPos, int direction) {
        int len = text.length();
        if (direction >= 0) {
            for (int i = 0; cursorPos < len && i < direction; ++i) {
                if (!Character.isHighSurrogate(text.charAt(cursorPos++)) || cursorPos >= len || !Character.isLowSurrogate(text.charAt(cursorPos))) continue;
                ++cursorPos;
            }
        } else {
            for (int ix = direction; cursorPos > 0 && ix < 0; ++ix) {
                if (!Character.isLowSurrogate(text.charAt(--cursorPos)) || cursorPos <= 0 || !Character.isHighSurrogate(text.charAt(cursorPos - 1))) continue;
                --cursorPos;
            }
        }
        return cursorPos;
    }

    public static Consumer<String> prefix(String prefix, Consumer<String> expectedSize) {
        return string -> expectedSize.accept(prefix + string);
    }

    public static DataResult<int[]> fixedSize(IntStream stream, int size) {
        int[] ints = stream.limit(size + 1).toArray();
        if (ints.length != size) {
            Supplier<String> supplier = () -> "Input is not a list of " + size + " ints";
            return ints.length >= size ? DataResult.error(supplier, (Object)Arrays.copyOf(ints, size)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)ints);
    }

    public static DataResult<long[]> fixedSize(LongStream stream, int expectedSize) {
        long[] longs = stream.limit(expectedSize + 1).toArray();
        if (longs.length != expectedSize) {
            Supplier<String> supplier = () -> "Input is not a list of " + expectedSize + " longs";
            return longs.length >= expectedSize ? DataResult.error(supplier, (Object)Arrays.copyOf(longs, expectedSize)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)longs);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> list, int expectedSize) {
        if (list.size() != expectedSize) {
            Supplier<String> supplier = () -> "Input is not a list of " + expectedSize + " elements";
            return list.size() >= expectedSize ? DataResult.error(supplier, list.subList(0, expectedSize)) : DataResult.error(supplier);
        }
        return DataResult.success(list);
    }

    public static void startTimerHackThread() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var2) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        thread.start();
    }

    public static void copyBetweenDirs(Path fromDirectory, Path toDirectory, Path filePath) throws IOException {
        Path path = fromDirectory.relativize(filePath);
        Path path1 = toDirectory.resolve(path);
        Files.copy(filePath, path1, new CopyOption[0]);
    }

    public static String sanitizeName(String fileName, CharPredicate characterValidator) {
        return fileName.toLowerCase(Locale.ROOT).chars().mapToObj(i -> characterValidator.test((char)i) ? Character.toString((char)i) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> singleKeyCache(java.util.function.Function<K, V> computeValue) {
        return new SingleKeyCache<K, V>(computeValue);
    }

    public static <T, R> java.util.function.Function<T, R> memoize(final java.util.function.Function<T, R> memoFunction) {
        return new java.util.function.Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T key) {
                return this.cache.computeIfAbsent(key, memoFunction);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(memoFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(final BiFunction<T, U, R> memoBiFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T key1, U key2) {
                return this.cache.computeIfAbsent(Pair.of(key1, key2), pair -> memoBiFunction.apply(pair.getFirst(), pair.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(memoBiFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T> List<T> toShuffledList(Stream<T> stream, RandomSource random) {
        ObjectArrayList list = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        Util.shuffle(list, random);
        return list;
    }

    public static IntArrayList toShuffledList(IntStream stream, RandomSource random) {
        int size;
        IntArrayList list = IntArrayList.wrap((int[])stream.toArray());
        for (int i = size = list.size(); i > 1; --i) {
            int randomInt = random.nextInt(i);
            list.set(i - 1, list.set(randomInt, list.getInt(i - 1)));
        }
        return list;
    }

    public static <T> List<T> shuffledCopy(T[] array, RandomSource random) {
        ObjectArrayList list = new ObjectArrayList((Object[])array);
        Util.shuffle(list, random);
        return list;
    }

    public static <T> List<T> shuffledCopy(ObjectArrayList<T> list, RandomSource random) {
        ObjectArrayList list1 = new ObjectArrayList(list);
        Util.shuffle(list1, random);
        return list1;
    }

    public static <T> void shuffle(List<T> list, RandomSource random) {
        int size;
        for (int i = size = list.size(); i > 1; --i) {
            int randomInt = random.nextInt(i);
            list.set(i - 1, list.set(randomInt, list.get(i - 1)));
        }
    }

    public static <T> CompletableFuture<T> blockUntilDone(java.util.function.Function<Executor, CompletableFuture<T>> task) {
        return Util.blockUntilDone(task, CompletableFuture::isDone);
    }

    public static <T> T blockUntilDone(java.util.function.Function<Executor, T> task, Predicate<T> donePredicate) {
        int size;
        LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        T object = task.apply(blockingQueue::add);
        while (!donePredicate.test(object)) {
            try {
                Runnable runnable = (Runnable)blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException var5) {
                LOGGER.warn("Interrupted wait");
                break;
            }
        }
        if ((size = blockingQueue.size()) > 0) {
            LOGGER.warn("Tasks left in queue: {}", (Object)size);
        }
        return object;
    }

    public static <T> ToIntFunction<T> createIndexLookup(List<T> list) {
        int size = list.size();
        if (size < 8) {
            return list::indexOf;
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap(size);
        map.defaultReturnValue(-1);
        for (int i = 0; i < size; ++i) {
            map.put(list.get(i), i);
        }
        return map;
    }

    public static <T> ToIntFunction<T> createIndexIdentityLookup(List<T> list) {
        int size = list.size();
        if (size < 8) {
            ReferenceImmutableList list1 = new ReferenceImmutableList(list);
            return arg_0 -> ((ReferenceList)list1).indexOf(arg_0);
        }
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap(size);
        map.defaultReturnValue(-1);
        for (int i = 0; i < size; ++i) {
            map.put(list.get(i), i);
        }
        return map;
    }

    public static <A, B> Typed<B> writeAndReadTypedOrThrow(Typed<A> typed, Type<B> type, UnaryOperator<Dynamic<?>> operator) {
        Dynamic dynamic = (Dynamic)((Object)typed.write().getOrThrow());
        return Util.readTypedOrThrow(type, (Dynamic)((Object)operator.apply(dynamic)), true);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> type, Dynamic<?> data) {
        return Util.readTypedOrThrow(type, data, false);
    }

    public static <T> Typed<T> readTypedOrThrow(Type<T> type, Dynamic<?> data, boolean partial) {
        DataResult dataResult = type.readTyped(data).map(Pair::getFirst);
        try {
            return partial ? (Typed)dataResult.getPartialOrThrow(IllegalStateException::new) : (Typed)dataResult.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException var7) {
            CrashReport crashReport = CrashReport.forThrowable(var7, "Reading type");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Info");
            crashReportCategory.setDetail("Data", data);
            crashReportCategory.setDetail("Type", type);
            throw new ReportedException(crashReport);
        }
    }

    public static <T> List<T> copyAndAdd(List<T> list, T value) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).addAll(list).add(value).build();
    }

    public static <T> List<T> copyAndAdd(T value, List<T> list) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).add(value).addAll(list).build();
    }

    public static <K, V> Map<K, V> copyAndPut(Map<K, V> map, K key, V value) {
        return ImmutableMap.builderWithExpectedSize((int)(map.size() + 1)).putAll(map).put(key, value).buildKeepingLast();
    }

    public static enum OS {
        LINUX("linux"),
        SOLARIS("solaris"),
        WINDOWS("windows"){

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
            }
        }
        ,
        OSX("mac"){

            @Override
            protected String[] getOpenUriArguments(URI uri) {
                return new String[]{"open", uri.toString()};
            }
        }
        ,
        UNKNOWN("unknown");

        private final String telemetryName;

        private OS(String telemetryName) {
            this.telemetryName = telemetryName;
        }

        public void openUri(URI uri) {
            try {
                Process process = Runtime.getRuntime().exec(this.getOpenUriArguments(uri));
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException var3) {
                LOGGER.error("Couldn't open location '{}'", (Object)uri, (Object)var3);
            }
        }

        public void openFile(File file) {
            this.openUri(file.toURI());
        }

        public void openPath(Path path) {
            this.openUri(path.toUri());
        }

        protected String[] getOpenUriArguments(URI uri) {
            String string = uri.toString();
            if ("file".equals(uri.getScheme())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void openUri(String uri) {
            try {
                this.openUri(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException var3) {
                LOGGER.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }
    }
}

