/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.StrictJsonParser;

public class LegacyComponentDataFixUtils {
    private static final String EMPTY_CONTENTS = LegacyComponentDataFixUtils.createTextComponentJson("");

    public static <T> Dynamic<T> createPlainTextComponent(DynamicOps<T> ops, String data) {
        String string = LegacyComponentDataFixUtils.createTextComponentJson(data);
        return new Dynamic<Object>(ops, ops.createString(string));
    }

    public static <T> Dynamic<T> createEmptyComponent(DynamicOps<T> ops) {
        return new Dynamic<Object>(ops, ops.createString(EMPTY_CONTENTS));
    }

    public static String createTextComponentJson(String json) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", json);
        return GsonHelper.toStableString((JsonElement)jsonObject);
    }

    public static String createTranslatableComponentJson(String json) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("translate", json);
        return GsonHelper.toStableString((JsonElement)jsonObject);
    }

    public static <T> Dynamic<T> createTranslatableComponent(DynamicOps<T> ops, String data) {
        String string = LegacyComponentDataFixUtils.createTranslatableComponentJson(data);
        return new Dynamic<Object>(ops, ops.createString(string));
    }

    public static String rewriteFromLenient(String data) {
        if (!data.isEmpty() && !data.equals("null")) {
            char c = data.charAt(0);
            char c1 = data.charAt(data.length() - 1);
            if (c == '\"' && c1 == '\"' || c == '{' && c1 == '}' || c == '[' && c1 == ']') {
                try {
                    JsonElement jsonElement = LenientJsonParser.parse(data);
                    if (jsonElement.isJsonPrimitive()) {
                        return LegacyComponentDataFixUtils.createTextComponentJson(jsonElement.getAsString());
                    }
                    return GsonHelper.toStableString(jsonElement);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            return LegacyComponentDataFixUtils.createTextComponentJson(data);
        }
        return EMPTY_CONTENTS;
    }

    public static boolean isStrictlyValidJson(Dynamic<?> dynamic) {
        return dynamic.asString().result().filter(data -> {
            try {
                StrictJsonParser.parse(data);
                return true;
            }
            catch (JsonParseException var2) {
                return false;
            }
        }).isPresent();
    }

    public static Optional<String> extractTranslationString(String data) {
        try {
            JsonObject asJsonObject;
            JsonElement jsonElement1;
            JsonElement jsonElement = LenientJsonParser.parse(data);
            if (jsonElement.isJsonObject() && (jsonElement1 = (asJsonObject = jsonElement.getAsJsonObject()).get("translate")) != null && jsonElement1.isJsonPrimitive()) {
                return Optional.of(jsonElement1.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

