/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class OptionsGraphicsModeSplitFix
extends DataFix {
    private final String newFieldName;
    private final String valueIfFast;
    private final String valueIfFancy;
    private final String valueIfFabulous;

    public OptionsGraphicsModeSplitFix(Schema outputSchema, String newFieldName, String valueIfFast, String valueIfFancy, String valueIfFabulous) {
        super(outputSchema, true);
        this.newFieldName = newFieldName;
        this.valueIfFast = valueIfFast;
        this.valueIfFancy = valueIfFancy;
        this.valueIfFabulous = valueIfFabulous;
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("graphicsMode split to " + this.newFieldName, this.getInputSchema().getType(References.OPTIONS), typed -> typed.update(DSL.remainderFinder(), dynamic -> (Dynamic)((Object)((Object)((Object)DataFixUtils.orElseGet((Optional)dynamic.get("graphicsMode").asString().map(string -> dynamic.set(this.newFieldName, dynamic.createString(this.getValue((String)string)))).result(), () -> dynamic.set(this.newFieldName, dynamic.createString(this.valueIfFancy))))))));
    }

    private String getValue(String valueId) {
        return switch (valueId) {
            case "2" -> this.valueIfFabulous;
            case "0" -> this.valueIfFast;
            default -> this.valueIfFancy;
        };
    }
}

