/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ThrownPotionSplitFix
extends EntityRenameFix {
    private final Supplier<ItemIdFinder> itemIdFinder = Suppliers.memoize(() -> {
        Type choiceType = this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:potion");
        Type<?> type = ExtraDataFixUtils.patchSubType(choiceType, this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY));
        OpticFinder opticFinder = type.findField("Item");
        OpticFinder opticFinder1 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        return new ItemIdFinder(opticFinder, (OpticFinder<Pair<String, String>>)opticFinder1);
    });

    public ThrownPotionSplitFix(Schema outputSchema) {
        super("ThrownPotionSplitFix", outputSchema, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String entityName, Typed<?> typed) {
        if (!entityName.equals("minecraft:potion")) {
            return Pair.of((Object)entityName, typed);
        }
        String itemId = this.itemIdFinder.get().getItemId(typed);
        return "minecraft:lingering_potion".equals(itemId) ? Pair.of((Object)"minecraft:lingering_potion", typed) : Pair.of((Object)"minecraft:splash_potion", typed);
    }

    record ItemIdFinder(OpticFinder<?> itemFinder, OpticFinder<Pair<String, String>> itemIdFinder) {
        public String getItemId(Typed<?> data) {
            return data.getOptionalTyped(this.itemFinder).flatMap(typed -> typed.getOptional(this.itemIdFinder)).map(Pair::getSecond).map(NamespacedSchema::ensureNamespaced).orElse("");
        }
    }
}

