/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.ItemStackTagFix;
import net.minecraft.util.datafix.fixes.References;

public class WrittenBookPagesStrictJsonFix
extends ItemStackTagFix {
    public WrittenBookPagesStrictJsonFix(Schema outputSchema) {
        super(outputSchema, "WrittenBookPagesStrictJsonFix", string -> string.equals("minecraft:written_book"));
    }

    @Override
    protected Typed<?> fixItemStackTag(Typed<?> data) {
        Type type = this.getInputSchema().getType(References.TEXT_COMPONENT);
        Type type1 = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder opticFinder = type1.findField("tag");
        OpticFinder opticFinder1 = opticFinder.type().findField("pages");
        OpticFinder opticFinder2 = DSL.typeFinder((Type)type);
        return data.updateTyped(opticFinder1, typed -> typed.update(opticFinder2, pair -> pair.mapSecond(LegacyComponentDataFixUtils::rewriteFromLenient)));
    }
}

