/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;

public interface Term<S> {
    public boolean parse(ParseState<S> var1, Scope var2, Control var3);

    public static <S, T> Term<S> marker(Atom<T> name, T value) {
        return new Marker(name, value);
    }

    @SafeVarargs
    public static <S> Term<S> sequence(Term<S> ... elements) {
        return new Sequence<S>(elements);
    }

    @SafeVarargs
    public static <S> Term<S> alternative(Term<S> ... elements) {
        return new Alternative<S>(elements);
    }

    public static <S> Term<S> optional(Term<S> term) {
        return new Maybe<S>(term);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> element, Atom<List<T>> listName) {
        return Term.repeated(element, listName, 0);
    }

    public static <S, T> Term<S> repeated(NamedRule<S, T> element, Atom<List<T>> listName, int minRepetitions) {
        return new Repeated<S, T>(element, listName, minRepetitions);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator) {
        return Term.repeatedWithTrailingSeparator(element, listName, separator, 0);
    }

    public static <S, T> Term<S> repeatedWithTrailingSeparator(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator, int minRepetitions) {
        return new RepeatedWithSeparator<S, T>(element, listName, separator, minRepetitions, true);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator) {
        return Term.repeatedWithoutTrailingSeparator(element, listName, separator, 0);
    }

    public static <S, T> Term<S> repeatedWithoutTrailingSeparator(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator, int minRepetitions) {
        return new RepeatedWithSeparator<S, T>(element, listName, separator, minRepetitions, false);
    }

    public static <S> Term<S> positiveLookahead(Term<S> term) {
        return new LookAhead<S>(term, true);
    }

    public static <S> Term<S> negativeLookahead(Term<S> term) {
        return new LookAhead<S>(term, false);
    }

    public static <S> Term<S> cut() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
                control.cut();
                return true;
            }

            public String toString() {
                return "\u2191";
            }
        };
    }

    public static <S> Term<S> empty() {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
                return true;
            }

            public String toString() {
                return "\u03b5";
            }
        };
    }

    public static <S> Term<S> fail(final Object reason) {
        return new Term<S>(){

            @Override
            public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
                parseState.errorCollector().store(parseState.mark(), reason);
                return false;
            }

            public String toString() {
                return "fail";
            }
        };
    }

    public record Marker<S, T>(Atom<T> name, T value) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            scope.put(this.name, this.value);
            return true;
        }
    }

    public record Sequence<S>(Term<S>[] elements) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            for (Term<S> term : this.elements) {
                if (term.parse(parseState, scope, control)) continue;
                parseState.restore(i);
                return false;
            }
            return true;
        }
    }

    public record Alternative<S>(Term<S>[] elements) implements Term<S>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            Control control1 = parseState.acquireControl();
            try {
                int i = parseState.mark();
                scope.splitFrame();
                for (Term<S> term : this.elements) {
                    if (term.parse(parseState, scope, control1)) {
                        scope.mergeFrame();
                        boolean bl = true;
                        return bl;
                    }
                    scope.clearFrameValues();
                    parseState.restore(i);
                    if (control1.hasCut()) break;
                }
                scope.popFrame();
                boolean bl = false;
                return bl;
            }
            finally {
                parseState.releaseControl();
            }
        }
    }

    public record Maybe<S>(Term<S> term) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            if (!this.term.parse(parseState, scope, control)) {
                parseState.restore(i);
            }
            return true;
        }
    }

    public record Repeated<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, int minRepetitions) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            ArrayList<T> list = new ArrayList<T>(this.minRepetitions);
            while (true) {
                int i1 = parseState.mark();
                T object = parseState.parse(this.element);
                if (object == null) {
                    parseState.restore(i1);
                    if (list.size() < this.minRepetitions) {
                        parseState.restore(i);
                        return false;
                    }
                    scope.put(this.listName, list);
                    return true;
                }
                list.add(object);
            }
        }
    }

    public record RepeatedWithSeparator<S, T>(NamedRule<S, T> element, Atom<List<T>> listName, Term<S> separator, int minRepetitions, boolean allowTrailingSeparator) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            ArrayList<T> list = new ArrayList<T>(this.minRepetitions);
            boolean flag = true;
            while (true) {
                int i1 = parseState.mark();
                if (!flag && !this.separator.parse(parseState, scope, control)) {
                    parseState.restore(i1);
                    break;
                }
                int i2 = parseState.mark();
                T object = parseState.parse(this.element);
                if (object == null) {
                    if (flag) {
                        parseState.restore(i2);
                        break;
                    }
                    if (!this.allowTrailingSeparator) {
                        parseState.restore(i);
                        return false;
                    }
                    parseState.restore(i2);
                    break;
                }
                list.add(object);
                flag = false;
            }
            if (list.size() < this.minRepetitions) {
                parseState.restore(i);
                return false;
            }
            scope.put(this.listName, list);
            return true;
        }
    }

    public record LookAhead<S>(Term<S> term, boolean positive) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> parseState, Scope scope, Control control) {
            int i = parseState.mark();
            boolean flag = this.term.parse(parseState.silent(), scope, control);
            parseState.restore(i);
            return this.positive == flag;
        }
    }
}

