/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public record FileIOStat(Duration duration, @Nullable String path, long bytes) {
    public static Summary summary(Duration duration, List<FileIOStat> stats) {
        long l = stats.stream().mapToLong(fileIoStat -> fileIoStat.bytes).sum();
        return new Summary(l, (double)l / (double)duration.getSeconds(), stats.size(), (double)stats.size() / (double)duration.getSeconds(), stats.stream().map(FileIOStat::duration).reduce(Duration.ZERO, Duration::plus), stats.stream().filter(fileIoStat -> fileIoStat.path != null).collect(Collectors.groupingBy(fileIoStat -> fileIoStat.path, Collectors.summingLong(fileIoStat -> fileIoStat.bytes))).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Long)entry.getValue()))).limit(10L).toList());
    }

    public record Summary(long totalBytes, double bytesPerSecond, long counts, double countsPerSecond, Duration timeSpentInIO, List<Pair<String, Long>> topTenContributorsByTotalBytes) {
    }
}

