/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.LegacyStructureDataHandler;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String NEW_DIRECTORY_PREFIX = "new_";
    static final Component STATUS_UPGRADING_POI = Component.translatable("optimizeWorld.stage.upgrading.poi");
    static final Component STATUS_FINISHED_POI = Component.translatable("optimizeWorld.stage.finished.poi");
    static final Component STATUS_UPGRADING_ENTITIES = Component.translatable("optimizeWorld.stage.upgrading.entities");
    static final Component STATUS_FINISHED_ENTITIES = Component.translatable("optimizeWorld.stage.finished.entities");
    static final Component STATUS_UPGRADING_CHUNKS = Component.translatable("optimizeWorld.stage.upgrading.chunks");
    static final Component STATUS_FINISHED_CHUNKS = Component.translatable("optimizeWorld.stage.finished.chunks");
    final Registry<LevelStem> dimensions;
    final Set<ResourceKey<Level>> levels;
    final boolean eraseCache;
    final boolean recreateRegionFiles;
    final LevelStorageSource.LevelStorageAccess levelStorage;
    private final Thread thread;
    final DataFixer dataFixer;
    volatile boolean running = true;
    private volatile boolean finished;
    volatile float progress;
    volatile int totalChunks;
    volatile int totalFiles;
    volatile int converted;
    volatile int skipped;
    final Reference2FloatMap<ResourceKey<Level>> progressMap = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile Component status = Component.translatable("optimizeWorld.stage.counting");
    static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final DimensionDataStorage overworldDataStorage;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess levelStorage, DataFixer dataFixer, WorldData worldData, RegistryAccess registryAccess, boolean eraseCache, boolean recreateRegionFiles) {
        this.dimensions = registryAccess.lookupOrThrow(Registries.LEVEL_STEM);
        this.levels = Stream.of(levelStorage.dimensionType).map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = eraseCache;
        this.dataFixer = dataFixer;
        this.levelStorage = levelStorage;
        this.overworldDataStorage = new DimensionDataStorage(this.levelStorage.getDimensionPath(Level.OVERWORLD).resolve("data"), dataFixer, registryAccess);
        this.recreateRegionFiles = recreateRegionFiles;
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((thread, throwable) -> {
            LOGGER.error("Error upgrading world", throwable);
            this.status = Component.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        long millis = Util.getMillis();
        LOGGER.info("Upgrading entities");
        new EntityUpgrader(this).upgrade();
        LOGGER.info("Upgrading POIs");
        new PoiUpgrader(this).upgrade();
        LOGGER.info("Upgrading blocks");
        new ChunkUpgrader().upgrade();
        this.overworldDataStorage.saveAndJoin();
        millis = Util.getMillis() - millis;
        LOGGER.info("World optimizaton finished after {} seconds", (Object)(millis / 1000L));
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<Level> level) {
        return this.progressMap.getFloat(level);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public Component getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.overworldDataStorage.close();
    }

    static Path resolveRecreateDirectory(Path path) {
        return path.resolveSibling(NEW_DIRECTORY_PREFIX + path.getFileName().toString());
    }

    class EntityUpgrader
    extends SimpleRegionStorageUpgrader {
        EntityUpgrader(WorldUpgrader this$0) {
            super(DataFixTypes.ENTITY_CHUNK, "entities", STATUS_UPGRADING_ENTITIES, STATUS_FINISHED_ENTITIES);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage regionStorage, CompoundTag chunkTag) {
            return regionStorage.upgradeChunkTag(chunkTag, -1);
        }
    }

    class PoiUpgrader
    extends SimpleRegionStorageUpgrader {
        PoiUpgrader(WorldUpgrader this$0) {
            super(DataFixTypes.POI_CHUNK, "poi", STATUS_UPGRADING_POI, STATUS_FINISHED_POI);
        }

        @Override
        protected CompoundTag upgradeTag(SimpleRegionStorage regionStorage, CompoundTag chunkTag) {
            return regionStorage.upgradeChunkTag(chunkTag, 1945);
        }
    }

    class ChunkUpgrader
    extends AbstractUpgrader {
        ChunkUpgrader() {
            super(DataFixTypes.CHUNK, "chunk", "region", STATUS_UPGRADING_CHUNKS, STATUS_FINISHED_CHUNKS);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage regionStorage, ChunkPos chunkPos, ResourceKey<Level> dimension) {
            CompoundTag compoundTag = regionStorage.read(chunkPos).join().orElse(null);
            if (compoundTag != null) {
                boolean flag;
                int dataVersion = NbtUtils.getDataVersion(compoundTag);
                ChunkGenerator chunkGenerator = WorldUpgrader.this.dimensions.getValueOrThrow(Registries.levelToLevelStem(dimension)).generator();
                CompoundTag compoundTag1 = regionStorage.upgradeChunkTag(compoundTag, -1, ChunkMap.getChunkDataFixContextTag(Registries.levelToLevelStem(dimension), chunkGenerator.getTypeNameForDataFixer()), null);
                ChunkPos chunkPos1 = new ChunkPos(compoundTag1.getIntOr("xPos", 0), compoundTag1.getIntOr("zPos", 0));
                if (!chunkPos1.equals(chunkPos)) {
                    LOGGER.warn("Chunk {} has invalid position {}", (Object)chunkPos, (Object)chunkPos1);
                }
                boolean bl = flag = dataVersion < SharedConstants.getCurrentVersion().dataVersion().version();
                if (WorldUpgrader.this.eraseCache) {
                    flag = flag || compoundTag1.contains("Heightmaps");
                    compoundTag1.remove("Heightmaps");
                    flag = flag || compoundTag1.contains("isLightOn");
                    compoundTag1.remove("isLightOn");
                    ListTag listOrEmpty = compoundTag1.getListOrEmpty("sections");
                    for (int i = 0; i < listOrEmpty.size(); ++i) {
                        Optional<CompoundTag> compound = listOrEmpty.getCompound(i);
                        if (compound.isEmpty()) continue;
                        CompoundTag compoundTag2 = compound.get();
                        flag = flag || compoundTag2.contains("BlockLight");
                        compoundTag2.remove("BlockLight");
                        flag = flag || compoundTag2.contains("SkyLight");
                        compoundTag2.remove("SkyLight");
                    }
                }
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = regionStorage.write(chunkPos, compoundTag1);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo regionStorageInfo, Path path) {
            Supplier<LegacyTagFixer> legacyTagFixer = LegacyStructureDataHandler.getLegacyTagFixer(regionStorageInfo.dimension(), () -> WorldUpgrader.this.overworldDataStorage, WorldUpgrader.this.dataFixer);
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(regionStorageInfo.withTypeSuffix("source"), path, regionStorageInfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true, DataFixTypes.CHUNK, legacyTagFixer) : new SimpleRegionStorage(regionStorageInfo, path, WorldUpgrader.this.dataFixer, true, DataFixTypes.CHUNK, legacyTagFixer);
        }
    }

    abstract class SimpleRegionStorageUpgrader
    extends AbstractUpgrader {
        SimpleRegionStorageUpgrader(DataFixTypes dataFixType, String type, Component upgradingStatus, Component finishedStatus) {
            super(dataFixType, type, type, upgradingStatus, finishedStatus);
        }

        @Override
        protected SimpleRegionStorage createStorage(RegionStorageInfo regionStorageInfo, Path path) {
            return WorldUpgrader.this.recreateRegionFiles ? new RecreatingSimpleRegionStorage(regionStorageInfo.withTypeSuffix("source"), path, regionStorageInfo.withTypeSuffix("target"), WorldUpgrader.resolveRecreateDirectory(path), WorldUpgrader.this.dataFixer, true, this.dataFixType, LegacyTagFixer.EMPTY) : new SimpleRegionStorage(regionStorageInfo, path, WorldUpgrader.this.dataFixer, true, this.dataFixType);
        }

        @Override
        protected boolean tryProcessOnePosition(SimpleRegionStorage regionStorage, ChunkPos chunkPos, ResourceKey<Level> dimension) {
            CompoundTag compoundTag = regionStorage.read(chunkPos).join().orElse(null);
            if (compoundTag != null) {
                boolean flag;
                int dataVersion = NbtUtils.getDataVersion(compoundTag);
                CompoundTag compoundTag1 = this.upgradeTag(regionStorage, compoundTag);
                boolean bl = flag = dataVersion < SharedConstants.getCurrentVersion().dataVersion().version();
                if (flag || WorldUpgrader.this.recreateRegionFiles) {
                    if (this.previousWriteFuture != null) {
                        this.previousWriteFuture.join();
                    }
                    this.previousWriteFuture = regionStorage.write(chunkPos, compoundTag1);
                    return true;
                }
            }
            return false;
        }

        protected abstract CompoundTag upgradeTag(SimpleRegionStorage var1, CompoundTag var2);
    }

    record FileToUpgrade(RegionFile file, List<ChunkPos> chunksToUpgrade) {
    }

    record DimensionToUpgrade(ResourceKey<Level> dimensionKey, SimpleRegionStorage storage, ListIterator<FileToUpgrade> files) {
    }

    abstract class AbstractUpgrader {
        private final Component upgradingStatus;
        private final Component finishedStatus;
        private final String type;
        private final String folderName;
        protected @Nullable CompletableFuture<Void> previousWriteFuture;
        protected final DataFixTypes dataFixType;

        AbstractUpgrader(DataFixTypes dataFixType, String type, String folderName, Component upgradingStatus, Component finishedStatus) {
            this.dataFixType = dataFixType;
            this.type = type;
            this.folderName = folderName;
            this.upgradingStatus = upgradingStatus;
            this.finishedStatus = finishedStatus;
        }

        public void upgrade() {
            WorldUpgrader.this.totalFiles = 0;
            WorldUpgrader.this.totalChunks = 0;
            WorldUpgrader.this.converted = 0;
            WorldUpgrader.this.skipped = 0;
            List<DimensionToUpgrade> dimensionsToUpgrade = this.getDimensionsToUpgrade();
            if (WorldUpgrader.this.totalChunks != 0) {
                float f = WorldUpgrader.this.totalFiles;
                WorldUpgrader.this.status = this.upgradingStatus;
                while (WorldUpgrader.this.running) {
                    boolean flag = false;
                    float f1 = 0.0f;
                    for (DimensionToUpgrade dimensionToUpgrade : dimensionsToUpgrade) {
                        ResourceKey<Level> resourceKey = dimensionToUpgrade.dimensionKey;
                        ListIterator<FileToUpgrade> listIterator = dimensionToUpgrade.files;
                        SimpleRegionStorage simpleRegionStorage = dimensionToUpgrade.storage;
                        if (listIterator.hasNext()) {
                            FileToUpgrade fileToUpgrade = listIterator.next();
                            boolean flag1 = true;
                            for (ChunkPos chunkPos : fileToUpgrade.chunksToUpgrade) {
                                flag1 = flag1 && this.processOnePosition(resourceKey, simpleRegionStorage, chunkPos);
                                flag = true;
                            }
                            if (WorldUpgrader.this.recreateRegionFiles) {
                                if (flag1) {
                                    this.onFileFinished(fileToUpgrade.file);
                                } else {
                                    LOGGER.error("Failed to convert region file {}", (Object)fileToUpgrade.file.getPath());
                                }
                            }
                        }
                        float f2 = (float)listIterator.nextIndex() / f;
                        WorldUpgrader.this.progressMap.put(resourceKey, f2);
                        f1 += f2;
                    }
                    WorldUpgrader.this.progress = f1;
                    if (flag) continue;
                    break;
                }
                WorldUpgrader.this.status = this.finishedStatus;
                for (DimensionToUpgrade dimensionToUpgrade1 : dimensionsToUpgrade) {
                    try {
                        dimensionToUpgrade1.storage.close();
                    }
                    catch (Exception var14) {
                        LOGGER.error("Error upgrading chunk", (Throwable)var14);
                    }
                }
            }
        }

        private List<DimensionToUpgrade> getDimensionsToUpgrade() {
            ArrayList list = Lists.newArrayList();
            for (ResourceKey<Level> resourceKey : WorldUpgrader.this.levels) {
                RegionStorageInfo regionStorageInfo = new RegionStorageInfo(WorldUpgrader.this.levelStorage.getLevelId(), resourceKey, this.type);
                Path path = WorldUpgrader.this.levelStorage.getDimensionPath(resourceKey).resolve(this.folderName);
                SimpleRegionStorage simpleRegionStorage = this.createStorage(regionStorageInfo, path);
                ListIterator<FileToUpgrade> filesToProcess = this.getFilesToProcess(regionStorageInfo, path);
                list.add(new DimensionToUpgrade(resourceKey, simpleRegionStorage, filesToProcess));
            }
            return list;
        }

        protected abstract SimpleRegionStorage createStorage(RegionStorageInfo var1, Path var2);

        private ListIterator<FileToUpgrade> getFilesToProcess(RegionStorageInfo regionStorageInfo, Path path) {
            List<FileToUpgrade> allChunkPositions = AbstractUpgrader.getAllChunkPositions(regionStorageInfo, path);
            WorldUpgrader.this.totalFiles += allChunkPositions.size();
            WorldUpgrader.this.totalChunks += allChunkPositions.stream().mapToInt(fileToUpgrade -> fileToUpgrade.chunksToUpgrade.size()).sum();
            return allChunkPositions.listIterator();
        }

        private static List<FileToUpgrade> getAllChunkPositions(RegionStorageInfo regionStorageInfo, Path path) {
            File[] files = path.toFile().listFiles((directory, filename) -> filename.endsWith(".mca"));
            if (files == null) {
                return List.of();
            }
            ArrayList list = Lists.newArrayList();
            for (File file : files) {
                Matcher matcher = REGEX.matcher(file.getName());
                if (!matcher.matches()) continue;
                int i = Integer.parseInt(matcher.group(1)) << 5;
                int i1 = Integer.parseInt(matcher.group(2)) << 5;
                ArrayList list1 = Lists.newArrayList();
                try (RegionFile regionFile = new RegionFile(regionStorageInfo, file.toPath(), path, true);){
                    for (int i2 = 0; i2 < 32; ++i2) {
                        for (int i3 = 0; i3 < 32; ++i3) {
                            ChunkPos chunkPos = new ChunkPos(i2 + i, i3 + i1);
                            if (!regionFile.doesChunkExist(chunkPos)) continue;
                            list1.add(chunkPos);
                        }
                    }
                    if (list1.isEmpty()) continue;
                    list.add(new FileToUpgrade(regionFile, list1));
                }
                catch (Throwable var18) {
                    LOGGER.error("Failed to read chunks from region file {}", (Object)file.toPath(), (Object)var18);
                }
            }
            return list;
        }

        private boolean processOnePosition(ResourceKey<Level> dimension, SimpleRegionStorage regionStorage, ChunkPos chunkPos) {
            boolean flag = false;
            try {
                flag = this.tryProcessOnePosition(regionStorage, chunkPos, dimension);
            }
            catch (CompletionException | ReportedException var7) {
                Throwable cause = var7.getCause();
                if (!(cause instanceof IOException)) {
                    throw var7;
                }
                LOGGER.error("Error upgrading chunk {}", (Object)chunkPos, (Object)cause);
            }
            if (flag) {
                ++WorldUpgrader.this.converted;
            } else {
                ++WorldUpgrader.this.skipped;
            }
            return flag;
        }

        protected abstract boolean tryProcessOnePosition(SimpleRegionStorage var1, ChunkPos var2, ResourceKey<Level> var3);

        private void onFileFinished(RegionFile regionFile) {
            if (WorldUpgrader.this.recreateRegionFiles) {
                if (this.previousWriteFuture != null) {
                    this.previousWriteFuture.join();
                }
                Path path = regionFile.getPath();
                Path parent = path.getParent();
                Path path1 = WorldUpgrader.resolveRecreateDirectory(parent).resolve(path.getFileName().toString());
                try {
                    if (path1.toFile().exists()) {
                        Files.delete(path);
                        Files.move(path1, path, new CopyOption[0]);
                    } else {
                        LOGGER.error("Failed to replace an old region file. New file {} does not exist.", (Object)path1);
                    }
                }
                catch (IOException var6) {
                    LOGGER.error("Failed to replace an old region file", (Throwable)var6);
                }
            }
        }
    }
}

