/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public interface RandomizableContainer
extends Container {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    public @Nullable ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    default public void setLootTable(@Nullable ResourceKey<LootTable> lootTable, long seed) {
        this.setLootTable(lootTable);
        this.setLootTableSeed(seed);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPos getBlockPos();

    public @Nullable Level getLevel();

    public static void setBlockEntityLootTable(BlockGetter level, RandomSource random, BlockPos pos, ResourceKey<LootTable> lootTable) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RandomizableContainer) {
            RandomizableContainer randomizableContainer = (RandomizableContainer)((Object)blockEntity);
            randomizableContainer.setLootTable(lootTable, random.nextLong());
        }
    }

    default public boolean tryLoadLootTable(ValueInput input) {
        ResourceKey resourceKey = input.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.setLootTable(resourceKey);
        if (this.lootableData() != null && resourceKey != null) {
            this.lootableData().loadNbt(input);
        }
        this.setLootTableSeed(input.getLongOr(LOOT_TABLE_SEED_TAG, 0L));
        return resourceKey != null && this.lootableData() == null;
    }

    default public boolean trySaveLootTable(ValueOutput output) {
        long lootTableSeed;
        ResourceKey<LootTable> lootTable = this.getLootTable();
        if (lootTable == null) {
            return false;
        }
        output.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, lootTable);
        if (this.lootableData() != null) {
            this.lootableData().saveNbt(output);
        }
        if ((lootTableSeed = this.getLootTableSeed()) != 0L) {
            output.putLong(LOOT_TABLE_SEED_TAG, lootTableSeed);
        }
        return this.lootableData() == null;
    }

    default public void unpackLootTable(@Nullable Player player) {
        this.unpackLootTable(player, false);
    }

    default public void unpackLootTable(@Nullable Player player, boolean forceClearLootTable) {
        Level level = this.getLevel();
        BlockPos blockPos = this.getBlockPos();
        ResourceKey<LootTable> lootTable = this.getLootTable();
        if (lootTable != null && level != null && level.getServer() != null) {
            if (this.lootableData() != null && !this.lootableData().shouldReplenish(this, PaperLootableInventoryData.CONTAINER, player)) {
                if (forceClearLootTable) {
                    this.setLootTable(null);
                }
            } else {
                LootTable lootTable1 = level.getServer().reloadableRegistries().getLootTable(lootTable);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)player, lootTable);
                }
                if (forceClearLootTable || this.lootableData() == null || this.lootableData().shouldClearLootTable(this, PaperLootableInventoryData.CONTAINER, player)) {
                    this.setLootTable(null);
                }
                LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(blockPos));
                if (player != null) {
                    builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, player);
                }
                lootTable1.fill(this, builder.create(LootContextParamSets.CHEST), this.getLootTableSeed());
            }
        }
    }

    @Contract(pure=true)
    default public @Nullable PaperLootableInventoryData lootableData() {
        return null;
    }

    default public PaperLootableInventory getLootableInventory() {
        CraftBlock block = CraftBlock.at(Objects.requireNonNull(this.getLevel(), "Cannot manage loot tables on block entities not in world"), this.getBlockPos());
        return (PaperLootableInventory)block.getState(false);
    }
}

