/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public interface LerpFunction<T> {
    public static LerpFunction<Float> ofFloat() {
        return Mth::lerp;
    }

    public static LerpFunction<Float> ofDegrees(float maxDelta) {
        return (delta, start, end) -> {
            float f = Mth.wrapDegrees(end.floatValue() - start.floatValue());
            return Float.valueOf(Math.abs(f) >= maxDelta ? end.floatValue() : start.floatValue() + delta * f);
        };
    }

    public static <T> LerpFunction<T> ofConstant() {
        return (delta, start, end) -> start;
    }

    public static <T> LerpFunction<T> ofStep(float threshold) {
        return (delta, start, end) -> delta >= threshold ? end : start;
    }

    public static LerpFunction<Integer> ofColor() {
        return ARGB::srgbLerp;
    }

    public T apply(float var1, T var2, T var3);
}

