/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import it.unimi.dsi.fastutil.objects.Reference2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMaps;
import java.util.Objects;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.LerpFunction;

public class SpatialAttributeInterpolator {
    private final Reference2DoubleArrayMap<EnvironmentAttributeMap> weightsBySource = new Reference2DoubleArrayMap();

    public void clear() {
        this.weightsBySource.clear();
    }

    public SpatialAttributeInterpolator accumulate(double weight, EnvironmentAttributeMap attributes) {
        this.weightsBySource.mergeDouble((Object)attributes, weight, Double::sum);
        return this;
    }

    public <Value> Value applyAttributeLayer(EnvironmentAttribute<Value> attribute, Value value) {
        if (this.weightsBySource.isEmpty()) {
            return value;
        }
        if (this.weightsBySource.size() == 1) {
            EnvironmentAttributeMap environmentAttributeMap = (EnvironmentAttributeMap)this.weightsBySource.keySet().iterator().next();
            return environmentAttributeMap.applyModifier(attribute, value);
        }
        LerpFunction<Value> lerpFunction = attribute.type().spatialLerp();
        Object object = null;
        double d = 0.0;
        for (Reference2DoubleMap.Entry entry : Reference2DoubleMaps.fastIterable(this.weightsBySource)) {
            EnvironmentAttributeMap environmentAttributeMap1 = (EnvironmentAttributeMap)entry.getKey();
            double doubleValue = entry.getDoubleValue();
            Value object1 = environmentAttributeMap1.applyModifier(attribute, value);
            d += doubleValue;
            if (object == null) {
                object = object1;
                continue;
            }
            float f = (float)(doubleValue / d);
            object = lerpFunction.apply(f, object, object1);
        }
        return Objects.requireNonNull(object);
    }
}

