/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.craftbukkit.event.CraftEventFactory;

class WeavingMobEffect
extends MobEffect {
    private final ToIntFunction<RandomSource> maxCobwebs;

    protected WeavingMobEffect(MobEffectCategory category, int color, ToIntFunction<RandomSource> maxCobwebs) {
        super(category, color, ParticleTypes.ITEM_COBWEB);
        this.maxCobwebs = maxCobwebs;
    }

    @Override
    public void onMobRemoved(ServerLevel level, LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED && (entity instanceof Player || level.getGameRules().get(GameRules.MOB_GRIEFING).booleanValue())) {
            this.spawnCobwebsRandomlyAround(level, entity.getRandom(), entity.blockPosition(), entity);
        }
    }

    private void spawnCobwebsRandomlyAround(ServerLevel level, RandomSource random, BlockPos pos, LivingEntity entity) {
        HashSet set = Sets.newHashSet();
        int i = this.maxCobwebs.applyAsInt(random);
        for (BlockPos blockPos : BlockPos.randomInCube(random, 15, pos, 1)) {
            BlockPos blockPos1 = blockPos.below();
            if (set.contains(blockPos) || !level.getBlockState(blockPos).canBeReplaced() || !level.getBlockState(blockPos1).isFaceSturdy(level, blockPos1, Direction.UP)) continue;
            set.add(blockPos.immutable());
            if (set.size() < i) continue;
            break;
        }
        for (BlockPos blockPosx : set) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(entity, blockPosx, Blocks.COBWEB.defaultBlockState())) continue;
            level.setBlock(blockPosx, Blocks.COBWEB.defaultBlockState(), 3);
            level.levelEvent(3018, blockPosx, 0);
        }
    }
}

