/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public final class EntityReference<StoredEntityType extends UniquelyIdentifyable> {
    private static final Codec<? extends EntityReference<?>> CODEC = UUIDUtil.CODEC.xmap(EntityReference::new, EntityReference::getUUID);
    private static final StreamCodec<ByteBuf, ? extends EntityReference<?>> STREAM_CODEC = UUIDUtil.STREAM_CODEC.map(EntityReference::new, EntityReference::getUUID);
    private Either<UUID, StoredEntityType> entity;

    public static <Type extends UniquelyIdentifyable> Codec<EntityReference<Type>> codec() {
        return CODEC;
    }

    public static <Type extends UniquelyIdentifyable> StreamCodec<ByteBuf, EntityReference<Type>> streamCodec() {
        return STREAM_CODEC;
    }

    private EntityReference(StoredEntityType entity) {
        this.entity = Either.right(entity);
    }

    private EntityReference(UUID uuid) {
        this.entity = Either.left(uuid);
    }

    public static <T extends UniquelyIdentifyable> @Nullable EntityReference<T> of(@Nullable T entity) {
        return entity != null ? new EntityReference<T>(entity) : null;
    }

    public static <T extends UniquelyIdentifyable> EntityReference<T> of(UUID uuid) {
        return new EntityReference(uuid);
    }

    public UUID getUUID() {
        return this.entity.map(uuid -> uuid, UniquelyIdentifyable::getUUID);
    }

    public @Nullable StoredEntityType getEntity(UUIDLookup<? extends UniquelyIdentifyable> uuidLookup, Class<StoredEntityType> entityClass) {
        StoredEntityType uniquelyIdentifyable1;
        Optional<UUID> optional1;
        Optional<StoredEntityType> optional = this.entity.right();
        if (optional.isPresent()) {
            UniquelyIdentifyable uniquelyIdentifyable = (UniquelyIdentifyable)optional.get();
            if (!uniquelyIdentifyable.isRemoved()) {
                return (StoredEntityType)uniquelyIdentifyable;
            }
            this.entity = Either.left(uniquelyIdentifyable.getUUID());
        }
        if ((optional1 = this.entity.left()).isPresent() && (uniquelyIdentifyable1 = this.resolve(uuidLookup.lookup(optional1.get()), entityClass)) != null && !uniquelyIdentifyable1.isRemoved()) {
            this.entity = Either.right(uniquelyIdentifyable1);
            return uniquelyIdentifyable1;
        }
        return null;
    }

    public @Nullable StoredEntityType getEntity(Level level, Class<StoredEntityType> entityClass) {
        return Player.class.isAssignableFrom(entityClass) ? this.getEntity(level::getPlayerInAnyDimension, entityClass) : this.getEntity(level::getEntityInAnyDimension, entityClass);
    }

    private @Nullable StoredEntityType resolve(@Nullable UniquelyIdentifyable entity, Class<StoredEntityType> entityClass) {
        return (StoredEntityType)(entity != null && entityClass.isAssignableFrom(entity.getClass()) ? (UniquelyIdentifyable)entityClass.cast(entity) : null);
    }

    public boolean matches(StoredEntityType entity) {
        return this.getUUID().equals(entity.getUUID());
    }

    public void store(ValueOutput output, String key) {
        output.store(key, UUIDUtil.CODEC, this.getUUID());
    }

    public static void store(@Nullable EntityReference<?> key, ValueOutput output, String uuid) {
        if (key != null) {
            key.store(output, uuid);
        }
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable StoredEntityType get(@Nullable EntityReference<StoredEntityType> reference, Level level, Class<StoredEntityType> entityClass) {
        return reference != null ? (StoredEntityType)reference.getEntity(level, entityClass) : null;
    }

    public static @Nullable Entity getEntity(@Nullable EntityReference<Entity> reference, Level level) {
        return EntityReference.get(reference, level, Entity.class);
    }

    public static @Nullable LivingEntity getLivingEntity(@Nullable EntityReference<LivingEntity> reference, Level level) {
        return EntityReference.get(reference, level, LivingEntity.class);
    }

    public static @Nullable Player getPlayer(@Nullable EntityReference<Player> reference, Level level) {
        return EntityReference.get(reference, level, Player.class);
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable EntityReference<StoredEntityType> read(ValueInput input, String key) {
        return input.read(key, EntityReference.codec()).orElse(null);
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable EntityReference<StoredEntityType> readWithOldOwnerConversion(ValueInput input, String key, Level level) {
        Optional<UUID> optional = input.read(key, UUIDUtil.CODEC);
        return optional.isPresent() ? EntityReference.of(optional.get()) : (EntityReference)input.getString(key).map(string -> OldUsersConverter.convertMobOwnerIfNecessary(level.getServer(), string)).map(EntityReference::new).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof EntityReference)) return false;
        EntityReference entityReference = (EntityReference)other;
        if (!this.getUUID().equals(entityReference.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public static <StoredEntityType extends UniquelyIdentifyable> @Nullable StoredEntityType getEntity(@Nullable EntityReference<StoredEntityType> ref, UUIDLookup<? extends UniquelyIdentifyable> uuidLookup, Class<StoredEntityType> entityClass) {
        return ref == null ? null : (StoredEntityType)ref.getEntity(uuidLookup, entityClass);
    }
}

