/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.jspecify.annotations.Nullable;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    public @Nullable LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity entity) {
        return this != entity && !(this.leashDistanceTo(entity) > this.leashSnapDistance()) && this.canBeLeashed();
    }

    default public double leashDistanceTo(Entity entity) {
        return entity.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int delayedLeashHolderId) {
        this.setLeashData(new LeashData(delayedLeashHolderId));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput input) {
        LeashData leashData = input.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && leashData == null) {
            this.removeLeash();
        }
        this.setLeashData(leashData);
    }

    default public void writeLeashData(ValueOutput output, @Nullable LeashData leashData) {
        if (leashData != null && leashData.leashHolder != null && leashData.leashHolder.pluginRemoved) {
            return;
        }
        output.storeNullable(LEASH_TAG, LeashData.CODEC, leashData);
    }

    private static <E extends Entity> void restoreLeashFromSave(E entity, LeashData leashData) {
        Level level;
        if (leashData.delayedLeashInfo != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<UUID> optional = leashData.delayedLeashInfo.left();
            Optional<BlockPos> optional1 = leashData.delayedLeashInfo.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.getEntity(optional.get());
                if (entity1 != null) {
                    Leashable.setLeashedTo(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.setLeashedTo(entity, LeashFenceKnotEntity.getOrCreateKnot(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.tickCount > 100) {
                entity.forceDrops = true;
                entity.spawnAtLocation(serverLevel, Items.LEAD);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E entity, boolean broadcastPacket, boolean dropItem) {
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData != null && leashData.leashHolder != null) {
            ((Leashable)((Object)entity)).setLeashData(null);
            ((Leashable)((Object)entity)).onLeashRemoved();
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.spawnAtLocation(serverLevel, Items.LEAD);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.getChunkSource().sendToTrackingPlayers(entity, new ClientboundSetEntityLinkPacket(entity, null));
                }
                leashData.leashHolder.notifyLeasheeRemoved((Leashable)((Object)entity));
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel level, E entity) {
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData != null && leashData.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(entity, leashData);
        }
        if (leashData != null && leashData.leashHolder != null) {
            Entity leashHolder;
            if (!entity.canInteractWithLevel() || !leashData.leashHolder.canInteractWithLevel()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.isAlive() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.getGameRules().get(GameRules.ENTITY_DROPS) != false && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).dropLeash();
                } else {
                    ((Leashable)((Object)entity)).removeLeash();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).getLeashHolder()) != null && leashHolder.level() == entity.level()) {
                double d = ((Leashable)((Object)entity)).leashDistanceTo(leashHolder);
                ((Leashable)((Object)entity)).whenLeashedTo(leashHolder);
                if (d > ((Leashable)((Object)entity)).leashSnapDistanceOrConfig()) {
                    ((Leashable)((Object)entity)).leashTooFarBehaviour();
                } else if (d > ((Leashable)((Object)entity)).leashElasticDistance() - (double)leashHolder.getBbWidth() - (double)entity.getBbWidth() && ((Leashable)((Object)entity)).checkElasticInteractions(leashHolder, leashData)) {
                    ((Leashable)((Object)entity)).onElasticLeashPull();
                } else {
                    ((Leashable)((Object)entity)).closeRangeLeashBehaviour(leashHolder);
                }
                entity.setYRot((float)((double)entity.getYRot() - leashData.angularMomentum));
                leashData.angularMomentum *= (double)Leashable.angularFriction(entity);
            }
        }
    }

    default public void onElasticLeashPull() {
        Entity entity = (Entity)((Object)this);
        entity.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistanceOrConfig() {
        Leashable leashable = this;
        if (!(leashable instanceof Entity)) {
            return this.leashSnapDistance();
        }
        Entity entity = (Entity)((Object)leashable);
        return entity.level().paperConfig().misc.maxLeashDistance.or(this.leashSnapDistance());
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E entity) {
        if (entity.onGround()) {
            return entity.level().getBlockState(entity.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.91f;
        }
        return entity.isInLiquid() ? 0.8f : 0.91f;
    }

    default public void whenLeashedTo(Entity entity) {
        entity.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            Entity leashHolder = this.getLeashHolder();
            Level level = leashHolder.level();
            dropLeash = event.isDropLeash();
            level.playSound(null, leashHolder.getX(), leashHolder.getY(), leashHolder.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (dropLeash) {
            this.dropLeash();
        } else {
            this.removeLeash();
        }
    }

    default public void closeRangeLeashBehaviour(Entity entity) {
    }

    default public boolean checkElasticInteractions(Entity entity, LeashData leashData) {
        boolean flag = entity.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> list = Leashable.computeElasticInteraction((Entity)((Object)this), entity, flag ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, flag ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (list.isEmpty()) {
            return false;
        }
        Wrench wrench = Wrench.accumulate(list).scale(flag ? 0.25 : 1.0);
        leashData.angularMomentum += 10.0 * wrench.torque();
        Vec3 vec3 = Leashable.getHolderMovement(entity).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement(wrench.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(vec3.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity holder) {
        Mob mob;
        return holder instanceof Mob && (mob = (Mob)holder).isNoAi() ? Vec3.ZERO : holder.getKnownMovement();
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E entity, Entity leashHolder, List<Vec3> entityAttachmentPoint, List<Vec3> leasherAttachmentPoint) {
        double d = ((Leashable)((Object)entity)).leashElasticDistance();
        Vec3 holderMovement = Leashable.getHolderMovement(entity);
        float f = entity.getYRot() * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(entity.getBbWidth(), entity.getBbHeight(), entity.getBbWidth());
        float f1 = leashHolder.getYRot() * ((float)Math.PI / 180);
        Vec3 vec31 = new Vec3(leashHolder.getBbWidth(), leashHolder.getBbHeight(), leashHolder.getBbWidth());
        ArrayList<Wrench> list = new ArrayList<Wrench>();
        for (int i = 0; i < entityAttachmentPoint.size(); ++i) {
            Vec3 vec32 = entityAttachmentPoint.get(i).multiply(vec3).yRot(-f);
            Vec3 vec33 = entity.position().add(vec32);
            Vec3 vec34 = leasherAttachmentPoint.get(i).multiply(vec31).yRot(-f1);
            Vec3 vec35 = leashHolder.position().add(vec34);
            Leashable.computeDampenedSpringInteraction(vec35, vec33, d, holderMovement, vec32).ifPresent(list::add);
        }
        return list;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 entityAttachmentPoint, Vec3 leasherAttachmentPoint, double elasticDistance, Vec3 knownMovement, Vec3 relativeAttachmentPoint) {
        boolean flag;
        double d = leasherAttachmentPoint.distanceTo(entityAttachmentPoint);
        if (d < elasticDistance) {
            return Optional.empty();
        }
        Vec3 vec3 = entityAttachmentPoint.subtract(leasherAttachmentPoint).normalize().scale(d - elasticDistance);
        double d1 = Wrench.torqueFromForce(relativeAttachmentPoint, vec3);
        boolean bl = flag = knownMovement.dot(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.scale(0.3f);
        }
        return Optional.of(new Wrench(vec3, d1));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadLeashOffsets(Entity entity, double zOffset, double z, double x, double y) {
        float bbWidth = entity.getBbWidth();
        double d = zOffset * (double)bbWidth;
        double d1 = z * (double)bbWidth;
        double d2 = x * (double)bbWidth;
        double d3 = y * (double)entity.getBbHeight();
        return new Vec3[]{new Vec3(-d2, d3, d1 + d), new Vec3(-d2, d3, -d1 + d), new Vec3(d2, d3, -d1 + d), new Vec3(d2, d3, d1 + d)};
    }

    default public Vec3 getLeashOffset(float partialTick) {
        return this.getLeashOffset();
    }

    default public Vec3 getLeashOffset() {
        Entity entity = (Entity)((Object)this);
        return new Vec3(0.0, entity.getEyeHeight(), entity.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity leashHolder, boolean broadcastPacket) {
        if (this != leashHolder) {
            Leashable.setLeashedTo((Entity)((Object)this), leashHolder, broadcastPacket);
        }
    }

    private static <E extends Entity> void setLeashedTo(E entity, Entity leashHolder, boolean broadcastPacket) {
        Level level;
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData == null) {
            leashData = new LeashData(leashHolder);
            ((Leashable)((Object)entity)).setLeashData(leashData);
        } else {
            Entity entity1 = leashData.leashHolder;
            leashData.setLeashHolder(leashHolder);
            if (entity1 != null && entity1 != leashHolder) {
                entity1.notifyLeasheeRemoved((Leashable)((Object)entity));
            }
        }
        if (broadcastPacket && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().sendToTrackingPlayers(entity, new ClientboundSetEntityLinkPacket(entity, leashHolder));
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
    }

    default public @Nullable Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    private static <E extends Entity> @Nullable Entity getLeashHolder(E entity) {
        Entity var3;
        LeashData leashData = ((Leashable)((Object)entity)).getLeashData();
        if (leashData == null) {
            return null;
        }
        if (leashData.delayedLeashHolderId != 0 && entity.level().isClientSide() && (var3 = entity.level().getEntity(leashData.delayedLeashHolderId)) instanceof Entity) {
            leashData.setLeashHolder(var3);
        }
        return leashData.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity entity) {
        return Leashable.leashableInArea(entity, leashable -> leashable.getLeashHolder() == entity);
    }

    public static List<Leashable> leashableInArea(Entity entity, Predicate<Leashable> predicate) {
        return Leashable.leashableInArea(entity.level(), entity.getBoundingBox().getCenter(), predicate);
    }

    public static List<Leashable> leashableInArea(Level level, Vec3 pos, Predicate<Leashable> predicate) {
        double d = 32.0;
        AABB aabb = AABB.ofSize(pos, 32.0, 32.0, 32.0);
        return level.getEntitiesOfClass(Entity.class, aabb, entity -> {
            Leashable leashable;
            return entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, leashData -> {
            Entity patt0$temp = leashData.leashHolder;
            if (patt0$temp instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity leashFenceKnotEntity = (LeashFenceKnotEntity)patt0$temp;
                return Either.right(leashFenceKnotEntity.getPos());
            }
            return leashData.leashHolder != null ? Either.left(leashData.leashHolder.getUUID()) : Objects.requireNonNull(leashData.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        public @Nullable Entity leashHolder;
        public @Nullable Either<UUID, BlockPos> delayedLeashInfo;
        public double angularMomentum;

        private LeashData(Either<UUID, BlockPos> delayedLeashInfo) {
            this.delayedLeashInfo = delayedLeashInfo;
        }

        LeashData(Entity leashHolder) {
            this.leashHolder = leashHolder;
        }

        LeashData(int delayedLeashHolderId) {
            this.delayedLeashHolderId = delayedLeashHolderId;
        }

        public void setLeashHolder(Entity leashHolder) {
            this.leashHolder = leashHolder;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 attachmentPoint, Vec3 force) {
            return attachmentPoint.z * force.x - attachmentPoint.x * force.z;
        }

        static Wrench accumulate(List<Wrench> wrenches) {
            if (wrenches.isEmpty()) {
                return ZERO;
            }
            double d = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Wrench wrench : wrenches) {
                Vec3 vec3 = wrench.force;
                d += vec3.x;
                d1 += vec3.y;
                d2 += vec3.z;
                d3 += wrench.torque;
            }
            return new Wrench(new Vec3(d, d1, d2), d3);
        }

        public Wrench scale(double scale) {
            return new Wrench(this.force.scale(scale), this.torque * scale);
        }
    }
}

