/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public interface NeutralMob {
    public static final String TAG_ANGER_END_TIME = "anger_end_time";
    public static final String TAG_ANGRY_AT = "angry_at";
    public static final long NO_ANGER_END_TIME = -1L;

    public long getPersistentAngerEndTime();

    default public void setTimeToRemainAngry(long time) {
        this.setPersistentAngerEndTime(this.level().getGameTime() + time);
    }

    public void setPersistentAngerEndTime(long var1);

    public @Nullable EntityReference<LivingEntity> getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable EntityReference<LivingEntity> var1);

    public void startPersistentAngerTimer();

    public Level level();

    default public void addPersistentAngerSaveData(ValueOutput output) {
        output.putLong(TAG_ANGER_END_TIME, this.getPersistentAngerEndTime());
        output.storeNullable(TAG_ANGRY_AT, EntityReference.codec(), this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(Level level, ValueInput input) {
        Optional<Long> _long = input.getLong(TAG_ANGER_END_TIME);
        if (_long.isPresent()) {
            this.setPersistentAngerEndTime(_long.get());
        } else {
            Optional<Integer> _int = input.getInt("AngerTime");
            if (_int.isPresent()) {
                this.setTimeToRemainAngry(_int.get().intValue());
            } else {
                this.setPersistentAngerEndTime(-1L);
            }
        }
        if (level instanceof ServerLevel) {
            this.setPersistentAngerTarget(EntityReference.read(input, TAG_ANGRY_AT));
            NeutralMob neutralMob = this;
            if (neutralMob instanceof Entity) {
                Entity entity = (Entity)((Object)neutralMob);
                if (!entity.firstTick) {
                    this.tickInitialPersistentAnger(level);
                }
            }
        }
    }

    default public void updatePersistentAnger(ServerLevel level, boolean updateAnger) {
        LivingEntity target = this.getTarget();
        EntityReference<LivingEntity> persistentAngerTarget = this.getPersistentAngerTarget();
        if (target != null && target.isDeadOrDying() && persistentAngerTarget != null && persistentAngerTarget.matches(target) && target instanceof Mob) {
            this.stopBeingAngry();
        } else {
            if (target != null) {
                if (persistentAngerTarget == null || !persistentAngerTarget.matches(target)) {
                    this.setPersistentAngerTarget(EntityReference.of(target));
                }
                this.startPersistentAngerTimer();
            }
            if (!(persistentAngerTarget == null || this.isAngry() || target != null && NeutralMob.isValidPlayerTarget(target) && updateAnger)) {
                this.stopBeingAngry();
            }
        }
    }

    private static boolean isValidPlayerTarget(LivingEntity target) {
        Player player;
        return target instanceof Player && !(player = (Player)target).isCreative() && !player.isSpectator();
    }

    default public boolean isAngryAt(LivingEntity entity, ServerLevel level) {
        if (!this.canAttack(entity)) {
            return false;
        }
        if (NeutralMob.isValidPlayerTarget(entity) && this.isAngryAtAllPlayers(level)) {
            return true;
        }
        EntityReference<LivingEntity> persistentAngerTarget = this.getPersistentAngerTarget();
        return persistentAngerTarget != null && persistentAngerTarget.matches(entity);
    }

    default public boolean isAngryAtAllPlayers(ServerLevel level) {
        return level.getGameRules().get(GameRules.UNIVERSAL_ANGER) != false && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        long persistentAngerEndTime = this.getPersistentAngerEndTime();
        if (persistentAngerEndTime > 0L) {
            long l = persistentAngerEndTime - this.level().getGameTime();
            return l > 0L;
        }
        return false;
    }

    default public void playerDied(ServerLevel level, Player player) {
        EntityReference<LivingEntity> persistentAngerTarget;
        if (level.getGameRules().get(GameRules.FORGIVE_DEAD_PLAYERS).booleanValue() && (persistentAngerTarget = this.getPersistentAngerTarget()) != null && persistentAngerTarget.matches(player)) {
            this.stopBeingAngry();
        }
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET);
        this.setPersistentAngerEndTime(-1L);
    }

    public @Nullable LivingEntity getLastHurtByMob();

    public void setLastHurtByMob(@Nullable LivingEntity var1);

    public void setTarget(@Nullable LivingEntity var1);

    public boolean setTarget(@Nullable LivingEntity var1, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTargetEvent.TargetReason var2);

    public boolean canAttack(LivingEntity var1);

    public @Nullable LivingEntity getTarget();

    default public void tickInitialPersistentAnger(Level level) {
        LivingEntity target = EntityReference.getLivingEntity(this.getPersistentAngerTarget(), level);
        if (target != null) {
            this.setTarget(target, null);
        }
    }
}

