/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public interface OwnableEntity {
    public @Nullable EntityReference<LivingEntity> getOwnerReference();

    public Level level();

    default public @Nullable LivingEntity getOwner() {
        return EntityReference.getLivingEntity(this.getOwnerReference(), this.level());
    }

    default public @Nullable LivingEntity getRootOwner() {
        ObjectArraySet set = new ObjectArraySet();
        LivingEntity owner = this.getOwner();
        set.add(this);
        while (owner instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)((Object)owner);
            LivingEntity owner1 = ownableEntity.getOwner();
            if (set.contains(owner1)) {
                return null;
            }
            set.add(owner);
            owner = ownableEntity.getOwner();
        }
        return owner;
    }
}

