/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.SpearAttack;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class SpearRetreat
extends Behavior<PathfinderMob> {
    public static final int MIN_COOLDOWN_DISTANCE = 9;
    public static final int MAX_COOLDOWN_DISTANCE = 11;
    public static final int MAX_FLEEING_TIME = 100;
    double speedModifierWhenRepositioning;

    public SpearRetreat(double speedModifierWhenRepositioning) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_PRESENT), 100);
        this.speedModifierWhenRepositioning = speedModifierWhenRepositioning;
    }

    private @Nullable LivingEntity getTarget(PathfinderMob mob) {
        return mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    private boolean ableToAttack(PathfinderMob mob) {
        return this.getTarget(mob) != null && mob.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, PathfinderMob owner) {
        if (this.ableToAttack(owner) && !owner.isUsingItem()) {
            double squareRoot;
            if (owner.getBrain().getMemory(MemoryModuleType.SPEAR_STATUS).orElse(SpearAttack.SpearStatus.APPROACH) != SpearAttack.SpearStatus.RETREAT) {
                return false;
            }
            LivingEntity target = this.getTarget(owner);
            double d = owner.distanceToSqr(target.getX(), target.getY(), target.getZ());
            int i = owner.isPassenger() ? 2 : 0;
            Vec3 posAway = LandRandomPos.getPosAway(owner, Math.max(0.0, (double)(9 + i) - (squareRoot = Math.sqrt(d))), Math.max(1.0, (double)(11 + i) - squareRoot), 7, target.position());
            if (posAway == null) {
                return false;
            }
            owner.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_POSITION, posAway);
            return true;
        }
        return false;
    }

    @Override
    protected void start(ServerLevel level, PathfinderMob entity, long gameTime) {
        entity.setAggressive(true);
        entity.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_TIME, 0);
        super.start(level, entity, gameTime);
    }

    @Override
    protected boolean canStillUse(ServerLevel level, PathfinderMob entity, long gameTime) {
        return entity.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_TIME).orElse(100) < 100 && entity.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_POSITION).isPresent() && !entity.getNavigation().isDone() && this.ableToAttack(entity);
    }

    @Override
    protected void tick(ServerLevel level, PathfinderMob owner, long gameTime) {
        float f;
        LivingEntity target = this.getTarget(owner);
        Entity entity = owner.getRootVehicle();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            f = mob.chargeSpeedModifier();
        } else {
            f = 1.0f;
        }
        float f2 = f;
        owner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(target, true));
        owner.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_TIME, owner.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_TIME).orElse(0) + 1);
        owner.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_POSITION).ifPresent(vec3 -> owner.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, (double)f2 * this.speedModifierWhenRepositioning));
    }

    @Override
    protected void stop(ServerLevel level, PathfinderMob entity, long gameTime) {
        entity.getNavigation().stop();
        entity.setAggressive(false);
        entity.stopUsingItem();
        entity.getBrain().eraseMemory(MemoryModuleType.SPEAR_FLEEING_TIME);
        entity.getBrain().eraseMemory(MemoryModuleType.SPEAR_FLEEING_POSITION);
        entity.getBrain().eraseMemory(MemoryModuleType.SPEAR_STATUS);
    }
}

