/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StartAttacking {
    public static <E extends Mob> BehaviorControl<E> create(TargetFinder<E> targetFinder) {
        return StartAttacking.create((level, mob) -> true, targetFinder);
    }

    public static <E extends Mob> BehaviorControl<E> create(StartAttackingCondition<E> condition, TargetFinder<E> targetFinder) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> instance) -> instance.group(instance.absent(MemoryModuleType.ATTACK_TARGET), instance.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)instance, (memoryAccessor, memoryAccessor1) -> (level, entity, gameTime) -> {
            if (!condition.test(level, entity)) {
                return false;
            }
            Optional<LivingEntity> optional = targetFinder.get(level, entity);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingEntity = optional.get();
            if (!entity.canAttack(livingEntity)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entity, livingEntity, livingEntity instanceof ServerPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryAccessor.erase();
                return true;
            }
            livingEntity = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryAccessor.set(livingEntity);
            memoryAccessor1.erase();
            return true;
        }));
    }

    @FunctionalInterface
    public static interface StartAttackingCondition<E> {
        public boolean test(ServerLevel var1, E var2);
    }

    @FunctionalInterface
    public static interface TargetFinder<E> {
        public Optional<? extends LivingEntity> get(ServerLevel var1, E var2);
    }
}

