/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class RemoveBlockGoal
extends MoveToBlockGoal {
    private final Block blockToRemove;
    private final Mob removerMob;
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public RemoveBlockGoal(Block blockToRemove, PathfinderMob removerMob, double speedModifier, int searchRange) {
        super(removerMob, speedModifier, 24, searchRange);
        this.blockToRemove = blockToRemove;
        this.removerMob = removerMob;
    }

    @Override
    public boolean canUse() {
        if (!RemoveBlockGoal.getServerLevel(this.removerMob).getGameRules().get(GameRules.MOB_GRIEFING).booleanValue()) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.findNearestBlock()) {
            this.nextStartTick = RemoveBlockGoal.reducedTickDelay(20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.removerMob.fallDistance = 1.0;
    }

    @Override
    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor level, BlockPos pos) {
    }

    public void playBreakSound(Level level, BlockPos pos) {
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.removerMob.level();
        BlockPos blockPos = this.removerMob.blockPosition();
        BlockPos posWithBlock = this.getPosWithBlock(blockPos, level);
        RandomSource random = this.removerMob.getRandom();
        if (this.isReachedTarget() && posWithBlock != null) {
            double d;
            Vec3 deltaMovement;
            if (this.ticksSinceReachedGoal > 0) {
                deltaMovement = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(deltaMovement.x, 0.3, deltaMovement.z);
                if (!level.isClientSide()) {
                    d = 0.08;
                    ((ServerLevel)level).sendParticles(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.EGG)), (double)posWithBlock.getX() + 0.5, (double)posWithBlock.getY() + 0.7, (double)posWithBlock.getZ() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, 0.15f);
                }
            }
            if (this.ticksSinceReachedGoal % 2 == 0) {
                deltaMovement = this.removerMob.getDeltaMovement();
                this.removerMob.setDeltaMovement(deltaMovement.x, -0.3, deltaMovement.z);
                if (this.ticksSinceReachedGoal % 6 == 0) {
                    this.playDestroyProgressSound(level, this.blockPos);
                }
            }
            if (this.ticksSinceReachedGoal > 60) {
                if (!CraftEventFactory.callEntityInteractEvent(this.removerMob, CraftBlock.at(level, posWithBlock))) {
                    return;
                }
                level.removeBlock(posWithBlock, false);
                if (!level.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        d = random.nextGaussian() * 0.02;
                        double d1 = random.nextGaussian() * 0.02;
                        double d2 = random.nextGaussian() * 0.02;
                        ((ServerLevel)level).sendParticles(ParticleTypes.POOF, (double)posWithBlock.getX() + 0.5, posWithBlock.getY(), (double)posWithBlock.getZ() + 0.5, 1, d, d1, d2, 0.15f);
                    }
                    this.playBreakSound(level, posWithBlock);
                }
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    private @Nullable BlockPos getPosWithBlock(BlockPos pos, BlockGetter level) {
        BlockPos[] blockPoss;
        BlockState block = level.getBlockStateIfLoaded(pos);
        if (block == null) {
            return null;
        }
        if (block.is(this.blockToRemove)) {
            return pos;
        }
        for (BlockPos blockPos : blockPoss = new BlockPos[]{pos.below(), pos.west(), pos.east(), pos.north(), pos.south(), pos.below().below()}) {
            BlockState block2 = level.getBlockStateIfLoaded(blockPos);
            if (block2 == null || !block2.is(this.blockToRemove)) continue;
            return blockPos;
        }
        return null;
    }

    @Override
    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        ChunkAccess chunk = level.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
        return chunk != null && chunk.getBlockState(pos).is(this.blockToRemove) && chunk.getBlockState(pos.above()).isAir() && chunk.getBlockState(pos.above(2)).isAir();
    }
}

