/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class CamelHusk
extends Camel {
    public CamelHusk(EntityType<? extends Camel> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof Mob;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        this.setPersistenceRequired();
        return super.interact(player, hand);
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isMobControlled();
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.CAMEL_HUSK_FOOD);
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.CAMEL_HUSK_AMBIENT;
    }

    @Override
    public boolean canMate(Animal partner) {
        return false;
    }

    @Override
    public @Nullable Camel getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.CAMEL_HUSK_DEATH;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CAMEL_HUSK_HURT;
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState block) {
        if (block.is(BlockTags.CAMEL_SAND_STEP_SOUND_BLOCKS)) {
            this.playSound(SoundEvents.CAMEL_HUSK_STEP_SAND, 0.4f, 1.0f);
        } else {
            this.playSound(SoundEvents.CAMEL_HUSK_STEP, 0.4f, 1.0f);
        }
    }

    @Override
    protected SoundEvent getDashingSound() {
        return SoundEvents.CAMEL_HUSK_DASH;
    }

    @Override
    protected SoundEvent getDashReadySound() {
        return SoundEvents.CAMEL_HUSK_DASH_READY;
    }

    @Override
    protected SoundEvent getEatingSound() {
        return SoundEvents.CAMEL_HUSK_EAT;
    }

    @Override
    protected SoundEvent getStandUpSound() {
        return SoundEvents.CAMEL_HUSK_STAND;
    }

    @Override
    protected SoundEvent getSitDownSound() {
        return SoundEvents.CAMEL_HUSK_SIT;
    }

    @Override
    protected Holder.Reference<SoundEvent> getSaddleSound() {
        return SoundEvents.CAMEL_HUSK_SADDLE;
    }

    @Override
    public float chargeSpeedModifier() {
        return 4.0f;
    }
}

