/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.wanderingtrader;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.equine.TraderLlama;
import net.minecraft.world.entity.npc.wanderingtrader.WanderingTrader;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;

public class WanderingTraderSpawner
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingTraderSpawner(ServerLevelData serverLevelData) {
        this.serverLevelData = serverLevelData;
        this.tickDelay = Integer.MIN_VALUE;
    }

    @Override
    public void tick(ServerLevel level, boolean spawnEnemies) {
        if (this.tickDelay == Integer.MIN_VALUE) {
            this.tickDelay = level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
            this.spawnDelay = level.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
            this.spawnChance = level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
        }
        if (level.getGameRules().get(GameRules.SPAWN_WANDERING_TRADERS).booleanValue()) {
            if (this.tickDelay - 1 <= 0) {
                this.tickDelay = level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
                this.spawnDelay -= level.paperConfig().entities.spawning.wanderingTrader.spawnMinuteLength;
                if (this.spawnDelay <= 0) {
                    this.spawnDelay = level.paperConfig().entities.spawning.wanderingTrader.spawnDayLength;
                    int i = this.spawnChance;
                    this.spawnChance = Mth.clamp(this.spawnChance + level.paperConfig().entities.spawning.wanderingTrader.spawnChanceFailureIncrement, level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin, level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMax);
                    if (this.random.nextInt(100) <= i && this.spawn(level)) {
                        this.spawnChance = level.paperConfig().entities.spawning.wanderingTrader.spawnChanceMin;
                    }
                }
            } else {
                --this.tickDelay;
            }
        }
    }

    private boolean spawn(ServerLevel level) {
        ServerPlayer randomPlayer = level.getRandomPlayer();
        if (randomPlayer == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPos blockPos = randomPlayer.blockPosition();
        int i = 48;
        PoiManager poiManager = level.getPoiManager();
        Optional<BlockPos> optional = poiManager.find(holder -> holder.is(PoiTypes.MEETING), blockPos3 -> true, blockPos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockPos1 = optional.orElse(blockPos);
        BlockPos blockPos2 = this.findSpawnPositionNear(level, blockPos1, 48);
        if (blockPos2 != null && this.hasEnoughSpace(level, blockPos2)) {
            if (level.getBiome(blockPos2).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            WanderingTrader wanderingTrader = EntityType.WANDERING_TRADER.spawn(level, trader -> trader.setDespawnDelay(48000), blockPos2, EntitySpawnReason.EVENT, false, false, CreatureSpawnEvent.SpawnReason.NATURAL);
            if (wanderingTrader != null) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    this.tryToSpawnLlamaFor(level, wanderingTrader, 4);
                }
                this.serverLevelData.setWanderingTraderId(wanderingTrader.getUUID());
                wanderingTrader.setWanderTarget(blockPos1);
                wanderingTrader.setHomeTo(blockPos1, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(ServerLevel level, WanderingTrader trader, int maxDistance) {
        TraderLlama traderLlama;
        BlockPos blockPos = this.findSpawnPositionNear(level, trader.blockPosition(), maxDistance);
        if (blockPos != null && (traderLlama = EntityType.TRADER_LLAMA.spawn(level, blockPos, EntitySpawnReason.EVENT, CreatureSpawnEvent.SpawnReason.NATURAL)) != null) {
            traderLlama.setLeashedTo(trader, true);
        }
    }

    private @Nullable BlockPos findSpawnPositionNear(LevelReader level, BlockPos pos, int maxDistance) {
        BlockPos blockPos = null;
        SpawnPlacementType placementType = SpawnPlacements.getPlacementType(EntityType.WANDERING_TRADER);
        for (int i = 0; i < 10; ++i) {
            int i2;
            int height;
            int i1 = pos.getX() + this.random.nextInt(maxDistance * 2) - maxDistance;
            BlockPos blockPos1 = new BlockPos(i1, height = level.getHeight(Heightmap.Types.WORLD_SURFACE, i1, i2 = pos.getZ() + this.random.nextInt(maxDistance * 2) - maxDistance), i2);
            if (!placementType.isSpawnPositionOk(level, blockPos1, EntityType.WANDERING_TRADER)) continue;
            blockPos = blockPos1;
            break;
        }
        return blockPos;
    }

    private boolean hasEnoughSpace(BlockGetter level, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.betweenClosed(pos, pos.offset(1, 2, 1))) {
            if (level.getBlockState(blockPos).getCollisionShape(level, blockPos).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

