/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.vehicle.minecart.MinecartCommandBlock;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public abstract class Player
extends Avatar
implements ContainerUser {
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    private static final int CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 40;
    private static final EntityDataAccessor<Float> DATA_PLAYER_ABSORPTION_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_SCORE_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<OptionalInt> DATA_SHOULDER_PARROT_LEFT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<OptionalInt> DATA_SHOULDER_PARROT_RIGHT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final short DEFAULT_SLEEP_TIMER = 0;
    private static final float DEFAULT_EXPERIENCE_PROGRESS = 0.0f;
    private static final int DEFAULT_EXPERIENCE_LEVEL = 0;
    private static final int DEFAULT_TOTAL_EXPERIENCE = 0;
    private static final int NO_ENCHANTMENT_SEED = 0;
    private static final int DEFAULT_SELECTED_SLOT = 0;
    private static final int DEFAULT_SCORE = 0;
    private static final boolean DEFAULT_IGNORE_FALL_DAMAGE_FROM_CURRENT_IMPULSE = false;
    private static final int DEFAULT_CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME = 0;
    public static final float CREATIVE_ENTITY_INTERACTION_RANGE_MODIFIER_VALUE = 2.0f;
    final Inventory inventory;
    protected PlayerEnderChestContainer enderChestInventory = new PlayerEnderChestContainer(this);
    public final InventoryMenu inventoryMenu;
    public AbstractContainerMenu containerMenu;
    protected FoodData foodData = new FoodData();
    protected int jumpTriggerTime;
    public int takeXpDelay;
    public int sleepCounter = 0;
    protected boolean wasUnderwater;
    private final Abilities abilities = new Abilities();
    public int experienceLevel = 0;
    public int totalExperience = 0;
    public float experienceProgress = 0.0f;
    public int enchantmentSeed = 0;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    public GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private net.minecraft.world.item.ItemStack lastItemInMainHand = net.minecraft.world.item.ItemStack.EMPTY;
    private final ItemCooldowns cooldowns = this.createItemCooldowns();
    private Optional<GlobalPos> lastDeathLocation = Optional.empty();
    public @Nullable FishingHook fishing;
    public float hurtDir;
    public @Nullable Vec3 currentImpulseImpactPos;
    public @Nullable Entity currentExplosionCause;
    private boolean ignoreFallDamageFromCurrentImpulse = false;
    private int currentImpulseContextResetGraceTime = 0;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public Player(Level level, GameProfile gameProfile) {
        super((EntityType<? extends LivingEntity>)EntityType.PLAYER, level);
        this.setUUID(gameProfile.id());
        this.gameProfile = gameProfile;
        this.inventory = new Inventory(this, this.equipment);
        this.inventoryMenu = new InventoryMenu(this.inventory, !level.isClientSide(), this);
        this.containerMenu = this.inventoryMenu;
    }

    @Override
    protected EntityEquipment createEquipment() {
        return new PlayerEquipment(this);
    }

    public boolean blockActionRestricted(Level level, BlockPos pos, GameType gameMode) {
        if (!gameMode.isBlockPlacingRestricted()) {
            return false;
        }
        if (gameMode == GameType.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        net.minecraft.world.item.ItemStack mainHandItem = this.getMainHandItem();
        return mainHandItem.isEmpty() || !mainHandItem.canBreakBlockInAdventureMode(new BlockInWorld(level, pos, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1f).add(Attributes.ATTACK_SPEED).add(Attributes.LUCK).add(Attributes.BLOCK_INTERACTION_RANGE, 4.5).add(Attributes.ENTITY_INTERACTION_RANGE, 3.0).add(Attributes.BLOCK_BREAK_SPEED).add(Attributes.SUBMERGED_MINING_SPEED).add(Attributes.SNEAKING_SPEED).add(Attributes.MINING_EFFICIENCY).add(Attributes.SWEEPING_DAMAGE_RATIO).add(Attributes.WAYPOINT_TRANSMIT_RANGE, 6.0E7).add(Attributes.WAYPOINT_RECEIVE_RANGE, 6.0E7);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        builder.define(DATA_SCORE_ID, 0);
        builder.define(DATA_SHOULDER_PARROT_LEFT, OptionalInt.empty());
        builder.define(DATA_SHOULDER_PARROT_RIGHT, OptionalInt.empty());
    }

    @Override
    public void tick() {
        this.noPhysics = this.isSpectator();
        if (this.isSpectator() || this.isPassenger()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter == 100 && !new PlayerDeepSleepEvent((org.bukkit.entity.Player)this.getBukkitEntity()).callEvent()) {
                this.sleepCounter = Integer.MIN_VALUE;
            }
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide() && !this.level().environmentAttributes().getValue(EnvironmentAttributes.BED_RULE, this.position()).canSleep(this.level())) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        int i = 29999999;
        double d = Mth.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double d1 = Mth.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if (d != this.getX() || d1 != this.getZ()) {
            this.setPos(d, this.getY(), d1);
        }
        ++this.attackStrengthTicker;
        ++this.itemSwapTicker;
        net.minecraft.world.item.ItemStack mainHandItem = this.getMainHandItem();
        if (!net.minecraft.world.item.ItemStack.matches(this.lastItemInMainHand, mainHandItem)) {
            if (!net.minecraft.world.item.ItemStack.isSameItem(this.lastItemInMainHand, mainHandItem)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = mainHandItem.copy();
        }
        if (!this.isEyeInFluid(FluidTags.WATER) && this.isEquipped(Items.TURTLE_HELMET)) {
            this.turtleHelmetTick();
        }
        this.cooldowns.tick();
        this.updatePlayerPose();
        if (this.currentImpulseContextResetGraceTime > 0) {
            --this.currentImpulseContextResetGraceTime;
        }
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        return this.isBlocking() ? 15.0f : super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(FluidTags.WATER);
        return this.wasUnderwater;
    }

    @Override
    public void onAboveBubbleColumn(boolean downwards, BlockPos pos) {
        if (!this.getAbilities().flying) {
            super.onAboveBubbleColumn(downwards, pos);
        }
    }

    @Override
    public void onInsideBubbleColumn(boolean downwards) {
        if (!this.getAbilities().flying) {
            super.onInsideBubbleColumn(downwards);
        }
    }

    private void turtleHelmetTick() {
        this.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
    }

    private boolean isEquipped(Item item) {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            net.minecraft.world.item.ItemStack itemBySlot = this.getItemBySlot(equipmentSlot);
            Equippable equippable = itemBySlot.get(DataComponents.EQUIPPABLE);
            if (!itemBySlot.is(item) || equippable == null || equippable.slot() != equipmentSlot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldowns createItemCooldowns() {
        return new ItemCooldowns();
    }

    protected void updatePlayerPose() {
        if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            Pose desiredPose = this.getDesiredPose();
            Pose pose = this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(desiredPose) ? desiredPose : (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
            this.setPose(pose);
        }
    }

    private Pose getDesiredPose() {
        if (this.isSleeping()) {
            return Pose.SLEEPING;
        }
        if (this.isSwimming()) {
            return Pose.SWIMMING;
        }
        if (this.isFallFlying()) {
            return Pose.FALL_FLYING;
        }
        if (this.isAutoSpinAttack()) {
            return Pose.SPIN_ATTACK;
        }
        return this.isShiftKeyDown() && !this.abilities.flying ? Pose.CROUCHING : Pose.STANDING;
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose pose) {
        return this.level().noCollision(this, this.getDimensions(pose).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    public SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    @Override
    public SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    @Override
    public SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent sound, float volume, float pitch) {
        this.level().playSound((Entity)this, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    @Override
    public int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte id) {
        if (id == 9) {
            this.completeUsingItem();
        } else if (id == 23) {
            this.setReducedDebugInfo(false);
        } else if (id == 22) {
            this.setReducedDebugInfo(true);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.closeContainer();
        this.containerMenu = this.inventoryMenu;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.containerMenu = this.inventoryMenu;
    }

    public void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide() && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            if (!this.isPassenger()) {
                this.setShiftKeyDown(false);
                return;
            }
        }
        super.rideTick();
    }

    @Override
    public void aiStep() {
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        this.tickRegeneration();
        this.inventory.tick();
        if (this.abilities.flying && !this.isPassenger()) {
            this.resetFallDistance();
        }
        super.aiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AABB aabb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List<Entity> entities = this.level().getEntities(this, aabb);
            ArrayList list = Lists.newArrayList();
            for (Entity entity : entities) {
                if (entity.getType() == EntityType.EXPERIENCE_ORB) {
                    list.add(entity);
                    continue;
                }
                if (entity.isRemoved()) continue;
                this.touch(entity);
            }
            if (!list.isEmpty()) {
                this.touch((Entity)Util.getRandom(list, this.random));
            }
        }
        this.handleShoulderEntities();
    }

    protected void tickRegeneration() {
    }

    public void handleShoulderEntities() {
    }

    public void removeEntitiesOnShoulder() {
    }

    private void touch(Entity entity) {
        entity.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int score) {
        this.entityData.set(DATA_SCORE_ID, score);
    }

    public void increaseScore(int score) {
        int score1 = this.getScore();
        this.entityData.set(DATA_SCORE_ID, score1 + score);
    }

    public void startAutoSpinAttack(int ticks, float damageAmount, net.minecraft.world.item.ItemStack stack) {
        this.autoSpinAttackTicks = ticks;
        this.autoSpinAttackDmg = damageAmount;
        this.autoSpinAttackItemStack = stack;
        if (!this.level().isClientSide()) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    public net.minecraft.world.item.ItemStack getWeaponItem() {
        return this.isAutoSpinAttack() && this.autoSpinAttackItemStack != null ? this.autoSpinAttackItemStack : super.getWeaponItem();
    }

    @Override
    public void die(DamageSource damageSource) {
        Level level;
        super.die(damageSource);
        this.reapplyPosition();
        if (!this.isSpectator() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropAllDeathLoot(serverLevel, damageSource);
        }
        if (damageSource != null) {
            this.setDeltaMovement(-Mth.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -Mth.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment(ServerLevel level) {
        super.dropEquipment(level);
        if (!level.getGameRules().get(GameRules.KEEP_INVENTORY).booleanValue()) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack item = this.inventory.getItem(i);
            if (item.isEmpty() || !EnchantmentHelper.has(item, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(i);
        }
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return damageSource.type().effects().sound();
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public void handleCreativeModeItemDrop(net.minecraft.world.item.ItemStack stack) {
    }

    public @Nullable ItemEntity drop(net.minecraft.world.item.ItemStack stack, boolean includeThrowerName) {
        return this.drop(stack, false, includeThrowerName);
    }

    public float getDestroySpeed(BlockState state) {
        float destroySpeed = this.inventory.getSelectedItem().getDestroySpeed(state);
        if (destroySpeed > 1.0f) {
            destroySpeed += (float)this.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            destroySpeed *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.MINING_FATIGUE)) {
            float f = switch (this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            destroySpeed *= f;
        }
        destroySpeed *= (float)this.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(FluidTags.WATER)) {
            destroySpeed *= (float)this.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            destroySpeed /= 5.0f;
        }
        return destroySpeed;
    }

    public boolean hasCorrectToolForDrops(BlockState state) {
        return !state.requiresCorrectToolForDrops() || this.inventory.getSelectedItem().isCorrectToolForDrops(state);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setUUID(this.gameProfile.id());
        this.inventory.load(input.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
        this.inventory.setSelectedSlot(input.getIntOr("SelectedItemSlot", 0));
        this.sleepCounter = input.getShortOr("SleepTimer", (short)0);
        this.experienceProgress = input.getFloatOr("XpP", 0.0f);
        this.experienceLevel = input.getIntOr("XpLevel", 0);
        this.totalExperience = input.getIntOr("XpTotal", 0);
        this.enchantmentSeed = input.getIntOr("XpSeed", 0);
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(input.getIntOr("Score", 0));
        this.foodData.readAdditionalSaveData(input);
        input.read("abilities", Abilities.Packed.CODEC).ifPresent(this.abilities::apply);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        this.enderChestInventory.fromSlots(input.listOrEmpty("EnderItems", ItemStackWithSlot.CODEC));
        this.setLastDeathLocation(input.read("LastDeathLocation", GlobalPos.CODEC));
        this.currentImpulseImpactPos = input.read("current_explosion_impact_pos", Vec3.CODEC).orElse(null);
        this.ignoreFallDamageFromCurrentImpulse = input.getBooleanOr("ignore_fall_damage_from_current_explosion", false);
        this.currentImpulseContextResetGraceTime = input.getIntOr("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        NbtUtils.addCurrentDataVersion(output);
        this.inventory.save(output.list("Inventory", ItemStackWithSlot.CODEC));
        output.putInt("SelectedItemSlot", this.inventory.getSelectedSlot());
        output.putShort("SleepTimer", (short)this.sleepCounter);
        output.putFloat("XpP", this.experienceProgress);
        output.putInt("XpLevel", this.experienceLevel);
        output.putInt("XpTotal", this.totalExperience);
        output.putInt("XpSeed", this.enchantmentSeed);
        output.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(output);
        output.store("abilities", Abilities.Packed.CODEC, this.abilities.pack());
        this.enderChestInventory.storeAsSlots(output.list("EnderItems", ItemStackWithSlot.CODEC));
        this.lastDeathLocation.ifPresent(globalPos -> output.store("LastDeathLocation", GlobalPos.CODEC, globalPos));
        output.storeNullable("current_explosion_impact_pos", Vec3.CODEC, this.currentImpulseImpactPos);
        output.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
        output.putInt("current_impulse_context_reset_grace_time", this.currentImpulseContextResetGraceTime);
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel level, DamageSource damageSource) {
        if (super.isInvulnerableTo(level, damageSource)) {
            return true;
        }
        if (damageSource.is(DamageTypeTags.IS_DROWNING)) {
            return level.getGameRules().get(GameRules.DROWNING_DAMAGE) == false;
        }
        if (damageSource.is(DamageTypeTags.IS_FALL)) {
            return level.getGameRules().get(GameRules.FALL_DAMAGE) == false;
        }
        return damageSource.is(DamageTypeTags.IS_FIRE) ? !level.getGameRules().get(GameRules.FIRE_DAMAGE).booleanValue() : damageSource.is(DamageTypeTags.IS_FREEZING) && level.getGameRules().get(GameRules.FREEZE_DAMAGE) == false;
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        boolean damaged;
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        if (this.abilities.invulnerable && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        if (damageSource.scalesWithDifficulty()) {
            if (level.getDifficulty() == Difficulty.PEACEFUL) {
                return false;
            }
            if (level.getDifficulty() == Difficulty.EASY) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (level.getDifficulty() == Difficulty.HARD) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.hurtServer(level, damageSource, amount)) {
            this.removeEntitiesOnShoulder();
        }
        return damaged;
    }

    @Override
    protected void blockUsingItem(ServerLevel level, LivingEntity entity) {
        super.blockUsingItem(level, entity);
        net.minecraft.world.item.ItemStack itemBlockingWith = this.getItemBlockingWith();
        BlocksAttacks blocksAttacks = itemBlockingWith != null ? itemBlockingWith.get(DataComponents.BLOCKS_ATTACKS) : null;
        float secondsToDisableBlocking = entity.getSecondsToDisableBlocking();
        if (secondsToDisableBlocking > 0.0f && blocksAttacks != null) {
            blocksAttacks.disable(level, this, secondsToDisableBlocking, itemBlockingWith, entity);
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(Player other) {
        Team team;
        if (other instanceof ServerPlayer) {
            ServerPlayer thatPlayer = (ServerPlayer)other;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = other.level().getCraftServer().getOfflinePlayer(other.getScoreboardName());
            team = other.level().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof ServerPlayer) {
            return !team.hasPlayer((OfflinePlayer)((ServerPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.level().getCraftServer().getOfflinePlayer(this.getScoreboardName()));
    }

    @Override
    protected void hurtArmor(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource damageSource, float damageAmount) {
        this.doHurtEquipment(damageSource, damageAmount, EquipmentSlot.HEAD);
    }

    @Override
    protected boolean actuallyHurt(ServerLevel level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        return super.actuallyHurt(level, damageSource, amount, event);
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(SignBlockEntity signEntity, boolean isFrontText) {
    }

    public void openMinecartCommandBlock(MinecartCommandBlock minecart) {
    }

    public void openCommandBlock(CommandBlockEntity commandBlockEntity) {
    }

    public void openStructureBlock(StructureBlockEntity structureEntity) {
    }

    public void openTestBlock(TestBlockEntity testBlockEntity) {
    }

    public void openTestInstanceBlock(TestInstanceBlockEntity testInstanceBlockEntity) {
    }

    public void openJigsawBlock(JigsawBlockEntity jigsawBlockEntity) {
    }

    public void openHorseInventory(AbstractHorse horse, Container inventory) {
    }

    public void openNautilusInventory(AbstractNautilus nautilus, Container inventory) {
    }

    public OptionalInt openMenu(@Nullable MenuProvider menu) {
        return OptionalInt.empty();
    }

    public void openDialog(Holder<Dialog> dialog) {
    }

    public void sendMerchantOffers(int containerId, MerchantOffers offers, int villagerLevel, int villagerXp, boolean showProgress, boolean canRestock) {
    }

    public void openItemGui(net.minecraft.world.item.ItemStack stack, InteractionHand hand) {
    }

    public InteractionResult interactOn(Entity entityToInteractOn, InteractionHand hand) {
        if (this.isSpectator()) {
            if (entityToInteractOn instanceof MenuProvider) {
                this.openMenu((MenuProvider)((Object)entityToInteractOn));
            }
            return InteractionResult.PASS;
        }
        net.minecraft.world.item.ItemStack itemInHand = this.getItemInHand(hand);
        net.minecraft.world.item.ItemStack itemStack = itemInHand.copy();
        InteractionResult interactionResult = entityToInteractOn.interact(this, hand);
        if (interactionResult.consumesAction()) {
            if (this.hasInfiniteMaterials() && itemInHand == this.getItemInHand(hand) && itemInHand.getCount() < itemStack.getCount()) {
                itemInHand.setCount(itemStack.getCount());
            }
            return interactionResult;
        }
        if (!itemInHand.isEmpty() && entityToInteractOn instanceof LivingEntity) {
            InteractionResult interactionResult1;
            if (this.hasInfiniteMaterials()) {
                itemInHand = itemStack;
            }
            if ((interactionResult1 = itemInHand.interactLivingEntity(this, (LivingEntity)entityToInteractOn, hand)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, entityToInteractOn.position(), GameEvent.Context.of(this));
                if (itemInHand.isEmpty() && !this.hasInfiniteMaterials()) {
                    this.setItemInHand(hand, net.minecraft.world.item.ItemStack.EMPTY);
                }
                return interactionResult1;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void removeVehicle(boolean suppressCancellation) {
        super.removeVehicle(suppressCancellation);
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping() || this.isRemoved() || !this.valid;
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3 maybeBackOffFromEdge(Vec3 movement, MoverType type) {
        float f = this.maxUpStep();
        if (!this.abilities.flying && !(movement.y > 0.0) && (type == MoverType.SELF || type == MoverType.PLAYER) && this.isStayingOnGroundSurface() && this.isAboveGround(f)) {
            double d;
            double d1 = movement.z;
            double d2 = 0.05;
            double d3 = Math.signum(d) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d = movement.x; d != 0.0 && this.canFallAtLeast(d, 0.0, f); d -= d3) {
                if (!(Math.abs(d) <= 0.05)) continue;
                d = 0.0;
                break;
            }
            while (d1 != 0.0 && this.canFallAtLeast(0.0, d1, f)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d != 0.0 && d1 != 0.0 && this.canFallAtLeast(d, d1, f)) {
                d = Math.abs(d) <= 0.05 ? 0.0 : (d -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3(d, movement.y, d1);
        }
        return movement;
    }

    private boolean isAboveGround(float maxUpStep) {
        return this.onGround() || this.fallDistance < (double)maxUpStep && !this.canFallAtLeast(0.0, 0.0, (double)maxUpStep - this.fallDistance);
    }

    private boolean canFallAtLeast(double x, double z, double distance) {
        AABB boundingBox = this.getBoundingBox();
        return this.level().noCollision(this, new AABB(boundingBox.minX + 1.0E-7 + x, boundingBox.minY - distance - 1.0E-7, boundingBox.minZ + 1.0E-7 + z, boundingBox.maxX - 1.0E-7 + x, boundingBox.minY, boundingBox.maxZ - 1.0E-7 + z));
    }

    public void attack(Entity target) {
        boolean willAttack = !this.cannotAttack(target);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            DamageSource damageSource;
            float f = this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
            net.minecraft.world.item.ItemStack weaponItem = this.getWeaponItem();
            DamageSource dmgSourceFinal = damageSource = this.createAttackSource(weaponItem);
            float attackStrengthScale = this.getAttackStrengthScale(0.5f);
            float f1 = attackStrengthScale * (this.getEnchantedDamage(target, f, damageSource) - f);
            f *= this.baseDamageScaleFactor();
            this.onAttack();
            float dmgFinal = f1;
            if (!this.deflectProjectile(target, () -> !CraftEventFactory.handleNonLivingEntityDamageEvent(target, dmgSourceFinal, dmgFinal, false))) {
                if (f > 0.0f || f1 > 0.0f) {
                    boolean flag1;
                    boolean flag;
                    boolean bl = flag = attackStrengthScale > 0.9f;
                    if (this.isSprinting() && flag) {
                        this.playServerSideSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK);
                        flag1 = true;
                    } else {
                        flag1 = false;
                    }
                    f += weaponItem.getItem().getAttackDamageBonus(target, f, damageSource);
                    boolean flag2 = flag && this.canCriticalAttack(target);
                    boolean bl2 = flag2 = flag2 && !this.level().paperConfig().entities.behavior.disablePlayerCrits;
                    if (flag2) {
                        damageSource = damageSource.critical();
                        f *= 1.5f;
                    }
                    float f2 = f + f1;
                    boolean isSweepAttack = this.isSweepAttack(flag, flag2, flag1);
                    float f3 = 0.0f;
                    if (target instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)target;
                        f3 = livingEntity.getHealth();
                    }
                    Vec3 deltaMovement = target.getDeltaMovement();
                    boolean flag3 = target.hurtOrSimulate(damageSource, f2);
                    if (flag3) {
                        this.causeExtraKnockback(target, this.getKnockback(target, damageSource) + (flag1 ? 0.5f : 0.0f), deltaMovement);
                        if (isSweepAttack) {
                            this.doSweepAttack(target, f, damageSource, attackStrengthScale);
                        }
                        this.attackVisualEffects(target, flag2, isSweepAttack, flag, false, f1);
                        this.setLastHurtMob(target);
                        this.itemAttackInteraction(target, weaponItem, damageSource, true);
                        this.damageStatsAndHearts(target, f3);
                        this.causeFoodExhaustion(this.level().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                    } else {
                        this.playServerSideSound(SoundEvents.PLAYER_ATTACK_NODAMAGE);
                    }
                }
                this.lungeForwardMaybe();
            }
        }
    }

    private void playServerSideSound(SoundEvent sound) {
        Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), 1.0f, 1.0f);
    }

    private DamageSource createAttackSource(net.minecraft.world.item.ItemStack stack) {
        return stack.getDamageSource(this, () -> this.damageSources().playerAttack(this));
    }

    private boolean cannotAttack(Entity target) {
        return !target.isAttackable() || target.skipAttackInteraction(this);
    }

    private boolean deflectProjectile(Entity target, BooleanSupplier callEvent) {
        if (target.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if (callEvent.getAsBoolean() && projectile.deflect(ProjectileDeflection.AIM_DEFLECT, this, EntityReference.of(this), true)) {
                this.makeSound(SoundEvents.PLAYER_ATTACK_NODAMAGE);
                return true;
            }
        }
        return false;
    }

    private boolean canCriticalAttack(Entity target) {
        return this.fallDistance > 0.0 && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.isMobilityRestricted() && !this.isPassenger() && target instanceof LivingEntity && !this.isSprinting();
    }

    private boolean isSweepAttack(boolean isStrong, boolean isCritical, boolean extraKnockback) {
        double d1;
        double d;
        if (isStrong && !isCritical && !extraKnockback && this.onGround() && (d = this.getKnownMovement().horizontalDistanceSqr()) < Mth.square(d1 = (double)this.getSpeed() * 2.5)) {
            return this.getItemInHand(InteractionHand.MAIN_HAND).is(ItemTags.SWORDS);
        }
        return false;
    }

    private void attackVisualEffects(Entity target, boolean isCritical, boolean isSweep, boolean isStrong, boolean isStab, float damageAmount) {
        if (isCritical) {
            this.playServerSideSound(SoundEvents.PLAYER_ATTACK_CRIT);
            this.crit(target);
        }
        if (!(isCritical || isSweep || isStab)) {
            this.playServerSideSound(isStrong ? SoundEvents.PLAYER_ATTACK_STRONG : SoundEvents.PLAYER_ATTACK_WEAK);
        }
        if (damageAmount > 0.0f) {
            this.magicCrit(target);
        }
    }

    private void damageStatsAndHearts(Entity target, float previousHealth) {
        if (target instanceof LivingEntity) {
            float f = previousHealth - ((LivingEntity)target).getHealth();
            this.awardStat(Stats.DAMAGE_DEALT, Math.round(f * 10.0f));
            if (this.level() instanceof ServerLevel && f > 2.0f) {
                int i = (int)((double)f * 0.5);
                ((ServerLevel)this.level()).sendParticles(ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY(0.5), target.getZ(), i, 0.1, 0.0, 0.1, 0.2);
            }
        }
    }

    private void itemAttackInteraction(Entity target, net.minecraft.world.item.ItemStack stack, DamageSource damageSource, boolean postAttackEffects) {
        Entity entity = target;
        if (target instanceof EnderDragonPart) {
            entity = ((EnderDragonPart)target).parentMob;
        }
        boolean flag = false;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                flag = stack.hurtEnemy(livingEntity, this);
            }
            if (postAttackEffects) {
                EnchantmentHelper.doPostAttackEffectsWithItemSource(serverLevel, target, damageSource, stack);
            }
        }
        if (!this.level().isClientSide() && !stack.isEmpty() && entity instanceof LivingEntity) {
            if (flag) {
                stack.postHurtEnemy((LivingEntity)entity, this);
            }
            if (stack.isEmpty()) {
                if (stack == this.getMainHandItem()) {
                    this.setItemInHand(InteractionHand.MAIN_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                } else {
                    this.setItemInHand(InteractionHand.OFF_HAND, net.minecraft.world.item.ItemStack.EMPTY);
                }
            }
        }
    }

    @Override
    public void causeExtraKnockback(Entity target, float strength, Vec3 currentMovement) {
        if (strength > 0.0f) {
            if (target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.knockback(strength, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
            } else {
                target.push(-Mth.sin(this.getYRot() * ((float)Math.PI / 180)) * strength, 0.1, Mth.cos(this.getYRot() * ((float)Math.PI / 180)) * strength, this);
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            if (!this.level().paperConfig().misc.disableSprintInterruptionOnAttack) {
                this.setSprinting(false);
            }
        }
        if (target instanceof ServerPlayer && target.hurtMarked) {
            boolean cancelled = false;
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)target.getBukkitEntity();
            Vector velocity = CraftVector.toBukkit(currentMovement);
            PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                cancelled = true;
            } else if (!velocity.equals((Object)event.getVelocity())) {
                player.setVelocity(event.getVelocity());
            }
            if (!cancelled) {
                ((ServerPlayer)target).connection.send(new ClientboundSetEntityMotionPacket(target));
                target.hurtMarked = false;
                target.setDeltaMovement(currentMovement);
            }
        }
    }

    @Override
    public float getVoicePitch() {
        return 1.0f;
    }

    private void doSweepAttack(Entity entity, float damageAmount, DamageSource damageSource, float strengthScale) {
        this.playServerSideSound(SoundEvents.PLAYER_ATTACK_SWEEP);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float var12 = 1.0f + (float)this.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * damageAmount;
            for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                ArmorStand armorStand;
                if (livingEntity == this || livingEntity == entity || this.isAlliedTo(livingEntity) || livingEntity instanceof ArmorStand && (armorStand = (ArmorStand)livingEntity).isMarker() || !(this.distanceToSqr(livingEntity) < 9.0)) continue;
                float f1 = this.getEnchantedDamage(livingEntity, var12, damageSource) * strengthScale;
                livingEntity.lastDamageCancelled = false;
                if (!livingEntity.hurtServer(serverLevel, damageSource.knownCause(EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK), f1) || livingEntity.lastDamageCancelled) continue;
                livingEntity.knockback(0.4f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.SWEEP_ATTACK);
                EnchantmentHelper.doPostAttackEffects(serverLevel, livingEntity, damageSource);
            }
            double d = -Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            double d1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            serverLevel.sendParticles(ParticleTypes.SWEEP_ATTACK, this.getX() + d, this.getY(0.5), this.getZ() + d1, 0, d, 0.0, d1, 0.0);
        }
    }

    protected float getEnchantedDamage(Entity entity, float damage, DamageSource damageSource) {
        return damage;
    }

    @Override
    protected void doAutoAttackOnTouch(LivingEntity target) {
        this.attack(target);
    }

    public void crit(Entity target) {
    }

    private float baseDamageScaleFactor() {
        float attackStrengthScale = this.getAttackStrengthScale(0.5f);
        return 0.2f + attackStrengthScale * attackStrengthScale * 0.8f;
    }

    @Override
    public boolean stabAttack(EquipmentSlot slot, Entity target, float damageAmount, boolean damage, boolean knockback, boolean dismount) {
        boolean flag;
        boolean cannotAttack = this.cannotAttack(target);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((org.bukkit.entity.Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), !cannotAttack);
        if (!playerAttackEntityEvent.callEvent() || cannotAttack) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemBySlot = this.getItemBySlot(slot);
        DamageSource damageSource = this.createAttackSource(itemBySlot);
        float f = this.getEnchantedDamage(target, damageAmount, damageSource) - damageAmount;
        if (!this.isUsingItem() || this.getUsedItemHand().asEquipmentSlot() != slot) {
            f *= this.getAttackStrengthScale(0.5f);
            damageAmount *= this.baseDamageScaleFactor();
        }
        float dmgFinal = f;
        if (knockback && this.deflectProjectile(target, () -> !CraftEventFactory.handleNonLivingEntityDamageEvent(target, damageSource, dmgFinal, false))) {
            return true;
        }
        float f1 = damage ? damageAmount + f : 0.0f;
        float f2 = 0.0f;
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            f2 = livingEntity.getHealth();
        }
        Vec3 deltaMovement = target.getDeltaMovement();
        boolean bl = flag = damage && target.hurtOrSimulate(damageSource, f1);
        if (knockback) {
            this.causeExtraKnockback(target, 0.4f + this.getKnockback(target, damageSource), deltaMovement);
        }
        boolean flag1 = false;
        if (dismount && target.isPassenger()) {
            flag1 = true;
            target.stopRiding();
        }
        if (!(flag || knockback || flag1)) {
            return false;
        }
        this.attackVisualEffects(target, false, false, damage, true, f);
        this.setLastHurtMob(target);
        this.itemAttackInteraction(target, itemBySlot, damageSource, flag);
        this.damageStatsAndHearts(target, f2);
        this.causeFoodExhaustion(this.level().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
        return true;
    }

    public void magicCrit(Entity target) {
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        super.remove(reason, eventCause);
        this.inventoryMenu.removed(this);
        if (this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    @Override
    public boolean isClientAuthoritative() {
        return true;
    }

    @Override
    protected boolean isLocalClientAuthoritative() {
        return this.isLocalPlayer();
    }

    public boolean isLocalPlayer() {
        return false;
    }

    @Override
    public boolean canSimulateMovement() {
        return !this.level().isClientSide() || this.isLocalPlayer();
    }

    @Override
    public boolean isEffectiveAi() {
        return !this.level().isClientSide() || this.isLocalPlayer();
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public NameAndId nameAndId() {
        return new NameAndId(this.gameProfile);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public boolean preventsBlockDrops() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(net.minecraft.world.item.ItemStack carried, net.minecraft.world.item.ItemStack clicked, ClickAction action) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public boolean canDropItems() {
        return true;
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos bedPos) {
        return this.startSleepInBed(bedPos, false);
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos bedPos, boolean force) {
        this.startSleeping(bedPos);
        this.sleepCounter = 0;
        return Either.right(Unit.INSTANCE);
    }

    public void stopSleepInBed(boolean wakeImmediately, boolean updateLevelForSleepingPlayers) {
        super.stopSleeping();
        if (this.level() instanceof ServerLevel && updateLevelForSleepingPlayers) {
            ((ServerLevel)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = wakeImmediately ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(Component message, boolean overlay) {
    }

    public void awardStat(Identifier statKey) {
        this.awardStat(Stats.CUSTOM.get(statKey));
    }

    public void awardStat(Identifier stat, int increment) {
        this.awardStat(Stats.CUSTOM.get(stat), increment);
    }

    public void awardStat(Stat<?> stat) {
        this.awardStat(stat, 1);
    }

    public void awardStat(Stat<?> stat, int increment) {
    }

    public void resetStat(Stat<?> stat) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void awardRecipesByKey(List<ResourceKey<Recipe<?>>> recipes) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void travel(Vec3 travelVector) {
        if (this.isPassenger()) {
            super.travel(travelVector);
        } else {
            double d;
            if (this.isSwimming()) {
                double d1;
                d = this.getLookAngle().y;
                double d2 = d1 = d < -0.2 ? 0.085 : 0.06;
                if (d <= 0.0 || this.jumping || !this.level().getFluidState(BlockPos.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).isEmpty()) {
                    Vec3 deltaMovement = this.getDeltaMovement();
                    this.setDeltaMovement(deltaMovement.add(0.0, (d - deltaMovement.y) * d1, 0.0));
                }
            }
            if (this.getAbilities().flying) {
                d = this.getDeltaMovement().y;
                super.travel(travelVector);
                this.setDeltaMovement(this.getDeltaMovement().with(Direction.Axis.Y, d * 0.6));
            } else {
                super.travel(travelVector);
            }
        }
    }

    @Override
    protected boolean canGlide() {
        return !this.abilities.flying && super.canGlide();
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPos pos) {
        return !this.level().getBlockState(pos).isSuffocating(this.level(), pos);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        double min;
        boolean flag;
        if (this.abilities.mayfly && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0) {
            this.awardStat(Stats.FALL_ONE_CM, (int)Math.round(fallDistance * 100.0));
        }
        boolean bl = flag = this.currentImpulseImpactPos != null && this.ignoreFallDamageFromCurrentImpulse;
        if (flag) {
            boolean flag1;
            min = Math.min(fallDistance, this.currentImpulseImpactPos.y - this.getY());
            boolean bl2 = flag1 = min <= 0.0;
            if (flag1) {
                this.resetCurrentImpulseContext();
            } else {
                this.tryResetCurrentImpulseContext();
            }
        } else {
            min = fallDistance;
        }
        if (min > 0.0 && super.causeFallDamage(min, damageMultiplier, damageSource)) {
            this.resetCurrentImpulseContext();
            return true;
        }
        this.propagateFallToPassengers(fallDistance, damageMultiplier, damageSource);
        return false;
    }

    public boolean tryToStartFallFlying() {
        if (!this.isFallFlying() && this.canGlide() && !this.isInWater()) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.setSharedFlag(7, true);
        } else {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(state);
        } else {
            BlockPos primaryStepSoundBlockPos = this.getPrimaryStepSoundBlockPos(pos);
            if (!pos.equals(primaryStepSoundBlockPos)) {
                BlockState blockState = this.level().getBlockState(primaryStepSoundBlockPos);
                if (blockState.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds(blockState, state);
                } else {
                    super.playStepSound(primaryStepSoundBlockPos, blockState);
                }
            } else {
                super.playStepSound(pos, state);
            }
        }
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(ServerLevel level, LivingEntity entity, DamageSource damageSource) {
        this.awardStat(Stats.ENTITY_KILLED.get(entity.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplier) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(state, motionMultiplier);
        }
        this.tryResetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int xpPoints) {
        this.increaseScore(xpPoints);
        this.experienceProgress += (float)xpPoints / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.clamp(this.totalExperience + xpPoints, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float f = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(net.minecraft.world.item.ItemStack enchantedItem, int levelCost) {
        this.experienceLevel -= levelCost;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int levels) {
        this.experienceLevel = IntMath.saturatedAdd((int)this.experienceLevel, (int)levels);
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (levels > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float f = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            Player.sendSoundEffect(this, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_LEVELUP, this.getSoundSource(), f * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        if (this.experienceLevel >= 30) {
            return 112 + (this.experienceLevel - 30) * 9;
        }
        return this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2;
    }

    private static void sendSoundEffect(Player fromEntity, double x, double y, double z, SoundEvent soundEffect, SoundSource soundCategory, float volume, float pitch) {
        fromEntity.level().playSound((Entity)fromEntity, x, y, z, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)fromEntity;
            serverPlayer.connection.send(new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(soundEffect), soundCategory, x, y, z, volume, pitch, fromEntity.random.nextLong()));
        }
    }

    public void causeFoodExhaustion(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float exhaustion, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.abilities.invulnerable || this.level().isClientSide() || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, exhaustion)).isCancelled())) {
            this.foodData.addExhaustion(event.getExhaustion());
        }
    }

    @Override
    public void lungeForwardMaybe() {
        if (this.hasEnoughFoodToDoExhaustiveManoeuvres()) {
            super.lungeForwardMaybe();
        }
    }

    protected boolean hasEnoughFoodToDoExhaustiveManoeuvres() {
        return this.getFoodData().hasEnoughFood() || this.getAbilities().mayfly;
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean canAlwaysEat) {
        return this.abilities.invulnerable || canAlwaysEat || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPos pos, Direction facing, net.minecraft.world.item.ItemStack stack) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPos blockPos = pos.relative(facing.getOpposite());
        BlockInWorld blockInWorld = new BlockInWorld(this.level(), blockPos, false);
        return stack.canPlaceOnBlockInAdventureMode(blockInWorld);
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel level) {
        return level.getGameRules().get(GameRules.KEEP_INVENTORY) == false && !this.isSpectator() ? Math.min(this.experienceLevel * 7, 100) : 0;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return this.abilities.flying || this.onGround() && this.isDiscrete() ? Entity.MovementEmission.NONE : Entity.MovementEmission.ALL;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public Component getName() {
        return Component.literal(this.gameProfile.name());
    }

    @Override
    public String getPlainTextName() {
        return this.gameProfile.name();
    }

    public PlayerEnderChestContainer getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    protected boolean doesEmitEquipEvent(EquipmentSlot slot) {
        return slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
    }

    public boolean addItem(net.minecraft.world.item.ItemStack stack) {
        return this.inventory.add(stack);
    }

    public abstract @Nullable GameType gameMode();

    @Override
    public boolean isSpectator() {
        return this.gameMode() == GameType.SPECTATOR;
    }

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public boolean isCreative() {
        return this.gameMode() == GameType.CREATIVE;
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    @Override
    public Component getDisplayName() {
        MutableComponent mutableComponent = PlayerTeam.formatNameForTeam(this.getTeam(), this.getName());
        return this.decorateDisplayNameComponent(mutableComponent);
    }

    private MutableComponent decorateDisplayNameComponent(MutableComponent displayName) {
        String string = this.getGameProfile().name();
        return displayName.withStyle(style -> style.withClickEvent(new ClickEvent.SuggestCommand("/tell " + string + " ")).withHoverEvent(this.createHoverEvent()).withInsertion(string));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().name();
    }

    @Override
    protected void internalSetAbsorptionAmount(float absorptionAmount) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(absorptionAmount));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    @Override
    public @Nullable SlotAccess getSlot(int slot) {
        if (slot == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return Player.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack carried) {
                    Player.this.containerMenu.setCarried(carried);
                    return true;
                }
            };
        }
        final int i = slot - 500;
        if (i >= 0 && i < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack get() {
                    return Player.this.inventoryMenu.getCraftSlots().getItem(i);
                }

                @Override
                public boolean set(net.minecraft.world.item.ItemStack carried) {
                    Player.this.inventoryMenu.getCraftSlots().setItem(i, carried);
                    Player.this.inventoryMenu.slotsChanged(Player.this.inventory);
                    return true;
                }
            };
        }
        if (slot >= 0 && slot < this.inventory.getNonEquipmentItems().size()) {
            return this.inventory.getSlot(slot);
        }
        int i1 = slot - 200;
        return i1 >= 0 && i1 < this.enderChestInventory.getContainerSize() ? this.enderChestInventory.getSlot(i1) : super.getSlot(slot);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    @Override
    public void setRemainingFireTicks(int ticks) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(ticks, 1) : ticks);
    }

    protected static Optional<Parrot.Variant> extractParrotVariant(CompoundTag tag) {
        EntityType entityType;
        if (!tag.isEmpty() && (entityType = (EntityType)tag.read("id", EntityType.CODEC).orElse(null)) == EntityType.PARROT) {
            return tag.read("Variant", Parrot.Variant.LEGACY_CODEC);
        }
        return Optional.empty();
    }

    protected static OptionalInt convertParrotVariant(Optional<Parrot.Variant> variant) {
        return variant.map(variant1 -> OptionalInt.of(variant1.getId())).orElse(OptionalInt.empty());
    }

    private static Optional<Parrot.Variant> convertParrotVariant(OptionalInt variantId) {
        return variantId.isPresent() ? Optional.of(Parrot.Variant.byId(variantId.getAsInt())) : Optional.empty();
    }

    public void setShoulderParrotLeft(Optional<Parrot.Variant> variant) {
        this.entityData.set(DATA_SHOULDER_PARROT_LEFT, Player.convertParrotVariant(variant));
    }

    public Optional<Parrot.Variant> getShoulderParrotLeft() {
        return Player.convertParrotVariant(this.entityData.get(DATA_SHOULDER_PARROT_LEFT));
    }

    public void setShoulderParrotRight(Optional<Parrot.Variant> variant) {
        this.entityData.set(DATA_SHOULDER_PARROT_RIGHT, Player.convertParrotVariant(variant));
    }

    public Optional<Parrot.Variant> getShoulderParrotRight() {
        return Player.convertParrotVariant(this.entityData.get(DATA_SHOULDER_PARROT_RIGHT));
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0);
    }

    public boolean cannotAttackWithItem(net.minecraft.world.item.ItemStack stack, int adjustTicks) {
        float orDefault = stack.getOrDefault(DataComponents.MINIMUM_ATTACK_CHARGE, Float.valueOf(0.0f)).floatValue();
        float f = (float)(this.attackStrengthTicker + adjustTicks) / this.getCurrentItemAttackStrengthDelay();
        return orDefault > 0.0f && f < orDefault;
    }

    public float getAttackStrengthScale(float adjustTicks) {
        return Mth.clamp(((float)this.attackStrengthTicker + adjustTicks) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public float getItemSwapScale(float adjustTicks) {
        return Mth.clamp(((float)this.itemSwapTicker + adjustTicks) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
        this.itemSwapTicker = 0;
    }

    @Override
    public void onAttack() {
        super.onAttack();
    }

    public void resetOnlyAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldowns getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return !this.abilities.flying && !this.isFallFlying() ? super.getBlockSpeedFactor() : 1.0f;
    }

    @Override
    public float getLuck() {
        return (float)this.getAttributeValue(Attributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.permissions().hasPermission(Permissions.COMMANDS_GAMEMASTER);
    }

    public PermissionSet permissions() {
        return PermissionSet.NO_PERMISSIONS;
    }

    @Override
    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING);
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack, MutableBoolean cancelled) {
        Player player = this;
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean notCancelled = new PlayerReadyArrowEvent((org.bukkit.entity.Player)serverPlayer.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
        if (!notCancelled) {
            cancelled.setValue(true);
        }
        return notCancelled;
    }

    @Override
    public net.minecraft.world.item.ItemStack getProjectile(net.minecraft.world.item.ItemStack shootable) {
        Player player;
        if (!(shootable.getItem() instanceof ProjectileWeaponItem)) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        MutableBoolean anyEventCancelled = new MutableBoolean();
        Predicate<net.minecraft.world.item.ItemStack> supportedHeldProjectiles = ((ProjectileWeaponItem)shootable.getItem()).getSupportedHeldProjectiles().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        net.minecraft.world.item.ItemStack heldProjectile = ProjectileWeaponItem.getHeldProjectile(this, supportedHeldProjectiles);
        if (!heldProjectile.isEmpty()) {
            return heldProjectile;
        }
        supportedHeldProjectiles = ((ProjectileWeaponItem)shootable.getItem()).getAllSupportedProjectiles().and(item -> this.tryReadyArrow(shootable, (net.minecraft.world.item.ItemStack)item, anyEventCancelled));
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack item2 = this.inventory.getItem(i);
            if (!supportedHeldProjectiles.test(item2)) continue;
            return item2;
        }
        if (anyEventCancelled.booleanValue() && !this.abilities.instabuild && (player = this) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.resyncUsingItem(player2);
        }
        return this.hasInfiniteMaterials() ? new net.minecraft.world.item.ItemStack(Items.ARROW) : net.minecraft.world.item.ItemStack.EMPTY;
    }

    @Override
    public Vec3 getRopeHoldPosition(float partialTick) {
        double d = 0.22 * (this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f = Mth.lerp(partialTick * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float f1 = Mth.lerp(partialTick, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (this.isFallFlying() || this.isAutoSpinAttack()) {
            float f2;
            Vec3 viewVector = this.getViewVector(partialTick);
            Vec3 deltaMovement = this.getDeltaMovement();
            double d1 = deltaMovement.horizontalDistanceSqr();
            double d2 = viewVector.horizontalDistanceSqr();
            if (d1 > 0.0 && d2 > 0.0) {
                double d3 = (deltaMovement.x * viewVector.x + deltaMovement.z * viewVector.z) / Math.sqrt(d1 * d2);
                double d4 = deltaMovement.x * viewVector.z - deltaMovement.z * viewVector.x;
                f2 = (float)(Math.signum(d4) * Math.acos(d3));
            } else {
                f2 = 0.0f;
            }
            return this.getPosition(partialTick).add(new Vec3(d, -0.11, 0.85).zRot(-f2).xRot(-f).yRot(-f1));
        }
        if (this.isVisuallySwimming()) {
            return this.getPosition(partialTick).add(new Vec3(d, 0.2, -0.15).xRot(-f).yRot(-f1));
        }
        double d5 = this.getBoundingBox().getYsize() - 1.0;
        double d1 = this.isCrouching() ? -0.2 : 0.07;
        return this.getPosition(partialTick).add(new Vec3(d, d5, d1).yRot(-f1));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> lastDeathLocation) {
        this.lastDeathLocation = lastDeathLocation;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float yaw) {
        super.animateHurt(yaw);
        this.hurtDir = yaw;
    }

    public boolean isMobilityRestricted() {
        return this.hasEffect(MobEffects.BLINDNESS);
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        if (this.abilities.flying && !this.isPassenger()) {
            return this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed();
        }
        return this.isSprinting() ? 0.025999999f : 0.02f;
    }

    @Override
    public boolean hasContainerOpen(ContainerOpenersCounter openersCounter, BlockPos pos) {
        return openersCounter.isOwnContainer(this);
    }

    @Override
    public double getContainerInteractionRange() {
        return this.blockInteractionRange();
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean isWithinEntityInteractionRange(Entity entity, double buffer) {
        return !entity.isRemoved() && this.isWithinEntityInteractionRange(entity.getBoundingBox(), buffer);
    }

    public boolean isWithinEntityInteractionRange(AABB aabb, double buffer) {
        double d = this.entityInteractionRange() + buffer;
        double d1 = aabb.distanceToSqr(this.getEyePosition());
        return d1 < d * d;
    }

    public boolean isWithinAttackRange(AABB aabb, double buffer) {
        return this.entityAttackRange().isInRange((LivingEntity)this, aabb, buffer);
    }

    public boolean isWithinBlockInteractionRange(BlockPos pos, double buffer) {
        double d = this.blockInteractionRange() + buffer;
        return new AABB(pos).distanceToSqr(this.getEyePosition()) < d * d;
    }

    public void setIgnoreFallDamageFromCurrentImpulse(boolean ignoreFallDamageFromCurrentImpulse) {
        this.ignoreFallDamageFromCurrentImpulse = ignoreFallDamageFromCurrentImpulse;
        if (ignoreFallDamageFromCurrentImpulse) {
            this.applyPostImpulseGraceTime(40);
        } else {
            this.currentImpulseContextResetGraceTime = 0;
        }
    }

    public void applyPostImpulseGraceTime(int ticks) {
        this.currentImpulseContextResetGraceTime = Math.max(this.currentImpulseContextResetGraceTime, ticks);
    }

    public boolean isIgnoringFallDamageFromCurrentImpulse() {
        return this.ignoreFallDamageFromCurrentImpulse;
    }

    public void tryResetCurrentImpulseContext() {
        if (this.currentImpulseContextResetGraceTime == 0) {
            this.resetCurrentImpulseContext();
        }
    }

    public boolean isInPostImpulseGraceTime() {
        return this.currentImpulseContextResetGraceTime > 0;
    }

    public void resetCurrentImpulseContext() {
        this.currentImpulseContextResetGraceTime = 0;
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public boolean shouldRotateWithMinecart() {
        return false;
    }

    @Override
    public boolean onClimbable() {
        return !this.abilities.flying && super.onClimbable();
    }

    public String debugInfo() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getPlainTextName()).add("id", this.getId()).add("pos", (Object)this.position()).add("mode", (Object)this.gameMode()).add("permission", (Object)this.permissions()).toString();
    }

    public record BedSleepingProblem(@Nullable Component message) {
        public static final BedSleepingProblem TOO_FAR_AWAY = new BedSleepingProblem(Component.translatable("block.minecraft.bed.too_far_away"));
        public static final BedSleepingProblem OBSTRUCTED = new BedSleepingProblem(Component.translatable("block.minecraft.bed.obstructed"));
        public static final BedSleepingProblem OTHER_PROBLEM = new BedSleepingProblem(null);
        public static final BedSleepingProblem NOT_SAFE = new BedSleepingProblem(Component.translatable("block.minecraft.bed.not_safe"));
        public static final BedSleepingProblem EXPLOSION = new BedSleepingProblem(null);
    }
}

