/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import io.papermc.paper.inventory.recipe.ItemOrExact;
import io.papermc.paper.inventory.recipe.StackedContentsExtrasMap;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import org.jspecify.annotations.Nullable;

public class StackedItemContents {
    private final StackedContents<ItemOrExact> raw = new StackedContents();
    private @Nullable StackedContentsExtrasMap extrasMap;

    public void initializeExtras(Recipe<?> recipe, @Nullable CraftingInput input) {
        if (this.extrasMap == null) {
            this.extrasMap = new StackedContentsExtrasMap(this.raw);
        }
        this.extrasMap.initialize(recipe);
        if (input != null) {
            this.extrasMap.accountInput(input);
        }
    }

    public void resetExtras() {
        if (this.extrasMap != null && !this.raw.amounts.isEmpty()) {
            this.extrasMap.resetExtras();
        }
    }

    public void accountSimpleStack(ItemStack stack) {
        if (this.extrasMap != null && this.extrasMap.accountStack(stack, Math.min(64, stack.getCount()))) {
            return;
        }
        if (Inventory.isUsableForCrafting(stack)) {
            this.accountStack(stack);
        }
    }

    public void accountStack(ItemStack stack) {
        this.accountStack(stack, stack.getMaxStackSize());
    }

    public void accountStack(ItemStack stack, int maxStackSize) {
        if (!stack.isEmpty()) {
            int min = Math.min(maxStackSize, stack.getCount());
            if (this.extrasMap != null && !stack.getComponentsPatch().isEmpty() && this.extrasMap.accountStack(stack, min)) {
                return;
            }
            this.raw.account(new ItemOrExact.Item(stack.getItemHolder()), min);
        }
    }

    public boolean canCraft(Recipe<?> recipe, @Nullable StackedContents.Output<ItemOrExact> output) {
        return this.canCraft(recipe, 1, output);
    }

    public boolean canCraft(Recipe<?> recipe, int maxCount, @Nullable StackedContents.Output<ItemOrExact> output) {
        PlacementInfo placementInfo = recipe.placementInfo();
        return !placementInfo.isImpossibleToPlace() && this.canCraft(placementInfo.ingredients(), maxCount, output);
    }

    public boolean canCraft(List<? extends StackedContents.IngredientInfo<ItemOrExact>> ingredients, @Nullable StackedContents.Output<ItemOrExact> output) {
        return this.canCraft(ingredients, 1, output);
    }

    private boolean canCraft(List<? extends StackedContents.IngredientInfo<ItemOrExact>> ingredients, int maxCount, @Nullable StackedContents.Output<ItemOrExact> output) {
        return this.raw.tryPick(ingredients, maxCount, output);
    }

    public int getBiggestCraftableStack(Recipe<?> recipe, @Nullable StackedContents.Output<ItemOrExact> output) {
        return this.getBiggestCraftableStack(recipe, Integer.MAX_VALUE, output);
    }

    public int getBiggestCraftableStack(Recipe<?> recipe, int maxCount, @Nullable StackedContents.Output<ItemOrExact> output) {
        return this.raw.tryPickAll(recipe.placementInfo().ingredients(), maxCount, output);
    }

    public void clear() {
        this.raw.clear();
    }
}

