/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public class LlamaSpit
extends Projectile {
    public LlamaSpit(EntityType<? extends LlamaSpit> type, Level level) {
        super((EntityType<? extends Projectile>)type, level);
    }

    public LlamaSpit(Level level, Llama spitter) {
        this((EntityType<? extends LlamaSpit>)EntityType.LLAMA_SPIT, level);
        this.setOwner(spitter);
        this.setPos(spitter.getX() - (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin(spitter.yBodyRot * ((float)Math.PI / 180)), spitter.getEyeY() - (double)0.1f, spitter.getZ() + (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos(spitter.yBodyRot * ((float)Math.PI / 180)));
    }

    @Override
    protected double getDefaultGravity() {
        return 0.06;
    }

    @Override
    public void tick() {
        super.tick();
        Vec3 deltaMovement = this.getDeltaMovement();
        HitResult hitResultOnMoveVector = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        this.preHitTargetOrDeflectSelf(hitResultOnMoveVector);
        double d = this.getX() + deltaMovement.x;
        double d1 = this.getY() + deltaMovement.y;
        double d2 = this.getZ() + deltaMovement.z;
        this.updateRotation();
        float f = 0.99f;
        if (this.level().getBlockStates(this.getBoundingBox()).noneMatch(BlockBehaviour.BlockStateBase::isAir)) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (this.isInWater()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            this.setDeltaMovement(deltaMovement.scale(0.99f));
            this.applyGravity();
            this.setPos(d, d1, d2);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            ServerLevel serverLevel;
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity entity2 = result.getEntity();
            DamageSource damageSource = this.damageSources().spit(this, livingEntity);
            Level level = this.level();
            if (level instanceof ServerLevel && entity2.hurtServer(serverLevel = (ServerLevel)level, damageSource, 1.0f)) {
                EnchantmentHelper.doPostAttackEffects(serverLevel, entity2, damageSource);
            }
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Vec3 movement = packet.getMovement();
        for (int i = 0; i < 7; ++i) {
            double d = 0.4 + 0.1 * (double)i;
            this.level().addParticle(ParticleTypes.SPIT, this.getX(), this.getY(), this.getZ(), movement.x * d, movement.y, movement.z * d);
        }
        this.setDeltaMovement(movement);
    }
}

