/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public final class ProjectileUtil {
    public static final float DEFAULT_ENTITY_HIT_RESULT_MARGIN = 0.3f;

    public static HitResult getHitResultOnMoveVector(Entity projectile, Predicate<Entity> filter) {
        Vec3 deltaMovement = projectile.getDeltaMovement();
        Level level = projectile.level();
        Vec3 vec3 = projectile.position();
        return ProjectileUtil.getHitResult(vec3, projectile, filter, deltaMovement, level, ProjectileUtil.computeMargin(projectile), ClipContext.Block.COLLIDER);
    }

    public static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Entity attacker, AttackRange attackRange, Predicate<Entity> filter, ClipContext.Block clipContext) {
        Vec3 headLookAngle = attacker.getHeadLookAngle();
        Vec3 eyePosition = attacker.getEyePosition();
        Vec3 vec3 = eyePosition.add(headLookAngle.scale(attackRange.effectiveMinRange(attacker)));
        double d = attacker.getKnownMovement().dot(headLookAngle);
        Vec3 vec31 = eyePosition.add(headLookAngle.scale((double)attackRange.effectiveMaxRange(attacker) + Math.max(0.0, d)));
        return ProjectileUtil.getHitEntitiesAlong(attacker, eyePosition, vec3, filter, vec31, attackRange.hitboxMargin(), clipContext);
    }

    public static HitResult getHitResultOnMoveVector(Entity projectile, Predicate<Entity> filter, ClipContext.Block clipContext) {
        Vec3 deltaMovement = projectile.getDeltaMovement();
        Level level = projectile.level();
        Vec3 vec3 = projectile.position();
        return ProjectileUtil.getHitResult(vec3, projectile, filter, deltaMovement, level, ProjectileUtil.computeMargin(projectile), clipContext);
    }

    public static HitResult getHitResultOnViewVector(Entity source, Predicate<Entity> filter, double scale) {
        Vec3 vec3 = source.getViewVector(0.0f).scale(scale);
        Level level = source.level();
        Vec3 eyePosition = source.getEyePosition();
        return ProjectileUtil.getHitResult(eyePosition, source, filter, vec3, level, 0.0f, ClipContext.Block.COLLIDER);
    }

    private static HitResult getHitResult(Vec3 pos, Entity source, Predicate<Entity> filter, Vec3 deltaMovement, Level level, float margin, ClipContext.Block clipContext) {
        EntityHitResult entityHitResult;
        Vec3 vec3 = pos.add(deltaMovement);
        HitResult hitResult = level.clipIncludingBorder(new ClipContext(pos, vec3, clipContext, ClipContext.Fluid.NONE, source));
        if (((HitResult)hitResult).getType() != HitResult.Type.MISS) {
            vec3 = hitResult.getLocation();
        }
        if ((entityHitResult = ProjectileUtil.getEntityHitResult(level, source, pos, vec3, source.getBoundingBox().expandTowards(deltaMovement).inflate(1.0), filter, margin)) != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    private static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Entity source, Vec3 startVec, Vec3 minReachVec, Predicate<Entity> filter, Vec3 maxReachVec, float margin, ClipContext.Block clipContext) {
        Level level = source.level();
        BlockHitResult blockHitResult = level.clipIncludingBorder(new ClipContext(startVec, maxReachVec, clipContext, ClipContext.Fluid.NONE, source));
        if (blockHitResult.getType() != HitResult.Type.MISS && startVec.distanceToSqr(maxReachVec = blockHitResult.getLocation()) < startVec.distanceToSqr(minReachVec)) {
            return Either.left(blockHitResult);
        }
        AABB aabb = AABB.ofSize(minReachVec, margin, margin, margin).expandTowards(maxReachVec.subtract(minReachVec)).inflate(1.0);
        Collection<EntityHitResult> manyEntityHitResult = ProjectileUtil.getManyEntityHitResult(level, source, minReachVec, maxReachVec, aabb, filter, margin, clipContext, true);
        return !manyEntityHitResult.isEmpty() ? Either.right(manyEntityHitResult) : Either.left(blockHitResult);
    }

    public static @Nullable EntityHitResult getEntityHitResult(Entity source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance) {
        Level level = source.level();
        double d = distance;
        Entity entity = null;
        Vec3 vec3 = null;
        for (Entity entity1 : level.getEntities(source, boundingBox, filter)) {
            Vec3 vec31;
            double d1;
            AABB aabb = entity1.getBoundingBox().inflate(entity1.getPickRadius());
            Optional<Vec3> optional = aabb.clip(startVec, endVec);
            if (aabb.contains(startVec)) {
                if (!(d >= 0.0)) continue;
                entity = entity1;
                vec3 = optional.orElse(startVec);
                d = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.distanceToSqr(vec31 = optional.get())) < d) && d != 0.0) continue;
            if (entity1.getRootVehicle() == source.getRootVehicle()) {
                if (d != 0.0) continue;
                entity = entity1;
                vec3 = vec31;
                continue;
            }
            entity = entity1;
            vec3 = vec31;
            d = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vec3);
    }

    public static @Nullable EntityHitResult getEntityHitResult(Level level, Projectile source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        return ProjectileUtil.getEntityHitResult(level, source, startVec, endVec, boundingBox, filter, ProjectileUtil.computeMargin(source));
    }

    public static float computeMargin(Entity entity) {
        return Math.max(0.0f, Math.min(0.3f, (float)(entity.tickCount - 2) / 20.0f));
    }

    public static @Nullable EntityHitResult getEntityHitResult(Level level, Entity source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, float margin) {
        double d = Double.MAX_VALUE;
        Optional<Object> optional = Optional.empty();
        Entity entity = null;
        for (Entity entity1 : level.getEntities(source, boundingBox, filter)) {
            double d1;
            AABB aabb = entity1.getBoundingBox().inflate(margin);
            Optional<Vec3> optional1 = aabb.clip(startVec, endVec);
            if (!optional1.isPresent() || !((d1 = startVec.distanceToSqr(optional1.get())) < d)) continue;
            entity = entity1;
            d = d1;
            optional = optional1;
        }
        return entity == null ? null : new EntityHitResult(entity, (Vec3)optional.get());
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level level, Entity source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, boolean includeFromEntity) {
        return ProjectileUtil.getManyEntityHitResult(level, source, startVec, endVec, boundingBox, filter, ProjectileUtil.computeMargin(source), ClipContext.Block.COLLIDER, includeFromEntity);
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level level, Entity source, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, float margin, ClipContext.Block clipType, boolean includeFromEntity) {
        ArrayList<EntityHitResult> list = new ArrayList<EntityHitResult>();
        for (Entity entity : level.getEntities(source, boundingBox, filter)) {
            Optional<Vec3> optional2;
            Vec3 center;
            Optional<Vec3> optional1;
            AABB boundingBox1 = entity.getBoundingBox();
            if (includeFromEntity && boundingBox1.contains(startVec)) {
                list.add(new EntityHitResult(entity, startVec));
                continue;
            }
            Optional<Vec3> optional = boundingBox1.clip(startVec, endVec);
            if (optional.isPresent()) {
                list.add(new EntityHitResult(entity, optional.get()));
                continue;
            }
            if ((double)margin <= 0.0 || (optional1 = boundingBox1.inflate(margin).clip(startVec, endVec)).isEmpty()) continue;
            Vec3 vec3 = optional1.get();
            BlockHitResult blockHitResult = level.clipIncludingBorder(new ClipContext(vec3, center = boundingBox1.getCenter(), clipType, ClipContext.Fluid.NONE, source));
            if (blockHitResult.getType() != HitResult.Type.MISS) {
                center = blockHitResult.getLocation();
            }
            if (!(optional2 = entity.getBoundingBox().clip(vec3, center)).isPresent()) continue;
            list.add(new EntityHitResult(entity, optional2.get()));
        }
        return list;
    }

    public static void rotateTowardsMovement(Entity projectile, float rotationSpeed) {
        Vec3 deltaMovement = projectile.getDeltaMovement();
        if (deltaMovement.lengthSqr() != 0.0) {
            double d = deltaMovement.horizontalDistance();
            projectile.setYRot((float)(Mth.atan2(deltaMovement.z, deltaMovement.x) * 180.0 / 3.1415927410125732) + 90.0f);
            projectile.setXRot((float)(Mth.atan2(d, deltaMovement.y) * 180.0 / 3.1415927410125732) - 90.0f);
            while (projectile.getXRot() - projectile.xRotO < -180.0f) {
                projectile.xRotO -= 360.0f;
            }
            while (projectile.getXRot() - projectile.xRotO >= 180.0f) {
                projectile.xRotO += 360.0f;
            }
            while (projectile.getYRot() - projectile.yRotO < -180.0f) {
                projectile.yRotO -= 360.0f;
            }
            while (projectile.getYRot() - projectile.yRotO >= 180.0f) {
                projectile.yRotO += 360.0f;
            }
            projectile.setXRot(Mth.lerp(rotationSpeed, projectile.xRotO, projectile.getXRot()));
            projectile.setYRot(Mth.lerp(rotationSpeed, projectile.yRotO, projectile.getYRot()));
        }
    }

    public static InteractionHand getWeaponHoldingHand(LivingEntity shooter, Item weapon) {
        return shooter.getMainHandItem().is(weapon) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static AbstractArrow getMobArrow(LivingEntity shooter, ItemStack arrow, float velocity, @Nullable ItemStack weapon) {
        ArrowItem arrowItem = (ArrowItem)(arrow.getItem() instanceof ArrowItem ? arrow.getItem() : Items.ARROW);
        AbstractArrow abstractArrow = arrowItem.createArrow(shooter.level(), arrow, shooter, weapon);
        abstractArrow.setBaseDamageFromMob(velocity);
        return abstractArrow;
    }
}

