/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import com.destroystokyo.paper.event.entity.EnderDragonFireballHitEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.PowerParticleOption;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.hurtingprojectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class DragonFireball
extends AbstractHurtingProjectile {
    public static final float SPLASH_RANGE = 4.0f;

    public DragonFireball(EntityType<? extends DragonFireball> type, Level level) {
        super((EntityType<? extends AbstractHurtingProjectile>)type, level);
    }

    public DragonFireball(Level level, LivingEntity owner, Vec3 movement) {
        super(EntityType.DRAGON_FIREBALL, owner, movement, level);
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!(result.getType() == HitResult.Type.ENTITY && this.ownedBy(((EntityHitResult)result).getEntity()) || this.level().isClientSide())) {
            List<LivingEntity> entitiesOfClass = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity owner = this.getOwner();
            if (owner instanceof LivingEntity) {
                areaEffectCloud.setOwner((LivingEntity)owner);
            }
            areaEffectCloud.setCustomParticle(PowerParticleOption.create(ParticleTypes.DRAGON_BREATH, 1.0f));
            areaEffectCloud.setRadius(3.0f);
            areaEffectCloud.setDuration(600);
            areaEffectCloud.setRadiusPerTick((7.0f - areaEffectCloud.getRadius()) / (float)areaEffectCloud.getDuration());
            areaEffectCloud.setPotionDurationScale(0.25f);
            areaEffectCloud.addEffect(new MobEffectInstance(MobEffects.INSTANT_DAMAGE, 1, 1));
            if (!entitiesOfClass.isEmpty()) {
                for (LivingEntity livingEntity : entitiesOfClass) {
                    double d = this.distanceToSqr(livingEntity);
                    if (!(d < 16.0)) continue;
                    areaEffectCloud.setPos(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                    break;
                }
            }
            if (new EnderDragonFireballHitEvent((org.bukkit.entity.DragonFireball)this.getBukkitEntity(), (Collection)entitiesOfClass.stream().map(LivingEntity::getBukkitLivingEntity).collect(Collectors.toList()), (org.bukkit.entity.AreaEffectCloud)areaEffectCloud.getBukkitEntity()).callEvent()) {
                this.level().levelEvent(2006, this.blockPosition(), this.isSilent() ? -1 : 1);
                this.level().addFreshEntity(areaEffectCloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
            } else {
                areaEffectCloud.discard(null);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return PowerParticleOption.create(ParticleTypes.DRAGON_BREATH, 1.0f);
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }
}

