/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class ThrownLingeringPotion
extends AbstractThrownPotion {
    public ThrownLingeringPotion(EntityType<? extends ThrownLingeringPotion> type, Level level) {
        super((EntityType<? extends AbstractThrownPotion>)type, level);
    }

    public ThrownLingeringPotion(Level level, LivingEntity owner, ItemStack item) {
        super(EntityType.LINGERING_POTION, level, owner, item);
    }

    public ThrownLingeringPotion(Level level, double x, double y, double z, ItemStack item) {
        super(EntityType.LINGERING_POTION, level, x, y, z, item);
    }

    @Override
    public Item getDefaultItem() {
        return Items.LINGERING_POTION;
    }

    @Override
    public boolean onHitAsPotion(ServerLevel level, ItemStack stack, HitResult hitResult) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            areaEffectCloud.setOwner(livingEntity);
        }
        areaEffectCloud.setRadius(3.0f);
        areaEffectCloud.setRadiusOnUse(-0.5f);
        areaEffectCloud.setDuration(600);
        areaEffectCloud.setWaitTime(10);
        areaEffectCloud.setRadiusPerTick(-areaEffectCloud.getRadius() / (float)areaEffectCloud.getDuration());
        areaEffectCloud.applyComponentsFromItemStack(stack);
        boolean noEffects = this.getItem().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).hasEffects();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, hitResult, areaEffectCloud);
        if (!(event.isCancelled() || areaEffectCloud.isRemoved() || !event.allowsEmptyCreation() && noEffects && !areaEffectCloud.potionContents.hasEffects())) {
            level.addFreshEntity(areaEffectCloud);
        } else {
            areaEffectCloud.discard(null);
        }
        return !event.isCancelled();
    }
}

