/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.inventory.BrewingSimpleContainerData;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.craftbukkit.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.inventory.view.CraftBrewingStandView;
import org.bukkit.entity.HumanEntity;

public class BrewingStandMenu
extends AbstractContainerMenu {
    static final Identifier EMPTY_SLOT_FUEL = Identifier.withDefaultNamespace("container/slot/brewing_fuel");
    static final Identifier EMPTY_SLOT_POTION = Identifier.withDefaultNamespace("container/slot/potion");
    private static final int BOTTLE_SLOT_START = 0;
    private static final int BOTTLE_SLOT_END = 2;
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int SLOT_COUNT = 5;
    private static final int DATA_COUNT = 2;
    private static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    private final Container brewingStand;
    public final ContainerData brewingStandData;
    private final Slot ingredientSlot;
    @Nullable
    private CraftBrewingStandView view = null;
    private final Inventory inventory;

    public BrewingStandMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, new SimpleContainer(5), new BrewingSimpleContainerData());
    }

    public BrewingStandMenu(int containerId, Inventory playerInventory, Container brewingStandContainer, final ContainerData brewingStandData) {
        super(MenuType.BREWING_STAND, containerId);
        this.inventory = playerInventory;
        BrewingStandMenu.checkContainerSize(brewingStandContainer, 5);
        BrewingStandMenu.checkContainerDataCount(brewingStandData, 3);
        this.brewingStand = brewingStandContainer;
        this.brewingStandData = brewingStandData;
        PotionBrewing potionBrewing = playerInventory.player.level().potionBrewing();
        this.addSlot(new PotionSlot(brewingStandContainer, 0, 56, 51, potionBrewing));
        this.addSlot(new PotionSlot(brewingStandContainer, 1, 79, 58, potionBrewing));
        this.addSlot(new PotionSlot(brewingStandContainer, 2, 102, 51, potionBrewing));
        this.ingredientSlot = this.addSlot(new IngredientsSlot(potionBrewing, brewingStandContainer, 3, 79, 17));
        this.addSlot(new FuelSlot(brewingStandContainer, 4, 17, 17));
        this.addDataSlots(new SimpleContainerData(this, 2){

            @Override
            public int get(int index) {
                if (index == 0) {
                    return 400 * brewingStandData.get(index) / brewingStandData.get(2);
                }
                return brewingStandData.get(index);
            }

            @Override
            public void set(int index, int value) {
                brewingStandData.set(index, value);
            }
        });
        this.addStandardInventorySlots(playerInventory, 8, 84);
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return this.brewingStand.stillValid(player);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack item = slot.getItem();
            itemStack = item.copy();
            if ((slotIndex < 0 || slotIndex > 2) && slotIndex != 3 && slotIndex != 4) {
                if (FuelSlot.mayPlaceItem(itemStack) ? this.moveItemStackTo(item, 4, 5, false) || this.ingredientSlot.mayPlace(item) && !this.moveItemStackTo(item, 3, 4, false) : (this.ingredientSlot.mayPlace(item) ? !this.moveItemStackTo(item, 3, 4, false) : (PotionSlot.mayPlaceItem(itemStack, this.inventory.player.level().potionBrewing()) ? !this.moveItemStackTo(item, 0, 3, false) : (slotIndex >= 5 && slotIndex < 32 ? !this.moveItemStackTo(item, 32, 41, false) : (slotIndex >= 32 && slotIndex < 41 ? !this.moveItemStackTo(item, 5, 32, false) : !this.moveItemStackTo(item, 5, 41, false)))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(item, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(item, itemStack);
            }
            if (item.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (item.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack);
        }
        return itemStack;
    }

    public int getFuel() {
        return this.brewingStandData.get(1);
    }

    public int getBrewingTicks() {
        return this.brewingStandData.get(0);
    }

    @Override
    public CraftBrewingStandView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryBrewer inventory = new CraftInventoryBrewer(this.brewingStand);
        this.view = new CraftBrewingStandView((HumanEntity)this.inventory.player.getBukkitEntity(), inventory, this);
        return this.view;
    }

    static class PotionSlot
    extends Slot {
        private final PotionBrewing potionBrewing;

        public PotionSlot(Container container, int slot, int x, int y, PotionBrewing potionBrewing) {
            super(container, slot, x, y);
            this.potionBrewing = potionBrewing;
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return PotionSlot.mayPlaceItem(stack, this.potionBrewing);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void onTake(Player player, ItemStack stack) {
            Optional<Holder<Potion>> optional = stack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
            if (optional.isPresent() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.BREWED_POTION.trigger(serverPlayer, optional.get());
            }
            super.onTake(player, stack);
        }

        public static boolean mayPlaceItem(ItemStack stack, PotionBrewing potionBrewing) {
            return stack.is(Items.POTION) || stack.is(Items.SPLASH_POTION) || stack.is(Items.LINGERING_POTION) || stack.is(Items.GLASS_BOTTLE) || potionBrewing.isCustomInput(stack);
        }

        @Override
        public Identifier getNoItemIcon() {
            return EMPTY_SLOT_POTION;
        }
    }

    static class IngredientsSlot
    extends Slot {
        private final PotionBrewing potionBrewing;

        public IngredientsSlot(PotionBrewing potionBrewing, Container container, int slot, int x, int y) {
            super(container, slot, x, y);
            this.potionBrewing = potionBrewing;
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return this.potionBrewing.isIngredient(stack);
        }
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return FuelSlot.mayPlaceItem(stack);
        }

        public static boolean mayPlaceItem(ItemStack stack) {
            return stack.is(ItemTags.BREWING_FUEL);
        }

        @Override
        public Identifier getNoItemIcon() {
            return EMPTY_SLOT_FUEL;
        }
    }
}

