/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(clickedPos = context.getClickedPos());
        if (!blockState.is(Blocks.END_PORTAL_FRAME) || blockState.getValue(EndPortalFrameBlock.HAS_EYE).booleanValue()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockState blockState1 = (BlockState)blockState.setValue(EndPortalFrameBlock.HAS_EYE, true);
        if (!CraftEventFactory.callEntityChangeBlockEvent(context.getPlayer(), clickedPos, blockState1)) {
            return InteractionResult.PASS;
        }
        Block.pushEntitiesUp(blockState, blockState1, level, clickedPos);
        level.setBlock(clickedPos, blockState1, 2);
        level.updateNeighbourForOutputSignal(clickedPos, Blocks.END_PORTAL_FRAME);
        context.getItemInHand().shrink(1);
        level.levelEvent(1503, clickedPos, 0);
        BlockPattern.BlockPatternMatch blockPatternMatch = EndPortalFrameBlock.getOrCreatePortalShape().find(level, clickedPos);
        if (blockPatternMatch != null) {
            BlockPos blockPos = blockPatternMatch.getFrontTopLeft().offset(-3, 0, -3);
            for (int i = 0; i < 3; ++i) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    BlockPos blockPos1 = blockPos.offset(i, 0, i1);
                    level.destroyBlock(blockPos1, true, null);
                    level.setBlock(blockPos1, Blocks.END_PORTAL.defaultBlockState(), 2);
                }
            }
            int viewDistance = level.getCraftServer().getViewDistance() * 16;
            BlockPos soundPos = blockPos.offset(1, 0, 1);
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.getPlayersForGlobalSoundGamerule()) {
                double deltaX = (double)soundPos.getX() - player.getX();
                double deltaZ = (double)soundPos.getZ() - player.getZ();
                double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                double soundRadiusSquared = serverLevel.getGlobalSoundRangeSquared(config -> config.endPortalSoundRadius);
                if (!serverLevel.getGameRules().get(GameRules.GLOBAL_SOUND_EVENTS).booleanValue() && distanceSquared > soundRadiusSquared) continue;
                if (distanceSquared > (double)(viewDistance * viewDistance)) {
                    double deltaLength = Math.sqrt(distanceSquared);
                    double relativeX = player.getX() + deltaX / deltaLength * (double)viewDistance;
                    double relativeZ = player.getZ() + deltaZ / deltaLength * (double)viewDistance;
                    player.connection.send(new ClientboundLevelEventPacket(1038, new BlockPos((int)relativeX, soundPos.getY(), (int)relativeZ), 0, true));
                    continue;
                }
                player.connection.send(new ClientboundLevelEventPacket(1038, soundPos, 0, true));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 0;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        BlockHitResult playerPovHitResult = EnderEyeItem.getPlayerPOVHitResult(level, player, ClipContext.Fluid.NONE);
        if (playerPovHitResult.getType() == HitResult.Type.BLOCK && level.getBlockState(playerPovHitResult.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResult.PASS;
        }
        player.startUsingItem(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = serverLevel.findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, player.blockPosition(), 100, false);
            if (blockPos == null) {
                return InteractionResult.CONSUME;
            }
            EyeOfEnder eyeOfEnder = new EyeOfEnder(level, player.getX(), player.getY(0.5), player.getZ());
            eyeOfEnder.setItem(itemInHand);
            eyeOfEnder.signalTo(Vec3.atLowerCornerOf(blockPos));
            level.gameEvent(GameEvent.PROJECTILE_SHOOT, eyeOfEnder.position(), GameEvent.Context.of(player));
            if (!level.addFreshEntity(eyeOfEnder)) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.USED_ENDER_EYE.trigger(serverPlayer, blockPos);
            }
            float f = Mth.lerp(level.random.nextFloat(), 0.33f, 0.5f);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 1.0f, f);
            itemInHand.consume(1, player);
            player.awardStat(Stats.ITEM_USED.get(this));
        }
        return InteractionResult.SUCCESS_SERVER;
    }
}

