/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

public class FishingRodItem
extends Item {
    public FishingRodItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (player.fishing != null) {
            if (!level.isClientSide()) {
                int i = player.fishing.retrieve(itemInHand, hand);
                itemInHand.hurtAndBreak(i, (LivingEntity)player, hand.asEquipmentSlot());
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            itemInHand.causeUseVibration(player, GameEvent.ITEM_INTERACT_FINISH);
        } else {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int i1 = (int)(EnchantmentHelper.getFishingTimeReduction(serverLevel, itemInHand, player) * 20.0f);
                int fishingLuckBonus = EnchantmentHelper.getFishingLuckBonus(serverLevel, itemInHand, player);
                FishingHook fishingHook = new FishingHook(player, level, fishingLuckBonus, i1);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)player.getBukkitEntity(), null, (FishHook)fishingHook.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), PlayerFishEvent.State.FISHING);
                level.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    player.fishing = null;
                    return InteractionResult.PASS;
                }
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                Projectile.spawnProjectile(fishingHook, serverLevel, itemInHand);
            }
            player.awardStat(Stats.ITEM_USED.get(this));
            itemInHand.causeUseVibration(player, GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResult.SUCCESS;
    }
}

