/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.game.ClientboundCooldownPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Projectile;

public class WindChargeItem
extends Item
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 1.5f;

    public WindChargeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.Delayed<WindCharge> windCharge = net.minecraft.world.entity.projectile.Projectile.spawnProjectileFromRotationDelayed((level1, owner, spawnedFrom) -> new WindCharge(player, level, player.position().x(), player.getEyePosition().y(), player.position().z()), serverLevel, itemInHand, player, 0.0f, PROJECTILE_SHOOT_POWER, 1.0f);
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemInHand), (Projectile)windCharge.projectile().getBukkitEntity());
            if (!event.callEvent() || !windCharge.attemptSpawn()) {
                player.containerMenu.forceHeldSlot(hand);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send(new ClientboundCooldownPacket(player.getCooldowns().getCooldownGroup(itemInHand), 0));
                }
                return InteractionResult.FAIL;
            }
            player.awardStat(Stats.ITEM_USED.get(this));
            if (event.shouldConsume()) {
                itemInHand.consume(1, player);
            } else if (!player.hasInfiniteMaterials()) {
                player.containerMenu.forceHeldSlot(hand);
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        return InteractionResult.SUCCESS;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        RandomSource random = level.getRandom();
        double d = random.triangle((double)direction.getStepX(), 0.11485000000000001);
        double d1 = random.triangle((double)direction.getStepY(), 0.11485000000000001);
        double d2 = random.triangle((double)direction.getStepZ(), 0.11485000000000001);
        Vec3 vec3 = new Vec3(d, d1, d2);
        WindCharge windCharge = new WindCharge(level, pos.x(), pos.y(), pos.z(), vec3);
        windCharge.setDeltaMovement(vec3);
        return windCharge;
    }

    @Override
    public void shoot(net.minecraft.world.entity.projectile.Projectile projectile, double x, double y, double z, float velocity, float inaccuracy) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction((source, direction) -> DispenserBlock.getDispensePosition(source, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).overrideDispenseEvent(1051).build();
    }
}

