/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public record KineticWeapon(int contactCooldownTicks, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final int HIT_FEEDBACK_TICKS = 10;
    public static final Codec<KineticWeapon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::contactCooldownTicks), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::delayTicks), (App)Condition.CODEC.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::dismountConditions), (App)Condition.CODEC.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::knockbackConditions), (App)Condition.CODEC.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::damageConditions), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::forwardMovement), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::damageMultiplier), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(KineticWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(KineticWeapon::hitSound)).apply((Applicative)instance, KineticWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, KineticWeapon::contactCooldownTicks, ByteBufCodecs.VAR_INT, KineticWeapon::delayTicks, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::dismountConditions, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::knockbackConditions, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::damageConditions, ByteBufCodecs.FLOAT, KineticWeapon::forwardMovement, ByteBufCodecs.FLOAT, KineticWeapon::damageMultiplier, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::sound, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::hitSound, KineticWeapon::new);

    public static Vec3 getMotion(Entity entity) {
        if (!(entity instanceof Player) && entity.isPassenger()) {
            entity = entity.getRootVehicle();
        }
        return entity.getKnownSpeed().scale(20.0);
    }

    public void makeSound(Entity entity) {
        this.sound.ifPresent(holder -> entity.level().playSound(entity, entity.getX(), entity.getY(), entity.getZ(), (Holder<SoundEvent>)holder, entity.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeLocalHitSound(Entity entity) {
        this.hitSound.ifPresent(holder -> entity.level().playLocalSound(entity, (SoundEvent)holder.value(), entity.getSoundSource(), 1.0f, 1.0f));
    }

    public int computeDamageUseDuration() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    public void damageEntities(ItemStack stack, int remainingUseDuration, LivingEntity entity, EquipmentSlot slot) {
        int i = stack.getUseDuration(entity) - remainingUseDuration;
        if (i >= this.delayTicks) {
            i -= this.delayTicks;
            Vec3 lookAngle = entity.getLookAngle();
            double d = lookAngle.dot(KineticWeapon.getMotion(entity));
            float f = entity instanceof Player ? 1.0f : 0.2f;
            AttackRange attackRange = entity.entityAttackRange();
            double attributeBaseValue = entity.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            boolean flag = false;
            for (EntityHitResult entityHitResult : ProjectileUtil.getHitEntitiesAlong(entity, attackRange, entity2 -> PiercingWeapon.canHitEntity(entity, entity2), ClipContext.Block.COLLIDER).map(blockHitResult -> List.of(), collection -> collection)) {
                boolean flag4;
                boolean flag1;
                Entity entity1 = entityHitResult.getEntity();
                if (entity1 instanceof EnderDragonPart) {
                    EnderDragonPart enderDragonPart = (EnderDragonPart)entity1;
                    entity1 = enderDragonPart.parentMob;
                }
                if (flag1 = entity.wasRecentlyStabbed(entity1, this.contactCooldownTicks)) continue;
                entity.rememberStabbedEntity(entity1);
                double d1 = lookAngle.dot(KineticWeapon.getMotion(entity1));
                double max = Math.max(0.0, d - d1);
                boolean flag2 = this.dismountConditions.isPresent() && this.dismountConditions.get().test(i, d, max, f);
                boolean flag3 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().test(i, d, max, f);
                boolean bl = flag4 = this.damageConditions.isPresent() && this.damageConditions.get().test(i, d, max, f);
                if (!flag2 && !flag3 && !flag4) continue;
                float f1 = (float)attributeBaseValue + (float)Mth.floor(max * (double)this.damageMultiplier);
                flag |= entity.stabAttack(slot, entity1, f1, flag4, flag3, flag2);
            }
            if (flag) {
                entity.level().broadcastEntityEvent(entity, (byte)2);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    CriteriaTriggers.SPEAR_MOBS_TRIGGER.trigger(serverPlayer, entity.stabbedEntities(entity2 -> entity2 instanceof LivingEntity));
                }
            }
        }
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_duration_ticks").forGetter(Condition::maxDurationTicks), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minSpeed), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minRelativeSpeed)).apply((Applicative)instance, Condition::new));
        public static final StreamCodec<ByteBuf, Condition> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, Condition::maxDurationTicks, ByteBufCodecs.FLOAT, Condition::minSpeed, ByteBufCodecs.FLOAT, Condition::minRelativeSpeed, Condition::new);

        public boolean test(int durationTicks, double speed, double relativeSpeed, double speedMultiplier) {
            return durationTicks <= this.maxDurationTicks && speed >= (double)this.minSpeed * speedMultiplier && relativeSpeed >= (double)this.minRelativeSpeed * speedMultiplier;
        }

        public static Optional<Condition> ofAttackerSpeed(int maxDurationTicks, float minSpeed) {
            return Optional.of(new Condition(maxDurationTicks, minSpeed, 0.0f));
        }

        public static Optional<Condition> ofRelativeSpeed(int maxDurationTicks, float minRelativeSpeed) {
            return Optional.of(new Condition(maxDurationTicks, 0.0f, minRelativeSpeed));
        }
    }
}

