/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class RecipeManager
extends SimplePreparableReloadListener<RecipeMap>
implements RecipeAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceKey<RecipePropertySet>, IngredientExtractor> RECIPE_PROPERTY_SETS = Map.of(RecipePropertySet.SMITHING_ADDITION, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = smithingRecipe.additionIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_BASE, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = Optional.of(smithingRecipe.baseIngredient());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.SMITHING_TEMPLATE, recipe -> {
        Optional<Object> optional;
        if (recipe instanceof SmithingRecipe) {
            SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
            optional = smithingRecipe.templateIngredient();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }, RecipePropertySet.FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.SMELTING), RecipePropertySet.BLAST_FURNACE_INPUT, RecipeManager.forSingleInput(RecipeType.BLASTING), RecipePropertySet.SMOKER_INPUT, RecipeManager.forSingleInput(RecipeType.SMOKING), RecipePropertySet.CAMPFIRE_INPUT, RecipeManager.forSingleInput(RecipeType.CAMPFIRE_COOKING));
    private static final FileToIdConverter RECIPE_LISTER = FileToIdConverter.registry(Registries.RECIPE);
    private final HolderLookup.Provider registries;
    public RecipeMap recipes = RecipeMap.EMPTY;
    private Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySets = Map.of();
    private SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes = SelectableRecipe.SingleInputSet.empty();
    private List<ServerDisplayInfo> allDisplays = List.of();
    private Map<ResourceKey<Recipe<?>>, List<ServerDisplayInfo>> recipeToDisplay = Map.of();
    private FeatureFlagSet featureflagset;

    public RecipeManager(HolderLookup.Provider registries) {
        this.registries = registries;
    }

    @Override
    protected RecipeMap prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        TreeMap<Identifier, Recipe> map = new TreeMap<Identifier, Recipe>();
        SimpleJsonResourceReloadListener.scanDirectory(resourceManager, RECIPE_LISTER, this.registries.createSerializationContext(JsonOps.INSTANCE), Recipe.CODEC, map);
        ArrayList list = new ArrayList(map.size());
        map.forEach((location, recipe) -> {
            ResourceKey<Recipe<?>> resourceKey = ResourceKey.create(Registries.RECIPE, location);
            RecipeHolder<Recipe> recipeHolder = new RecipeHolder<Recipe>(resourceKey, (Recipe)recipe);
            list.add(recipeHolder);
        });
        return RecipeMap.create(list);
    }

    @Override
    protected void apply(RecipeMap object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.recipes = object;
        LOGGER.info("Loaded {} recipes", (Object)object.values().size());
    }

    public void addRecipe(RecipeHolder<?> holder) {
        AsyncCatcher.catchOp("Recipe Add");
        this.recipes.addRecipe(holder);
        this.finalizeRecipeLoading();
    }

    public void finalizeRecipeLoading() {
        if (this.featureflagset != null) {
            this.finalizeRecipeLoading(this.featureflagset);
            MinecraftServer.getServer().getPlayerList().reloadResources();
        }
    }

    public void finalizeRecipeLoading(FeatureFlagSet enabledFeatures) {
        this.featureflagset = enabledFeatures;
        ArrayList list = new ArrayList();
        List<IngredientCollector> list1 = RECIPE_PROPERTY_SETS.entrySet().stream().map(entry -> new IngredientCollector((ResourceKey)entry.getKey(), (IngredientExtractor)entry.getValue())).toList();
        this.recipes.values().forEach(recipe -> {
            Object recipe1 = recipe.value();
            if (!recipe1.isSpecial() && recipe1.placementInfo().isImpossibleToPlace()) {
                LOGGER.warn("Recipe {} can't be placed due to empty ingredients and will be ignored", (Object)recipe.id().identifier());
            } else {
                StonecutterRecipe stonecutterRecipe;
                list1.forEach(collector -> collector.accept((Recipe<?>)recipe1));
                if (recipe1 instanceof StonecutterRecipe && RecipeManager.isIngredientEnabled(enabledFeatures, (stonecutterRecipe = (StonecutterRecipe)recipe1).input()) && stonecutterRecipe.resultDisplay().isEnabled(enabledFeatures)) {
                    list.add(new SelectableRecipe.SingleInputEntry(stonecutterRecipe.input(), new SelectableRecipe(stonecutterRecipe.resultDisplay(), Optional.of(recipe))));
                }
            }
        });
        this.propertySets = list1.stream().collect(Collectors.toUnmodifiableMap(collector -> collector.key, collector -> collector.asPropertySet(enabledFeatures)));
        this.stonecutterRecipes = new SelectableRecipe.SingleInputSet(list);
        this.allDisplays = RecipeManager.unpackRecipeInfo(this.recipes.values(), enabledFeatures);
        this.recipeToDisplay = this.allDisplays.stream().collect(Collectors.groupingBy(displayInfo -> displayInfo.parent.id(), IdentityHashMap::new, Collectors.toList()));
    }

    static List<Ingredient> filterDisabled(FeatureFlagSet enabledFeatures, List<Ingredient> ingredients) {
        ingredients.removeIf(ingredient -> !RecipeManager.isIngredientEnabled(enabledFeatures, ingredient));
        return ingredients;
    }

    private static boolean isIngredientEnabled(FeatureFlagSet enabledFeatures, Ingredient ingredient) {
        return ingredient.items().allMatch(item -> ((Item)item.value()).isEnabled(enabledFeatures));
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipeType, I input, Level level, @Nullable ResourceKey<Recipe<?>> recipe) {
        RecipeHolder<T> recipeHolder = recipe != null ? this.byKeyTyped(recipeType, recipe) : null;
        return this.getRecipeFor(recipeType, input, level, recipeHolder);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipeType, I input, Level level, @Nullable RecipeHolder<T> lastRecipe) {
        return lastRecipe != null && lastRecipe.value().matches(input, level) ? Optional.of(lastRecipe) : this.getRecipeFor(recipeType, input, level);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> recipeType, I input, Level level) {
        List<RecipeHolder<T>> list = this.recipes.getRecipesFor(recipeType, input, level).toList();
        return list.isEmpty() ? Optional.empty() : Optional.of(list.getLast());
    }

    public Optional<RecipeHolder<?>> byKey(ResourceKey<Recipe<?>> key) {
        return Optional.ofNullable(this.recipes.byKey(key));
    }

    private <T extends Recipe<?>> @Nullable RecipeHolder<T> byKeyTyped(RecipeType<T> type, ResourceKey<Recipe<?>> key) {
        RecipeHolder<?> recipeHolder = this.recipes.byKey(key);
        return recipeHolder != null && recipeHolder.value().getType().equals(type) ? recipeHolder : null;
    }

    public Map<ResourceKey<RecipePropertySet>, RecipePropertySet> getSynchronizedItemProperties() {
        return this.propertySets;
    }

    public SelectableRecipe.SingleInputSet<StonecutterRecipe> getSynchronizedStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    @Override
    public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> propertySet) {
        return this.propertySets.getOrDefault(propertySet, RecipePropertySet.EMPTY);
    }

    @Override
    public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.recipes.values();
    }

    public @Nullable ServerDisplayInfo getRecipeFromDisplay(RecipeDisplayId display) {
        int index = display.index();
        return index >= 0 && index < this.allDisplays.size() ? this.allDisplays.get(index) : null;
    }

    public void listDisplaysForRecipe(ResourceKey<Recipe<?>> recipe, Consumer<RecipeDisplayEntry> output) {
        List<ServerDisplayInfo> list = this.recipeToDisplay.get(recipe);
        if (list != null) {
            list.forEach(displayInfo -> output.accept(displayInfo.display));
        }
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceKey<Recipe<?>> recipe, JsonObject json, HolderLookup.Provider registries) {
        Recipe recipe1 = (Recipe)Recipe.CODEC.parse(registries.createSerializationContext(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>(recipe, recipe1);
    }

    public boolean removeRecipe(ResourceKey<Recipe<?>> mcKey) {
        boolean removed = this.recipes.removeRecipe(mcKey);
        if (removed) {
            this.finalizeRecipeLoading();
        }
        return removed;
    }

    public void clearRecipes() {
        this.recipes = RecipeMap.create(Collections.emptyList());
        this.finalizeRecipeLoading();
    }

    public static <I extends RecipeInput, T extends Recipe<I>> CachedCheck<I, T> createCheck(final RecipeType<T> recipeType) {
        return new CachedCheck<I, T>(){
            private @Nullable ResourceKey<Recipe<?>> lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(I input, ServerLevel level) {
                RecipeManager recipeManager = level.recipeAccess();
                Optional recipeFor = recipeManager.getRecipeFor(recipeType, input, (Level)level, this.lastRecipe);
                if (recipeFor.isPresent()) {
                    RecipeHolder recipeHolder = recipeFor.get();
                    this.lastRecipe = recipeHolder.id();
                    return Optional.of(recipeHolder);
                }
                return Optional.empty();
            }
        };
    }

    private static List<ServerDisplayInfo> unpackRecipeInfo(Iterable<RecipeHolder<?>> recipes, FeatureFlagSet enabledFeatures) {
        ArrayList<ServerDisplayInfo> list = new ArrayList<ServerDisplayInfo>();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (RecipeHolder<?> recipeHolder : recipes) {
            Object recipe = recipeHolder.value();
            OptionalInt optionalInt = recipe.group().isEmpty() ? OptionalInt.empty() : OptionalInt.of(map.computeIfAbsent((Object)recipe.group(), arg_0 -> RecipeManager.lambda$unpackRecipeInfo$13((Object2IntMap)map, arg_0)));
            Optional<Object> optional = recipe.isSpecial() ? Optional.empty() : Optional.of(recipe.placementInfo().ingredients());
            for (RecipeDisplay recipeDisplay : recipe.display()) {
                if (!recipeDisplay.isEnabled(enabledFeatures)) continue;
                int size = list.size();
                RecipeDisplayId recipeDisplayId = new RecipeDisplayId(size);
                RecipeDisplayEntry recipeDisplayEntry = new RecipeDisplayEntry(recipeDisplayId, recipeDisplay, optionalInt, recipe.recipeBookCategory(), optional);
                list.add(new ServerDisplayInfo(recipeDisplayEntry, recipeHolder));
            }
        }
        return list;
    }

    private static IngredientExtractor forSingleInput(RecipeType<? extends SingleItemRecipe> recipeType) {
        return recipe -> {
            Optional<Object> optional;
            if (recipe.getType() == recipeType && recipe instanceof SingleItemRecipe) {
                SingleItemRecipe singleItemRecipe = (SingleItemRecipe)recipe;
                optional = Optional.of(singleItemRecipe.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        };
    }

    private static /* synthetic */ int lambda$unpackRecipeInfo$13(Object2IntMap map, Object object) {
        return map.size();
    }

    public record ServerDisplayInfo(RecipeDisplayEntry display, RecipeHolder<?> parent) {
    }

    @FunctionalInterface
    public static interface IngredientExtractor {
        public Optional<Ingredient> apply(Recipe<?> var1);
    }

    public static class IngredientCollector
    implements Consumer<Recipe<?>> {
        final ResourceKey<RecipePropertySet> key;
        private final IngredientExtractor extractor;
        private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

        protected IngredientCollector(ResourceKey<RecipePropertySet> key, IngredientExtractor extractor) {
            this.key = key;
            this.extractor = extractor;
        }

        @Override
        public void accept(Recipe<?> recipe) {
            this.extractor.apply(recipe).ifPresent(this.ingredients::add);
        }

        public RecipePropertySet asPropertySet(FeatureFlagSet enabledFeatures) {
            return RecipePropertySet.create(RecipeManager.filterDisabled(enabledFeatures, this.ingredients));
        }
    }

    public static interface CachedCheck<I extends RecipeInput, T extends Recipe<I>> {
        public Optional<RecipeHolder<T>> getRecipeFor(I var1, ServerLevel var2);
    }
}

