/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;

public record ScaleExponentially(LevelBasedValue base, LevelBasedValue exponent) implements EnchantmentValueEffect
{
    public static final MapCodec<ScaleExponentially> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("base").forGetter(ScaleExponentially::base), (App)LevelBasedValue.CODEC.fieldOf("exponent").forGetter(ScaleExponentially::exponent)).apply((Applicative)instance, ScaleExponentially::new));

    @Override
    public float process(int enchantmentLevel, RandomSource random, float value) {
        return (float)((double)value * Math.pow(this.base.calculate(enchantmentLevel), this.exponent.calculate(enchantmentLevel)));
    }

    public MapCodec<ScaleExponentially> codec() {
        return CODEC;
    }
}

